/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a model packaging job. For more information, see <a>DescribeModelPackagingJob</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelPackagingDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelPackagingDescription.Builder, ModelPackagingDescription> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(ModelPackagingDescription::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(ModelPackagingDescription::projectName))
            .setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(ModelPackagingDescription::modelVersion))
            .setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<ModelPackagingConfiguration> MODEL_PACKAGING_CONFIGURATION_FIELD = SdkField
            .<ModelPackagingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ModelPackagingConfiguration")
            .getter(getter(ModelPackagingDescription::modelPackagingConfiguration))
            .setter(setter(Builder::modelPackagingConfiguration))
            .constructor(ModelPackagingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackagingConfiguration")
                    .build()).build();

    private static final SdkField<String> MODEL_PACKAGING_JOB_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ModelPackagingJobDescription")
            .getter(getter(ModelPackagingDescription::modelPackagingJobDescription))
            .setter(setter(Builder::modelPackagingJobDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackagingJobDescription")
                    .build()).build();

    private static final SdkField<String> MODEL_PACKAGING_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackagingMethod").getter(getter(ModelPackagingDescription::modelPackagingMethod))
            .setter(setter(Builder::modelPackagingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackagingMethod").build())
            .build();

    private static final SdkField<ModelPackagingOutputDetails> MODEL_PACKAGING_OUTPUT_DETAILS_FIELD = SdkField
            .<ModelPackagingOutputDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ModelPackagingOutputDetails")
            .getter(getter(ModelPackagingDescription::modelPackagingOutputDetails))
            .setter(setter(Builder::modelPackagingOutputDetails))
            .constructor(ModelPackagingOutputDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackagingOutputDetails")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ModelPackagingDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ModelPackagingDescription::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimestamp").getter(getter(ModelPackagingDescription::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(ModelPackagingDescription::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            PROJECT_NAME_FIELD, MODEL_VERSION_FIELD, MODEL_PACKAGING_CONFIGURATION_FIELD, MODEL_PACKAGING_JOB_DESCRIPTION_FIELD,
            MODEL_PACKAGING_METHOD_FIELD, MODEL_PACKAGING_OUTPUT_DETAILS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD,
            CREATION_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("JobName", JOB_NAME_FIELD);
                    put("ProjectName", PROJECT_NAME_FIELD);
                    put("ModelVersion", MODEL_VERSION_FIELD);
                    put("ModelPackagingConfiguration", MODEL_PACKAGING_CONFIGURATION_FIELD);
                    put("ModelPackagingJobDescription", MODEL_PACKAGING_JOB_DESCRIPTION_FIELD);
                    put("ModelPackagingMethod", MODEL_PACKAGING_METHOD_FIELD);
                    put("ModelPackagingOutputDetails", MODEL_PACKAGING_OUTPUT_DETAILS_FIELD);
                    put("Status", STATUS_FIELD);
                    put("StatusMessage", STATUS_MESSAGE_FIELD);
                    put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
                    put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final String projectName;

    private final String modelVersion;

    private final ModelPackagingConfiguration modelPackagingConfiguration;

    private final String modelPackagingJobDescription;

    private final String modelPackagingMethod;

    private final ModelPackagingOutputDetails modelPackagingOutputDetails;

    private final String status;

    private final String statusMessage;

    private final Instant creationTimestamp;

    private final Instant lastUpdatedTimestamp;

    private ModelPackagingDescription(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.projectName = builder.projectName;
        this.modelVersion = builder.modelVersion;
        this.modelPackagingConfiguration = builder.modelPackagingConfiguration;
        this.modelPackagingJobDescription = builder.modelPackagingJobDescription;
        this.modelPackagingMethod = builder.modelPackagingMethod;
        this.modelPackagingOutputDetails = builder.modelPackagingOutputDetails;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTimestamp = builder.creationTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The name of the model packaging job.
     * </p>
     * 
     * @return The name of the model packaging job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The name of the project that's associated with a model that's in the model package.
     * </p>
     * 
     * @return The name of the project that's associated with a model that's in the model package.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The version of the model used in the model packaging job.
     * </p>
     * 
     * @return The version of the model used in the model packaging job.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The configuration information used in the model packaging job.
     * </p>
     * 
     * @return The configuration information used in the model packaging job.
     */
    public final ModelPackagingConfiguration modelPackagingConfiguration() {
        return modelPackagingConfiguration;
    }

    /**
     * <p>
     * The description for the model packaging job.
     * </p>
     * 
     * @return The description for the model packaging job.
     */
    public final String modelPackagingJobDescription() {
        return modelPackagingJobDescription;
    }

    /**
     * <p>
     * The AWS service used to package the job. Currently Lookout for Vision can package jobs with AWS IoT Greengrass.
     * </p>
     * 
     * @return The AWS service used to package the job. Currently Lookout for Vision can package jobs with AWS IoT
     *         Greengrass.
     */
    public final String modelPackagingMethod() {
        return modelPackagingMethod;
    }

    /**
     * <p>
     * Information about the output of the model packaging job. For more information, see
     * <a>DescribeModelPackagingJob</a>.
     * </p>
     * 
     * @return Information about the output of the model packaging job. For more information, see
     *         <a>DescribeModelPackagingJob</a>.
     */
    public final ModelPackagingOutputDetails modelPackagingOutputDetails() {
        return modelPackagingOutputDetails;
    }

    /**
     * <p>
     * The status of the model packaging job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelPackagingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the model packaging job.
     * @see ModelPackagingJobStatus
     */
    public final ModelPackagingJobStatus status() {
        return ModelPackagingJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the model packaging job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelPackagingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the model packaging job.
     * @see ModelPackagingJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message for the model packaging job.
     * </p>
     * 
     * @return The status message for the model packaging job.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The Unix timestamp for the time and date that the model packaging job was created.
     * </p>
     * 
     * @return The Unix timestamp for the time and date that the model packaging job was created.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The Unix timestamp for the time and date that the model packaging job was last updated.
     * </p>
     * 
     * @return The Unix timestamp for the time and date that the model packaging job was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackagingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackagingJobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackagingMethod());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackagingOutputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackagingDescription)) {
            return false;
        }
        ModelPackagingDescription other = (ModelPackagingDescription) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(projectName(), other.projectName())
                && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(modelPackagingConfiguration(), other.modelPackagingConfiguration())
                && Objects.equals(modelPackagingJobDescription(), other.modelPackagingJobDescription())
                && Objects.equals(modelPackagingMethod(), other.modelPackagingMethod())
                && Objects.equals(modelPackagingOutputDetails(), other.modelPackagingOutputDetails())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelPackagingDescription").add("JobName", jobName()).add("ProjectName", projectName())
                .add("ModelVersion", modelVersion()).add("ModelPackagingConfiguration", modelPackagingConfiguration())
                .add("ModelPackagingJobDescription", modelPackagingJobDescription())
                .add("ModelPackagingMethod", modelPackagingMethod())
                .add("ModelPackagingOutputDetails", modelPackagingOutputDetails()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("CreationTimestamp", creationTimestamp())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "ModelPackagingConfiguration":
            return Optional.ofNullable(clazz.cast(modelPackagingConfiguration()));
        case "ModelPackagingJobDescription":
            return Optional.ofNullable(clazz.cast(modelPackagingJobDescription()));
        case "ModelPackagingMethod":
            return Optional.ofNullable(clazz.cast(modelPackagingMethod()));
        case "ModelPackagingOutputDetails":
            return Optional.ofNullable(clazz.cast(modelPackagingOutputDetails()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackagingDescription, T> g) {
        return obj -> g.apply((ModelPackagingDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelPackagingDescription> {
        /**
         * <p>
         * The name of the model packaging job.
         * </p>
         * 
         * @param jobName
         *        The name of the model packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The name of the project that's associated with a model that's in the model package.
         * </p>
         * 
         * @param projectName
         *        The name of the project that's associated with a model that's in the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The version of the model used in the model packaging job.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model used in the model packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * The configuration information used in the model packaging job.
         * </p>
         * 
         * @param modelPackagingConfiguration
         *        The configuration information used in the model packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackagingConfiguration(ModelPackagingConfiguration modelPackagingConfiguration);

        /**
         * <p>
         * The configuration information used in the model packaging job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelPackagingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModelPackagingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelPackagingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #modelPackagingConfiguration(ModelPackagingConfiguration)}.
         * 
         * @param modelPackagingConfiguration
         *        a consumer that will call methods on {@link ModelPackagingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelPackagingConfiguration(ModelPackagingConfiguration)
         */
        default Builder modelPackagingConfiguration(Consumer<ModelPackagingConfiguration.Builder> modelPackagingConfiguration) {
            return modelPackagingConfiguration(ModelPackagingConfiguration.builder().applyMutation(modelPackagingConfiguration)
                    .build());
        }

        /**
         * <p>
         * The description for the model packaging job.
         * </p>
         * 
         * @param modelPackagingJobDescription
         *        The description for the model packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackagingJobDescription(String modelPackagingJobDescription);

        /**
         * <p>
         * The AWS service used to package the job. Currently Lookout for Vision can package jobs with AWS IoT
         * Greengrass.
         * </p>
         * 
         * @param modelPackagingMethod
         *        The AWS service used to package the job. Currently Lookout for Vision can package jobs with AWS IoT
         *        Greengrass.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackagingMethod(String modelPackagingMethod);

        /**
         * <p>
         * Information about the output of the model packaging job. For more information, see
         * <a>DescribeModelPackagingJob</a>.
         * </p>
         * 
         * @param modelPackagingOutputDetails
         *        Information about the output of the model packaging job. For more information, see
         *        <a>DescribeModelPackagingJob</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackagingOutputDetails(ModelPackagingOutputDetails modelPackagingOutputDetails);

        /**
         * <p>
         * Information about the output of the model packaging job. For more information, see
         * <a>DescribeModelPackagingJob</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelPackagingOutputDetails.Builder}
         * avoiding the need to create one manually via {@link ModelPackagingOutputDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelPackagingOutputDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #modelPackagingOutputDetails(ModelPackagingOutputDetails)}.
         * 
         * @param modelPackagingOutputDetails
         *        a consumer that will call methods on {@link ModelPackagingOutputDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelPackagingOutputDetails(ModelPackagingOutputDetails)
         */
        default Builder modelPackagingOutputDetails(Consumer<ModelPackagingOutputDetails.Builder> modelPackagingOutputDetails) {
            return modelPackagingOutputDetails(ModelPackagingOutputDetails.builder().applyMutation(modelPackagingOutputDetails)
                    .build());
        }

        /**
         * <p>
         * The status of the model packaging job.
         * </p>
         * 
         * @param status
         *        The status of the model packaging job.
         * @see ModelPackagingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackagingJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the model packaging job.
         * </p>
         * 
         * @param status
         *        The status of the model packaging job.
         * @see ModelPackagingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackagingJobStatus
         */
        Builder status(ModelPackagingJobStatus status);

        /**
         * <p>
         * The status message for the model packaging job.
         * </p>
         * 
         * @param statusMessage
         *        The status message for the model packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The Unix timestamp for the time and date that the model packaging job was created.
         * </p>
         * 
         * @param creationTimestamp
         *        The Unix timestamp for the time and date that the model packaging job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The Unix timestamp for the time and date that the model packaging job was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The Unix timestamp for the time and date that the model packaging job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private String projectName;

        private String modelVersion;

        private ModelPackagingConfiguration modelPackagingConfiguration;

        private String modelPackagingJobDescription;

        private String modelPackagingMethod;

        private ModelPackagingOutputDetails modelPackagingOutputDetails;

        private String status;

        private String statusMessage;

        private Instant creationTimestamp;

        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackagingDescription model) {
            jobName(model.jobName);
            projectName(model.projectName);
            modelVersion(model.modelVersion);
            modelPackagingConfiguration(model.modelPackagingConfiguration);
            modelPackagingJobDescription(model.modelPackagingJobDescription);
            modelPackagingMethod(model.modelPackagingMethod);
            modelPackagingOutputDetails(model.modelPackagingOutputDetails);
            status(model.status);
            statusMessage(model.statusMessage);
            creationTimestamp(model.creationTimestamp);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final ModelPackagingConfiguration.Builder getModelPackagingConfiguration() {
            return modelPackagingConfiguration != null ? modelPackagingConfiguration.toBuilder() : null;
        }

        public final void setModelPackagingConfiguration(ModelPackagingConfiguration.BuilderImpl modelPackagingConfiguration) {
            this.modelPackagingConfiguration = modelPackagingConfiguration != null ? modelPackagingConfiguration.build() : null;
        }

        @Override
        public final Builder modelPackagingConfiguration(ModelPackagingConfiguration modelPackagingConfiguration) {
            this.modelPackagingConfiguration = modelPackagingConfiguration;
            return this;
        }

        public final String getModelPackagingJobDescription() {
            return modelPackagingJobDescription;
        }

        public final void setModelPackagingJobDescription(String modelPackagingJobDescription) {
            this.modelPackagingJobDescription = modelPackagingJobDescription;
        }

        @Override
        public final Builder modelPackagingJobDescription(String modelPackagingJobDescription) {
            this.modelPackagingJobDescription = modelPackagingJobDescription;
            return this;
        }

        public final String getModelPackagingMethod() {
            return modelPackagingMethod;
        }

        public final void setModelPackagingMethod(String modelPackagingMethod) {
            this.modelPackagingMethod = modelPackagingMethod;
        }

        @Override
        public final Builder modelPackagingMethod(String modelPackagingMethod) {
            this.modelPackagingMethod = modelPackagingMethod;
            return this;
        }

        public final ModelPackagingOutputDetails.Builder getModelPackagingOutputDetails() {
            return modelPackagingOutputDetails != null ? modelPackagingOutputDetails.toBuilder() : null;
        }

        public final void setModelPackagingOutputDetails(ModelPackagingOutputDetails.BuilderImpl modelPackagingOutputDetails) {
            this.modelPackagingOutputDetails = modelPackagingOutputDetails != null ? modelPackagingOutputDetails.build() : null;
        }

        @Override
        public final Builder modelPackagingOutputDetails(ModelPackagingOutputDetails modelPackagingOutputDetails) {
            this.modelPackagingOutputDetails = modelPackagingOutputDetails;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelPackagingJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        @Override
        public ModelPackagingDescription build() {
            return new ModelPackagingDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
