/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describe an Amazon Lookout for Vision project. For more information, see <a>DescribeProject</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ProjectDescription.Builder, ProjectDescription> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectArn").getter(getter(ProjectDescription::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(ProjectDescription::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimestamp").getter(getter(ProjectDescription::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<List<DatasetMetadata>> DATASETS_FIELD = SdkField
            .<List<DatasetMetadata>> builder(MarshallingType.LIST)
            .memberName("Datasets")
            .getter(getter(ProjectDescription::datasets))
            .setter(setter(Builder::datasets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datasets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            PROJECT_NAME_FIELD, CREATION_TIMESTAMP_FIELD, DATASETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ProjectArn", PROJECT_ARN_FIELD);
                    put("ProjectName", PROJECT_NAME_FIELD);
                    put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
                    put("Datasets", DATASETS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String projectArn;

    private final String projectName;

    private final Instant creationTimestamp;

    private final List<DatasetMetadata> datasets;

    private ProjectDescription(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.projectName = builder.projectName;
        this.creationTimestamp = builder.creationTimestamp;
        this.datasets = builder.datasets;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The name of the project.
     * </p>
     * 
     * @return The name of the project.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The unix timestamp for the date and time that the project was created.
     * </p>
     * 
     * @return The unix timestamp for the date and time that the project was created.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Datasets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDatasets() {
        return datasets != null && !(datasets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of datasets in the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasets} method.
     * </p>
     * 
     * @return A list of datasets in the project.
     */
    public final List<DatasetMetadata> datasets() {
        return datasets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasets() ? datasets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDescription)) {
            return false;
        }
        ProjectDescription other = (ProjectDescription) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(projectName(), other.projectName())
                && Objects.equals(creationTimestamp(), other.creationTimestamp()) && hasDatasets() == other.hasDatasets()
                && Objects.equals(datasets(), other.datasets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectDescription").add("ProjectArn", projectArn()).add("ProjectName", projectName())
                .add("CreationTimestamp", creationTimestamp()).add("Datasets", hasDatasets() ? datasets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "Datasets":
            return Optional.ofNullable(clazz.cast(datasets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProjectDescription, T> g) {
        return obj -> g.apply((ProjectDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectDescription> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The name of the project.
         * </p>
         * 
         * @param projectName
         *        The name of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The unix timestamp for the date and time that the project was created.
         * </p>
         * 
         * @param creationTimestamp
         *        The unix timestamp for the date and time that the project was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * A list of datasets in the project.
         * </p>
         * 
         * @param datasets
         *        A list of datasets in the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasets(Collection<DatasetMetadata> datasets);

        /**
         * <p>
         * A list of datasets in the project.
         * </p>
         * 
         * @param datasets
         *        A list of datasets in the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasets(DatasetMetadata... datasets);

        /**
         * <p>
         * A list of datasets in the project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutvision.model.DatasetMetadata.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lookoutvision.model.DatasetMetadata#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutvision.model.DatasetMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #datasets(List<DatasetMetadata>)}.
         * 
         * @param datasets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutvision.model.DatasetMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasets(java.util.Collection<DatasetMetadata>)
         */
        Builder datasets(Consumer<DatasetMetadata.Builder>... datasets);
    }

    static final class BuilderImpl implements Builder {
        private String projectArn;

        private String projectName;

        private Instant creationTimestamp;

        private List<DatasetMetadata> datasets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectDescription model) {
            projectArn(model.projectArn);
            projectName(model.projectName);
            creationTimestamp(model.creationTimestamp);
            datasets(model.datasets);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final List<DatasetMetadata.Builder> getDatasets() {
            List<DatasetMetadata.Builder> result = DatasetMetadataListCopier.copyToBuilder(this.datasets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasets(Collection<DatasetMetadata.BuilderImpl> datasets) {
            this.datasets = DatasetMetadataListCopier.copyFromBuilder(datasets);
        }

        @Override
        public final Builder datasets(Collection<DatasetMetadata> datasets) {
            this.datasets = DatasetMetadataListCopier.copy(datasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(DatasetMetadata... datasets) {
            datasets(Arrays.asList(datasets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(Consumer<DatasetMetadata.Builder>... datasets) {
            datasets(Stream.of(datasets).map(c -> DatasetMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProjectDescription build() {
            return new ProjectDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
