/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDatasetEntriesRequest extends LookoutVisionRequest implements
        ToCopyableBuilder<UpdateDatasetEntriesRequest.Builder, UpdateDatasetEntriesRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(UpdateDatasetEntriesRequest::projectName))
            .setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()).build();

    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetType").getter(getter(UpdateDatasetEntriesRequest::datasetType))
            .setter(setter(Builder::datasetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetType").build()).build();

    private static final SdkField<SdkBytes> CHANGES_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Changes").getter(getter(UpdateDatasetEntriesRequest::changes)).setter(setter(Builder::changes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Changes").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(UpdateDatasetEntriesRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            DATASET_TYPE_FIELD, CHANGES_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("projectName", PROJECT_NAME_FIELD);
                    put("datasetType", DATASET_TYPE_FIELD);
                    put("Changes", CHANGES_FIELD);
                    put("X-Amzn-Client-Token", CLIENT_TOKEN_FIELD);
                }
            });

    private final String projectName;

    private final String datasetType;

    private final SdkBytes changes;

    private final String clientToken;

    private UpdateDatasetEntriesRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.datasetType = builder.datasetType;
        this.changes = builder.changes;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the project that contains the dataset that you want to update.
     * </p>
     * 
     * @return The name of the project that contains the dataset that you want to update.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The type of the dataset that you want to update. Specify <code>train</code> to update the training dataset.
     * Specify <code>test</code> to update the test dataset. If you have a single dataset project, specify
     * <code>train</code>.
     * </p>
     * 
     * @return The type of the dataset that you want to update. Specify <code>train</code> to update the training
     *         dataset. Specify <code>test</code> to update the test dataset. If you have a single dataset project,
     *         specify <code>train</code>.
     */
    public final String datasetType() {
        return datasetType;
    }

    /**
     * <p>
     * The entries to add to the dataset.
     * </p>
     * 
     * @return The entries to add to the dataset.
     */
    public final SdkBytes changes() {
        return changes;
    }

    /**
     * <p>
     * ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code> completes only once.
     * You choose the value to pass. For example, An issue might prevent you from getting a response from
     * <code>UpdateDatasetEntries</code>. In this case, safely retry your call to <code>UpdateDatasetEntries</code> by
     * using the same <code>ClientToken</code> parameter value.
     * </p>
     * <p>
     * If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This
     * prevents retries after a network error from making multiple updates with the same dataset entries. You'll need to
     * provide your own value for other use cases.
     * </p>
     * <p>
     * An error occurs if the other input parameters are not the same as in the first request. Using a different value
     * for <code>ClientToken</code> is considered a new call to <code>UpdateDatasetEntries</code>. An idempotency token
     * is active for 8 hours.
     * </p>
     * 
     * @return ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code> completes
     *         only once. You choose the value to pass. For example, An issue might prevent you from getting a response
     *         from <code>UpdateDatasetEntries</code>. In this case, safely retry your call to
     *         <code>UpdateDatasetEntries</code> by using the same <code>ClientToken</code> parameter value.</p>
     *         <p>
     *         If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for
     *         you. This prevents retries after a network error from making multiple updates with the same dataset
     *         entries. You'll need to provide your own value for other use cases.
     *         </p>
     *         <p>
     *         An error occurs if the other input parameters are not the same as in the first request. Using a different
     *         value for <code>ClientToken</code> is considered a new call to <code>UpdateDatasetEntries</code>. An
     *         idempotency token is active for 8 hours.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetType());
        hashCode = 31 * hashCode + Objects.hashCode(changes());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasetEntriesRequest)) {
            return false;
        }
        UpdateDatasetEntriesRequest other = (UpdateDatasetEntriesRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(datasetType(), other.datasetType())
                && Objects.equals(changes(), other.changes()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDatasetEntriesRequest").add("ProjectName", projectName())
                .add("DatasetType", datasetType()).add("Changes", changes()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "DatasetType":
            return Optional.ofNullable(clazz.cast(datasetType()));
        case "Changes":
            return Optional.ofNullable(clazz.cast(changes()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasetEntriesRequest, T> g) {
        return obj -> g.apply((UpdateDatasetEntriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDatasetEntriesRequest> {
        /**
         * <p>
         * The name of the project that contains the dataset that you want to update.
         * </p>
         * 
         * @param projectName
         *        The name of the project that contains the dataset that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The type of the dataset that you want to update. Specify <code>train</code> to update the training dataset.
         * Specify <code>test</code> to update the test dataset. If you have a single dataset project, specify
         * <code>train</code>.
         * </p>
         * 
         * @param datasetType
         *        The type of the dataset that you want to update. Specify <code>train</code> to update the training
         *        dataset. Specify <code>test</code> to update the test dataset. If you have a single dataset project,
         *        specify <code>train</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetType(String datasetType);

        /**
         * <p>
         * The entries to add to the dataset.
         * </p>
         * 
         * @param changes
         *        The entries to add to the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(SdkBytes changes);

        /**
         * <p>
         * ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code> completes only
         * once. You choose the value to pass. For example, An issue might prevent you from getting a response from
         * <code>UpdateDatasetEntries</code>. In this case, safely retry your call to <code>UpdateDatasetEntries</code>
         * by using the same <code>ClientToken</code> parameter value.
         * </p>
         * <p>
         * If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you.
         * This prevents retries after a network error from making multiple updates with the same dataset entries.
         * You'll need to provide your own value for other use cases.
         * </p>
         * <p>
         * An error occurs if the other input parameters are not the same as in the first request. Using a different
         * value for <code>ClientToken</code> is considered a new call to <code>UpdateDatasetEntries</code>. An
         * idempotency token is active for 8 hours.
         * </p>
         * 
         * @param clientToken
         *        ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code> completes
         *        only once. You choose the value to pass. For example, An issue might prevent you from getting a
         *        response from <code>UpdateDatasetEntries</code>. In this case, safely retry your call to
         *        <code>UpdateDatasetEntries</code> by using the same <code>ClientToken</code> parameter value.</p>
         *        <p>
         *        If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value
         *        for you. This prevents retries after a network error from making multiple updates with the same
         *        dataset entries. You'll need to provide your own value for other use cases.
         *        </p>
         *        <p>
         *        An error occurs if the other input parameters are not the same as in the first request. Using a
         *        different value for <code>ClientToken</code> is considered a new call to
         *        <code>UpdateDatasetEntries</code>. An idempotency token is active for 8 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutVisionRequest.BuilderImpl implements Builder {
        private String projectName;

        private String datasetType;

        private SdkBytes changes;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasetEntriesRequest model) {
            super(model);
            projectName(model.projectName);
            datasetType(model.datasetType);
            changes(model.changes);
            clientToken(model.clientToken);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getDatasetType() {
            return datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        public final ByteBuffer getChanges() {
            return changes == null ? null : changes.asByteBuffer();
        }

        public final void setChanges(ByteBuffer changes) {
            changes(changes == null ? null : SdkBytes.fromByteBuffer(changes));
        }

        @Override
        public final Builder changes(SdkBytes changes) {
            this.changes = changes;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasetEntriesRequest build() {
            return new UpdateDatasetEntriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
