/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelRequest extends LookoutVisionRequest implements
        ToCopyableBuilder<CreateModelRequest.Builder, CreateModelRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(CreateModelRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateModelRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateModelRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.<OutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OutputConfig").getter(getter(CreateModelRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(OutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateModelRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateModelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, OUTPUT_CONFIG_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String projectName;

    private final String description;

    private final String clientToken;

    private final OutputConfig outputConfig;

    private final String kmsKeyId;

    private final List<Tag> tags;

    private CreateModelRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.outputConfig = builder.outputConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the project in which you want to create a model version.
     * </p>
     * 
     * @return The name of the project in which you want to create a model version.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * A description for the version of the model.
     * </p>
     * 
     * @return A description for the version of the model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once. You
     * choose the value to pass. For example, An issue might prevent you from getting a response from
     * <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by using the same
     * <code>ClientToken</code> parameter value.
     * </p>
     * <p>
     * If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This
     * prevents retries after a network error from starting multiple training jobs. You'll need to provide your own
     * value for other use cases.
     * </p>
     * <p>
     * An error occurs if the other input parameters are not the same as in the first request. Using a different value
     * for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency token is active
     * for 8 hours.
     * </p>
     * 
     * @return ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once.
     *         You choose the value to pass. For example, An issue might prevent you from getting a response from
     *         <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by using the
     *         same <code>ClientToken</code> parameter value. </p>
     *         <p>
     *         If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for
     *         you. This prevents retries after a network error from starting multiple training jobs. You'll need to
     *         provide your own value for other use cases.
     *         </p>
     *         <p>
     *         An error occurs if the other input parameters are not the same as in the first request. Using a different
     *         value for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency
     *         token is active for 8 hours.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The location where Amazon Lookout for Vision saves the training results.
     * </p>
     * 
     * @return The location where Amazon Lookout for Vision saves the training results.
     */
    public final OutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The identifier for your AWS KMS key. The key is used to encrypt training and test images copied into the service
     * for model training. Your source images are unaffected. If this parameter is not specified, the copied images are
     * encrypted by a key that AWS owns and manages.
     * </p>
     * 
     * @return The identifier for your AWS KMS key. The key is used to encrypt training and test images copied into the
     *         service for model training. Your source images are unaffected. If this parameter is not specified, the
     *         copied images are encrypted by a key that AWS owns and manages.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of tags (key-value pairs) that you want to attach to the model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of tags (key-value pairs) that you want to attach to the model.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelRequest)) {
            return false;
        }
        CreateModelRequest other = (CreateModelRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(description(), other.description())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelRequest").add("ProjectName", projectName()).add("Description", description())
                .add("ClientToken", clientToken()).add("OutputConfig", outputConfig()).add("KmsKeyId", kmsKeyId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("X-Amzn-Client-Token", CLIENT_TOKEN_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateModelRequest, T> g) {
        return obj -> g.apply((CreateModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateModelRequest> {
        /**
         * <p>
         * The name of the project in which you want to create a model version.
         * </p>
         * 
         * @param projectName
         *        The name of the project in which you want to create a model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * A description for the version of the model.
         * </p>
         * 
         * @param description
         *        A description for the version of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once. You
         * choose the value to pass. For example, An issue might prevent you from getting a response from
         * <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by using the same
         * <code>ClientToken</code> parameter value.
         * </p>
         * <p>
         * If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you.
         * This prevents retries after a network error from starting multiple training jobs. You'll need to provide your
         * own value for other use cases.
         * </p>
         * <p>
         * An error occurs if the other input parameters are not the same as in the first request. Using a different
         * value for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency token
         * is active for 8 hours.
         * </p>
         * 
         * @param clientToken
         *        ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only
         *        once. You choose the value to pass. For example, An issue might prevent you from getting a response
         *        from <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by
         *        using the same <code>ClientToken</code> parameter value. </p>
         *        <p>
         *        If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value
         *        for you. This prevents retries after a network error from starting multiple training jobs. You'll need
         *        to provide your own value for other use cases.
         *        </p>
         *        <p>
         *        An error occurs if the other input parameters are not the same as in the first request. Using a
         *        different value for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An
         *        idempotency token is active for 8 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The location where Amazon Lookout for Vision saves the training results.
         * </p>
         * 
         * @param outputConfig
         *        The location where Amazon Lookout for Vision saves the training results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OutputConfig outputConfig);

        /**
         * <p>
         * The location where Amazon Lookout for Vision saves the training results.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputConfig.Builder} avoiding the need
         * to create one manually via {@link OutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(OutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OutputConfig)
         */
        default Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return outputConfig(OutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The identifier for your AWS KMS key. The key is used to encrypt training and test images copied into the
         * service for model training. Your source images are unaffected. If this parameter is not specified, the copied
         * images are encrypted by a key that AWS owns and manages.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier for your AWS KMS key. The key is used to encrypt training and test images copied into
         *        the service for model training. Your source images are unaffected. If this parameter is not specified,
         *        the copied images are encrypted by a key that AWS owns and manages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A set of tags (key-value pairs) that you want to attach to the model.
         * </p>
         * 
         * @param tags
         *        A set of tags (key-value pairs) that you want to attach to the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A set of tags (key-value pairs) that you want to attach to the model.
         * </p>
         * 
         * @param tags
         *        A set of tags (key-value pairs) that you want to attach to the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A set of tags (key-value pairs) that you want to attach to the model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutvision.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lookoutvision.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutvision.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutvision.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutVisionRequest.BuilderImpl implements Builder {
        private String projectName;

        private String description;

        private String clientToken;

        private OutputConfig outputConfig;

        private String kmsKeyId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelRequest model) {
            super(model);
            projectName(model.projectName);
            description(model.description);
            clientToken(model.clientToken);
            outputConfig(model.outputConfig);
            kmsKeyId(model.kmsKeyId);
            tags(model.tags);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelRequest build() {
            return new CreateModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
