/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetRequest extends LookoutVisionRequest implements
        ToCopyableBuilder<DescribeDatasetRequest.Builder, DescribeDatasetRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(DescribeDatasetRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()).build();

    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetType").getter(getter(DescribeDatasetRequest::datasetType)).setter(setter(Builder::datasetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            DATASET_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String projectName;

    private final String datasetType;

    private DescribeDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.datasetType = builder.datasetType;
    }

    /**
     * <p>
     * The name of the project that contains the dataset that you want to describe.
     * </p>
     * 
     * @return The name of the project that contains the dataset that you want to describe.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The type of the dataset to describe. Specify <code>train</code> to describe the training dataset. Specify
     * <code>test</code> to describe the test dataset. If you have a single dataset project, specify <code>train</code>
     * </p>
     * 
     * @return The type of the dataset to describe. Specify <code>train</code> to describe the training dataset. Specify
     *         <code>test</code> to describe the test dataset. If you have a single dataset project, specify
     *         <code>train</code>
     */
    public final String datasetType() {
        return datasetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetRequest)) {
            return false;
        }
        DescribeDatasetRequest other = (DescribeDatasetRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(datasetType(), other.datasetType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatasetRequest").add("ProjectName", projectName()).add("DatasetType", datasetType())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "DatasetType":
            return Optional.ofNullable(clazz.cast(datasetType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("datasetType", DATASET_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetRequest, T> g) {
        return obj -> g.apply((DescribeDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDatasetRequest> {
        /**
         * <p>
         * The name of the project that contains the dataset that you want to describe.
         * </p>
         * 
         * @param projectName
         *        The name of the project that contains the dataset that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The type of the dataset to describe. Specify <code>train</code> to describe the training dataset. Specify
         * <code>test</code> to describe the test dataset. If you have a single dataset project, specify
         * <code>train</code>
         * </p>
         * 
         * @param datasetType
         *        The type of the dataset to describe. Specify <code>train</code> to describe the training dataset.
         *        Specify <code>test</code> to describe the test dataset. If you have a single dataset project, specify
         *        <code>train</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetType(String datasetType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutVisionRequest.BuilderImpl implements Builder {
        private String projectName;

        private String datasetType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetRequest model) {
            super(model);
            projectName(model.projectName);
            datasetType(model.datasetType);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getDatasetType() {
            return datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDatasetRequest build() {
            return new DescribeDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
