/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeModelResponse extends LookoutVisionResponse implements
        ToCopyableBuilder<DescribeModelResponse.Builder, DescribeModelResponse> {
    private static final SdkField<ModelDescription> MODEL_DESCRIPTION_FIELD = SdkField
            .<ModelDescription> builder(MarshallingType.SDK_POJO).memberName("ModelDescription")
            .getter(getter(DescribeModelResponse::modelDescription)).setter(setter(Builder::modelDescription))
            .constructor(ModelDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ModelDescription modelDescription;

    private DescribeModelResponse(BuilderImpl builder) {
        super(builder);
        this.modelDescription = builder.modelDescription;
    }

    /**
     * <p>
     * Contains the description of the model.
     * </p>
     * 
     * @return Contains the description of the model.
     */
    public final ModelDescription modelDescription() {
        return modelDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelResponse)) {
            return false;
        }
        DescribeModelResponse other = (DescribeModelResponse) obj;
        return Objects.equals(modelDescription(), other.modelDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeModelResponse").add("ModelDescription", modelDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelDescription":
            return Optional.ofNullable(clazz.cast(modelDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelDescription", MODEL_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelResponse, T> g) {
        return obj -> g.apply((DescribeModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutVisionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeModelResponse> {
        /**
         * <p>
         * Contains the description of the model.
         * </p>
         * 
         * @param modelDescription
         *        Contains the description of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDescription(ModelDescription modelDescription);

        /**
         * <p>
         * Contains the description of the model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelDescription.Builder} avoiding the
         * need to create one manually via {@link ModelDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #modelDescription(ModelDescription)}.
         * 
         * @param modelDescription
         *        a consumer that will call methods on {@link ModelDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDescription(ModelDescription)
         */
        default Builder modelDescription(Consumer<ModelDescription.Builder> modelDescription) {
            return modelDescription(ModelDescription.builder().applyMutation(modelDescription).build());
        }
    }

    static final class BuilderImpl extends LookoutVisionResponse.BuilderImpl implements Builder {
        private ModelDescription modelDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelResponse model) {
            super(model);
            modelDescription(model.modelDescription);
        }

        public final ModelDescription.Builder getModelDescription() {
            return modelDescription != null ? modelDescription.toBuilder() : null;
        }

        public final void setModelDescription(ModelDescription.BuilderImpl modelDescription) {
            this.modelDescription = modelDescription != null ? modelDescription.build() : null;
        }

        @Override
        public final Builder modelDescription(ModelDescription modelDescription) {
            this.modelDescription = modelDescription;
            return this;
        }

        @Override
        public DescribeModelResponse build() {
            return new DescribeModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
