/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an anomaly type found on an image by an image segmentation model. For more information, see
 * <a>DetectAnomalies</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Anomaly implements SdkPojo, Serializable, ToCopyableBuilder<Anomaly.Builder, Anomaly> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Anomaly::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<PixelAnomaly> PIXEL_ANOMALY_FIELD = SdkField.<PixelAnomaly> builder(MarshallingType.SDK_POJO)
            .memberName("PixelAnomaly").getter(getter(Anomaly::pixelAnomaly)).setter(setter(Builder::pixelAnomaly))
            .constructor(PixelAnomaly::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PixelAnomaly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PIXEL_ANOMALY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final PixelAnomaly pixelAnomaly;

    private Anomaly(BuilderImpl builder) {
        this.name = builder.name;
        this.pixelAnomaly = builder.pixelAnomaly;
    }

    /**
     * <p>
     * The name of an anomaly type found in an image. <code>Name</code> maps to an anomaly type in the training dataset,
     * apart from the anomaly type <code>background</code>. The service automatically inserts the
     * <code>background</code> anomaly type into the response from <code>DetectAnomalies</code>.
     * </p>
     * 
     * @return The name of an anomaly type found in an image. <code>Name</code> maps to an anomaly type in the training
     *         dataset, apart from the anomaly type <code>background</code>. The service automatically inserts the
     *         <code>background</code> anomaly type into the response from <code>DetectAnomalies</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Information about the pixel mask that covers an anomaly type.
     * </p>
     * 
     * @return Information about the pixel mask that covers an anomaly type.
     */
    public final PixelAnomaly pixelAnomaly() {
        return pixelAnomaly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pixelAnomaly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Anomaly)) {
            return false;
        }
        Anomaly other = (Anomaly) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(pixelAnomaly(), other.pixelAnomaly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Anomaly").add("Name", name()).add("PixelAnomaly", pixelAnomaly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PixelAnomaly":
            return Optional.ofNullable(clazz.cast(pixelAnomaly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("PixelAnomaly", PIXEL_ANOMALY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Anomaly, T> g) {
        return obj -> g.apply((Anomaly) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Anomaly> {
        /**
         * <p>
         * The name of an anomaly type found in an image. <code>Name</code> maps to an anomaly type in the training
         * dataset, apart from the anomaly type <code>background</code>. The service automatically inserts the
         * <code>background</code> anomaly type into the response from <code>DetectAnomalies</code>.
         * </p>
         * 
         * @param name
         *        The name of an anomaly type found in an image. <code>Name</code> maps to an anomaly type in the
         *        training dataset, apart from the anomaly type <code>background</code>. The service automatically
         *        inserts the <code>background</code> anomaly type into the response from <code>DetectAnomalies</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Information about the pixel mask that covers an anomaly type.
         * </p>
         * 
         * @param pixelAnomaly
         *        Information about the pixel mask that covers an anomaly type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pixelAnomaly(PixelAnomaly pixelAnomaly);

        /**
         * <p>
         * Information about the pixel mask that covers an anomaly type.
         * </p>
         * This is a convenience method that creates an instance of the {@link PixelAnomaly.Builder} avoiding the need
         * to create one manually via {@link PixelAnomaly#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PixelAnomaly.Builder#build()} is called immediately and its
         * result is passed to {@link #pixelAnomaly(PixelAnomaly)}.
         * 
         * @param pixelAnomaly
         *        a consumer that will call methods on {@link PixelAnomaly.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pixelAnomaly(PixelAnomaly)
         */
        default Builder pixelAnomaly(Consumer<PixelAnomaly.Builder> pixelAnomaly) {
            return pixelAnomaly(PixelAnomaly.builder().applyMutation(pixelAnomaly).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private PixelAnomaly pixelAnomaly;

        private BuilderImpl() {
        }

        private BuilderImpl(Anomaly model) {
            name(model.name);
            pixelAnomaly(model.pixelAnomaly);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PixelAnomaly.Builder getPixelAnomaly() {
            return pixelAnomaly != null ? pixelAnomaly.toBuilder() : null;
        }

        public final void setPixelAnomaly(PixelAnomaly.BuilderImpl pixelAnomaly) {
            this.pixelAnomaly = pixelAnomaly != null ? pixelAnomaly.build() : null;
        }

        @Override
        public final Builder pixelAnomaly(PixelAnomaly pixelAnomaly) {
            this.pixelAnomaly = pixelAnomaly;
            return this;
        }

        @Override
        public Anomaly build() {
            return new Anomaly(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
