/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for the AWS IoT Greengrass component created in a model packaging job. For more
 * information, see <a>StartModelPackagingJob</a>.
 * </p>
 * <note>
 * <p>
 * You can't specify a component with the same <code>ComponentName</code> and <code>Componentversion</code> as an
 * existing component with the same component name and component version.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GreengrassConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GreengrassConfiguration.Builder, GreengrassConfiguration> {
    private static final SdkField<String> COMPILER_OPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompilerOptions").getter(getter(GreengrassConfiguration::compilerOptions))
            .setter(setter(Builder::compilerOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilerOptions").build()).build();

    private static final SdkField<String> TARGET_DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetDevice").getter(getter(GreengrassConfiguration::targetDeviceAsString))
            .setter(setter(Builder::targetDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDevice").build()).build();

    private static final SdkField<TargetPlatform> TARGET_PLATFORM_FIELD = SdkField
            .<TargetPlatform> builder(MarshallingType.SDK_POJO).memberName("TargetPlatform")
            .getter(getter(GreengrassConfiguration::targetPlatform)).setter(setter(Builder::targetPlatform))
            .constructor(TargetPlatform::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPlatform").build()).build();

    private static final SdkField<S3Location> S3_OUTPUT_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("S3OutputLocation").getter(getter(GreengrassConfiguration::s3OutputLocation))
            .setter(setter(Builder::s3OutputLocation)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputLocation").build()).build();

    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentName").getter(getter(GreengrassConfiguration::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()).build();

    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentVersion").getter(getter(GreengrassConfiguration::componentVersion))
            .setter(setter(Builder::componentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentVersion").build()).build();

    private static final SdkField<String> COMPONENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentDescription").getter(getter(GreengrassConfiguration::componentDescription))
            .setter(setter(Builder::componentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentDescription").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(GreengrassConfiguration::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILER_OPTIONS_FIELD,
            TARGET_DEVICE_FIELD, TARGET_PLATFORM_FIELD, S3_OUTPUT_LOCATION_FIELD, COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD,
            COMPONENT_DESCRIPTION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String compilerOptions;

    private final String targetDevice;

    private final TargetPlatform targetPlatform;

    private final S3Location s3OutputLocation;

    private final String componentName;

    private final String componentVersion;

    private final String componentDescription;

    private final List<Tag> tags;

    private GreengrassConfiguration(BuilderImpl builder) {
        this.compilerOptions = builder.compilerOptions;
        this.targetDevice = builder.targetDevice;
        this.targetPlatform = builder.targetPlatform;
        this.s3OutputLocation = builder.s3OutputLocation;
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.componentDescription = builder.componentDescription;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Additional compiler options for the Greengrass component. Currently, only NVIDIA Graphics Processing Units (GPU)
     * and CPU accelerators are supported. If you specify <code>TargetDevice</code>, don't specify
     * <code>CompilerOptions</code>.
     * </p>
     * <p>
     * For more information, see <i>Compiler options</i> in the Amazon Lookout for Vision Developer Guide.
     * </p>
     * 
     * @return Additional compiler options for the Greengrass component. Currently, only NVIDIA Graphics Processing
     *         Units (GPU) and CPU accelerators are supported. If you specify <code>TargetDevice</code>, don't specify
     *         <code>CompilerOptions</code>.</p>
     *         <p>
     *         For more information, see <i>Compiler options</i> in the Amazon Lookout for Vision Developer Guide.
     */
    public final String compilerOptions() {
        return compilerOptions;
    }

    /**
     * <p>
     * The target device for the model. Currently the only supported value is <code>jetson_xavier</code>. If you specify
     * <code>TargetDevice</code>, you can't specify <code>TargetPlatform</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetDevice} will
     * return {@link TargetDevice#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetDeviceAsString}.
     * </p>
     * 
     * @return The target device for the model. Currently the only supported value is <code>jetson_xavier</code>. If you
     *         specify <code>TargetDevice</code>, you can't specify <code>TargetPlatform</code>.
     * @see TargetDevice
     */
    public final TargetDevice targetDevice() {
        return TargetDevice.fromValue(targetDevice);
    }

    /**
     * <p>
     * The target device for the model. Currently the only supported value is <code>jetson_xavier</code>. If you specify
     * <code>TargetDevice</code>, you can't specify <code>TargetPlatform</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetDevice} will
     * return {@link TargetDevice#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetDeviceAsString}.
     * </p>
     * 
     * @return The target device for the model. Currently the only supported value is <code>jetson_xavier</code>. If you
     *         specify <code>TargetDevice</code>, you can't specify <code>TargetPlatform</code>.
     * @see TargetDevice
     */
    public final String targetDeviceAsString() {
        return targetDevice;
    }

    /**
     * <p>
     * The target platform for the model. If you specify <code>TargetPlatform</code>, you can't specify
     * <code>TargetDevice</code>.
     * </p>
     * 
     * @return The target platform for the model. If you specify <code>TargetPlatform</code>, you can't specify
     *         <code>TargetDevice</code>.
     */
    public final TargetPlatform targetPlatform() {
        return targetPlatform;
    }

    /**
     * <p>
     * An S3 location in which Lookout for Vision stores the component artifacts.
     * </p>
     * 
     * @return An S3 location in which Lookout for Vision stores the component artifacts.
     */
    public final S3Location s3OutputLocation() {
        return s3OutputLocation;
    }

    /**
     * <p>
     * A name for the AWS IoT Greengrass component.
     * </p>
     * 
     * @return A name for the AWS IoT Greengrass component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * A Version for the AWS IoT Greengrass component. If you don't provide a value, a default value of
     * <code> <i>Model Version</i>.0.0</code> is used.
     * </p>
     * 
     * @return A Version for the AWS IoT Greengrass component. If you don't provide a value, a default value of
     *         <code> <i>Model Version</i>.0.0</code> is used.
     */
    public final String componentVersion() {
        return componentVersion;
    }

    /**
     * <p>
     * A description for the AWS IoT Greengrass component.
     * </p>
     * 
     * @return A description for the AWS IoT Greengrass component.
     */
    public final String componentDescription() {
        return componentDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of tags (key-value pairs) that you want to attach to the AWS IoT Greengrass component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of tags (key-value pairs) that you want to attach to the AWS IoT Greengrass component.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(compilerOptions());
        hashCode = 31 * hashCode + Objects.hashCode(targetDeviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(componentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GreengrassConfiguration)) {
            return false;
        }
        GreengrassConfiguration other = (GreengrassConfiguration) obj;
        return Objects.equals(compilerOptions(), other.compilerOptions())
                && Objects.equals(targetDeviceAsString(), other.targetDeviceAsString())
                && Objects.equals(targetPlatform(), other.targetPlatform())
                && Objects.equals(s3OutputLocation(), other.s3OutputLocation())
                && Objects.equals(componentName(), other.componentName())
                && Objects.equals(componentVersion(), other.componentVersion())
                && Objects.equals(componentDescription(), other.componentDescription()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GreengrassConfiguration").add("CompilerOptions", compilerOptions())
                .add("TargetDevice", targetDeviceAsString()).add("TargetPlatform", targetPlatform())
                .add("S3OutputLocation", s3OutputLocation()).add("ComponentName", componentName())
                .add("ComponentVersion", componentVersion()).add("ComponentDescription", componentDescription())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompilerOptions":
            return Optional.ofNullable(clazz.cast(compilerOptions()));
        case "TargetDevice":
            return Optional.ofNullable(clazz.cast(targetDeviceAsString()));
        case "TargetPlatform":
            return Optional.ofNullable(clazz.cast(targetPlatform()));
        case "S3OutputLocation":
            return Optional.ofNullable(clazz.cast(s3OutputLocation()));
        case "ComponentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "ComponentVersion":
            return Optional.ofNullable(clazz.cast(componentVersion()));
        case "ComponentDescription":
            return Optional.ofNullable(clazz.cast(componentDescription()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CompilerOptions", COMPILER_OPTIONS_FIELD);
        map.put("TargetDevice", TARGET_DEVICE_FIELD);
        map.put("TargetPlatform", TARGET_PLATFORM_FIELD);
        map.put("S3OutputLocation", S3_OUTPUT_LOCATION_FIELD);
        map.put("ComponentName", COMPONENT_NAME_FIELD);
        map.put("ComponentVersion", COMPONENT_VERSION_FIELD);
        map.put("ComponentDescription", COMPONENT_DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GreengrassConfiguration, T> g) {
        return obj -> g.apply((GreengrassConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GreengrassConfiguration> {
        /**
         * <p>
         * Additional compiler options for the Greengrass component. Currently, only NVIDIA Graphics Processing Units
         * (GPU) and CPU accelerators are supported. If you specify <code>TargetDevice</code>, don't specify
         * <code>CompilerOptions</code>.
         * </p>
         * <p>
         * For more information, see <i>Compiler options</i> in the Amazon Lookout for Vision Developer Guide.
         * </p>
         * 
         * @param compilerOptions
         *        Additional compiler options for the Greengrass component. Currently, only NVIDIA Graphics Processing
         *        Units (GPU) and CPU accelerators are supported. If you specify <code>TargetDevice</code>, don't
         *        specify <code>CompilerOptions</code>.</p>
         *        <p>
         *        For more information, see <i>Compiler options</i> in the Amazon Lookout for Vision Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilerOptions(String compilerOptions);

        /**
         * <p>
         * The target device for the model. Currently the only supported value is <code>jetson_xavier</code>. If you
         * specify <code>TargetDevice</code>, you can't specify <code>TargetPlatform</code>.
         * </p>
         * 
         * @param targetDevice
         *        The target device for the model. Currently the only supported value is <code>jetson_xavier</code>. If
         *        you specify <code>TargetDevice</code>, you can't specify <code>TargetPlatform</code>.
         * @see TargetDevice
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetDevice
         */
        Builder targetDevice(String targetDevice);

        /**
         * <p>
         * The target device for the model. Currently the only supported value is <code>jetson_xavier</code>. If you
         * specify <code>TargetDevice</code>, you can't specify <code>TargetPlatform</code>.
         * </p>
         * 
         * @param targetDevice
         *        The target device for the model. Currently the only supported value is <code>jetson_xavier</code>. If
         *        you specify <code>TargetDevice</code>, you can't specify <code>TargetPlatform</code>.
         * @see TargetDevice
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetDevice
         */
        Builder targetDevice(TargetDevice targetDevice);

        /**
         * <p>
         * The target platform for the model. If you specify <code>TargetPlatform</code>, you can't specify
         * <code>TargetDevice</code>.
         * </p>
         * 
         * @param targetPlatform
         *        The target platform for the model. If you specify <code>TargetPlatform</code>, you can't specify
         *        <code>TargetDevice</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPlatform(TargetPlatform targetPlatform);

        /**
         * <p>
         * The target platform for the model. If you specify <code>TargetPlatform</code>, you can't specify
         * <code>TargetDevice</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetPlatform.Builder} avoiding the need
         * to create one manually via {@link TargetPlatform#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetPlatform.Builder#build()} is called immediately and its
         * result is passed to {@link #targetPlatform(TargetPlatform)}.
         * 
         * @param targetPlatform
         *        a consumer that will call methods on {@link TargetPlatform.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetPlatform(TargetPlatform)
         */
        default Builder targetPlatform(Consumer<TargetPlatform.Builder> targetPlatform) {
            return targetPlatform(TargetPlatform.builder().applyMutation(targetPlatform).build());
        }

        /**
         * <p>
         * An S3 location in which Lookout for Vision stores the component artifacts.
         * </p>
         * 
         * @param s3OutputLocation
         *        An S3 location in which Lookout for Vision stores the component artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputLocation(S3Location s3OutputLocation);

        /**
         * <p>
         * An S3 location in which Lookout for Vision stores the component artifacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #s3OutputLocation(S3Location)}.
         * 
         * @param s3OutputLocation
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3OutputLocation(S3Location)
         */
        default Builder s3OutputLocation(Consumer<S3Location.Builder> s3OutputLocation) {
            return s3OutputLocation(S3Location.builder().applyMutation(s3OutputLocation).build());
        }

        /**
         * <p>
         * A name for the AWS IoT Greengrass component.
         * </p>
         * 
         * @param componentName
         *        A name for the AWS IoT Greengrass component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * A Version for the AWS IoT Greengrass component. If you don't provide a value, a default value of
         * <code> <i>Model Version</i>.0.0</code> is used.
         * </p>
         * 
         * @param componentVersion
         *        A Version for the AWS IoT Greengrass component. If you don't provide a value, a default value of
         *        <code> <i>Model Version</i>.0.0</code> is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentVersion(String componentVersion);

        /**
         * <p>
         * A description for the AWS IoT Greengrass component.
         * </p>
         * 
         * @param componentDescription
         *        A description for the AWS IoT Greengrass component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentDescription(String componentDescription);

        /**
         * <p>
         * A set of tags (key-value pairs) that you want to attach to the AWS IoT Greengrass component.
         * </p>
         * 
         * @param tags
         *        A set of tags (key-value pairs) that you want to attach to the AWS IoT Greengrass component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A set of tags (key-value pairs) that you want to attach to the AWS IoT Greengrass component.
         * </p>
         * 
         * @param tags
         *        A set of tags (key-value pairs) that you want to attach to the AWS IoT Greengrass component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A set of tags (key-value pairs) that you want to attach to the AWS IoT Greengrass component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutvision.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lookoutvision.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutvision.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutvision.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String compilerOptions;

        private String targetDevice;

        private TargetPlatform targetPlatform;

        private S3Location s3OutputLocation;

        private String componentName;

        private String componentVersion;

        private String componentDescription;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GreengrassConfiguration model) {
            compilerOptions(model.compilerOptions);
            targetDevice(model.targetDevice);
            targetPlatform(model.targetPlatform);
            s3OutputLocation(model.s3OutputLocation);
            componentName(model.componentName);
            componentVersion(model.componentVersion);
            componentDescription(model.componentDescription);
            tags(model.tags);
        }

        public final String getCompilerOptions() {
            return compilerOptions;
        }

        public final void setCompilerOptions(String compilerOptions) {
            this.compilerOptions = compilerOptions;
        }

        @Override
        public final Builder compilerOptions(String compilerOptions) {
            this.compilerOptions = compilerOptions;
            return this;
        }

        public final String getTargetDevice() {
            return targetDevice;
        }

        public final void setTargetDevice(String targetDevice) {
            this.targetDevice = targetDevice;
        }

        @Override
        public final Builder targetDevice(String targetDevice) {
            this.targetDevice = targetDevice;
            return this;
        }

        @Override
        public final Builder targetDevice(TargetDevice targetDevice) {
            this.targetDevice(targetDevice == null ? null : targetDevice.toString());
            return this;
        }

        public final TargetPlatform.Builder getTargetPlatform() {
            return targetPlatform != null ? targetPlatform.toBuilder() : null;
        }

        public final void setTargetPlatform(TargetPlatform.BuilderImpl targetPlatform) {
            this.targetPlatform = targetPlatform != null ? targetPlatform.build() : null;
        }

        @Override
        public final Builder targetPlatform(TargetPlatform targetPlatform) {
            this.targetPlatform = targetPlatform;
            return this;
        }

        public final S3Location.Builder getS3OutputLocation() {
            return s3OutputLocation != null ? s3OutputLocation.toBuilder() : null;
        }

        public final void setS3OutputLocation(S3Location.BuilderImpl s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation != null ? s3OutputLocation.build() : null;
        }

        @Override
        public final Builder s3OutputLocation(S3Location s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
            return this;
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final String getComponentDescription() {
            return componentDescription;
        }

        public final void setComponentDescription(String componentDescription) {
            this.componentDescription = componentDescription;
        }

        @Override
        public final Builder componentDescription(String componentDescription) {
            this.componentDescription = componentDescription;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GreengrassConfiguration build() {
            return new GreengrassConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
