/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutvision.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the output from a model packaging job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelPackagingOutputDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelPackagingOutputDetails.Builder, ModelPackagingOutputDetails> {
    private static final SdkField<GreengrassOutputDetails> GREENGRASS_FIELD = SdkField
            .<GreengrassOutputDetails> builder(MarshallingType.SDK_POJO).memberName("Greengrass")
            .getter(getter(ModelPackagingOutputDetails::greengrass)).setter(setter(Builder::greengrass))
            .constructor(GreengrassOutputDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Greengrass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GREENGRASS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GreengrassOutputDetails greengrass;

    private ModelPackagingOutputDetails(BuilderImpl builder) {
        this.greengrass = builder.greengrass;
    }

    /**
     * <p>
     * Information about the AWS IoT Greengrass component in a model packaging job.
     * </p>
     * 
     * @return Information about the AWS IoT Greengrass component in a model packaging job.
     */
    public final GreengrassOutputDetails greengrass() {
        return greengrass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(greengrass());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackagingOutputDetails)) {
            return false;
        }
        ModelPackagingOutputDetails other = (ModelPackagingOutputDetails) obj;
        return Objects.equals(greengrass(), other.greengrass());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelPackagingOutputDetails").add("Greengrass", greengrass()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Greengrass":
            return Optional.ofNullable(clazz.cast(greengrass()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Greengrass", GREENGRASS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelPackagingOutputDetails, T> g) {
        return obj -> g.apply((ModelPackagingOutputDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelPackagingOutputDetails> {
        /**
         * <p>
         * Information about the AWS IoT Greengrass component in a model packaging job.
         * </p>
         * 
         * @param greengrass
         *        Information about the AWS IoT Greengrass component in a model packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greengrass(GreengrassOutputDetails greengrass);

        /**
         * <p>
         * Information about the AWS IoT Greengrass component in a model packaging job.
         * </p>
         * This is a convenience method that creates an instance of the {@link GreengrassOutputDetails.Builder} avoiding
         * the need to create one manually via {@link GreengrassOutputDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GreengrassOutputDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #greengrass(GreengrassOutputDetails)}.
         * 
         * @param greengrass
         *        a consumer that will call methods on {@link GreengrassOutputDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greengrass(GreengrassOutputDetails)
         */
        default Builder greengrass(Consumer<GreengrassOutputDetails.Builder> greengrass) {
            return greengrass(GreengrassOutputDetails.builder().applyMutation(greengrass).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GreengrassOutputDetails greengrass;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackagingOutputDetails model) {
            greengrass(model.greengrass);
        }

        public final GreengrassOutputDetails.Builder getGreengrass() {
            return greengrass != null ? greengrass.toBuilder() : null;
        }

        public final void setGreengrass(GreengrassOutputDetails.BuilderImpl greengrass) {
            this.greengrass = greengrass != null ? greengrass.build() : null;
        }

        @Override
        public final Builder greengrass(GreengrassOutputDetails greengrass) {
            this.greengrass = greengrass;
            return this;
        }

        @Override
        public ModelPackagingOutputDetails build() {
            return new ModelPackagingOutputDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
