/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A subset of the possible batch job attributes. Used in the batch job list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchJobExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchJobExecutionSummary.Builder, BatchJobExecutionSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(BatchJobExecutionSummary::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(BatchJobExecutionSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(BatchJobExecutionSummary::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(BatchJobExecutionSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(BatchJobExecutionSummary::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobType").getter(getter(BatchJobExecutionSummary::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(BatchJobExecutionSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BatchJobExecutionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            END_TIME_FIELD, EXECUTION_ID_FIELD, JOB_ID_FIELD, JOB_NAME_FIELD, JOB_TYPE_FIELD, START_TIME_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final Instant endTime;

    private final String executionId;

    private final String jobId;

    private final String jobName;

    private final String jobType;

    private final Instant startTime;

    private final String status;

    private BatchJobExecutionSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.endTime = builder.endTime;
        this.executionId = builder.executionId;
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobType = builder.jobType;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the application that hosts this batch job.
     * </p>
     * 
     * @return The unique identifier of the application that hosts this batch job.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The timestamp when this batch job execution ended.
     * </p>
     * 
     * @return The timestamp when this batch job execution ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The unique identifier of this execution of the batch job.
     * </p>
     * 
     * @return The unique identifier of this execution of the batch job.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The unique identifier of a particular batch job.
     * </p>
     * 
     * @return The unique identifier of a particular batch job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The name of a particular batch job.
     * </p>
     * 
     * @return The name of a particular batch job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The type of a particular batch job execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link BatchJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type of a particular batch job execution.
     * @see BatchJobType
     */
    public final BatchJobType jobType() {
        return BatchJobType.fromValue(jobType);
    }

    /**
     * <p>
     * The type of a particular batch job execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link BatchJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type of a particular batch job execution.
     * @see BatchJobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * The timestamp when a particular batch job execution started.
     * </p>
     * 
     * @return The timestamp when a particular batch job execution started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The status of a particular batch job execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BatchJobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a particular batch job execution.
     * @see BatchJobExecutionStatus
     */
    public final BatchJobExecutionStatus status() {
        return BatchJobExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a particular batch job execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BatchJobExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a particular batch job execution.
     * @see BatchJobExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchJobExecutionSummary)) {
            return false;
        }
        BatchJobExecutionSummary other = (BatchJobExecutionSummary) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(executionId(), other.executionId()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchJobExecutionSummary").add("ApplicationId", applicationId()).add("EndTime", endTime())
                .add("ExecutionId", executionId()).add("JobId", jobId()).add("JobName", jobName())
                .add("JobType", jobTypeAsString()).add("StartTime", startTime()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "jobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchJobExecutionSummary, T> g) {
        return obj -> g.apply((BatchJobExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchJobExecutionSummary> {
        /**
         * <p>
         * The unique identifier of the application that hosts this batch job.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the application that hosts this batch job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The timestamp when this batch job execution ended.
         * </p>
         * 
         * @param endTime
         *        The timestamp when this batch job execution ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The unique identifier of this execution of the batch job.
         * </p>
         * 
         * @param executionId
         *        The unique identifier of this execution of the batch job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The unique identifier of a particular batch job.
         * </p>
         * 
         * @param jobId
         *        The unique identifier of a particular batch job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The name of a particular batch job.
         * </p>
         * 
         * @param jobName
         *        The name of a particular batch job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The type of a particular batch job execution.
         * </p>
         * 
         * @param jobType
         *        The type of a particular batch job execution.
         * @see BatchJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchJobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The type of a particular batch job execution.
         * </p>
         * 
         * @param jobType
         *        The type of a particular batch job execution.
         * @see BatchJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchJobType
         */
        Builder jobType(BatchJobType jobType);

        /**
         * <p>
         * The timestamp when a particular batch job execution started.
         * </p>
         * 
         * @param startTime
         *        The timestamp when a particular batch job execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The status of a particular batch job execution.
         * </p>
         * 
         * @param status
         *        The status of a particular batch job execution.
         * @see BatchJobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchJobExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a particular batch job execution.
         * </p>
         * 
         * @param status
         *        The status of a particular batch job execution.
         * @see BatchJobExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchJobExecutionStatus
         */
        Builder status(BatchJobExecutionStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private Instant endTime;

        private String executionId;

        private String jobId;

        private String jobName;

        private String jobType;

        private Instant startTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchJobExecutionSummary model) {
            applicationId(model.applicationId);
            endTime(model.endTime);
            executionId(model.executionId);
            jobId(model.jobId);
            jobName(model.jobName);
            jobType(model.jobType);
            startTime(model.startTime);
            status(model.status);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(BatchJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BatchJobExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public BatchJobExecutionSummary build() {
            return new BatchJobExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
