/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a subset of the possible environment attributes. Used in the environment list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentSummary.Builder, EnvironmentSummary> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(EnvironmentSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineType").getter(getter(EnvironmentSummary::engineTypeAsString)).setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineVersion").getter(getter(EnvironmentSummary::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentArn").getter(getter(EnvironmentSummary::environmentArn))
            .setter(setter(Builder::environmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentArn").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(EnvironmentSummary::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(EnvironmentSummary::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EnvironmentSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(EnvironmentSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            ENGINE_TYPE_FIELD, ENGINE_VERSION_FIELD, ENVIRONMENT_ARN_FIELD, ENVIRONMENT_ID_FIELD, INSTANCE_TYPE_FIELD,
            NAME_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String engineType;

    private final String engineVersion;

    private final String environmentArn;

    private final String environmentId;

    private final String instanceType;

    private final String name;

    private final String status;

    private EnvironmentSummary(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.environmentArn = builder.environmentArn;
        this.environmentId = builder.environmentId;
        this.instanceType = builder.instanceType;
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * The timestamp when the environment was created.
     * </p>
     * 
     * @return The timestamp when the environment was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The target platform for the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The target platform for the environment.
     * @see EngineType
     */
    public final EngineType engineType() {
        return EngineType.fromValue(engineType);
    }

    /**
     * <p>
     * The target platform for the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The target platform for the environment.
     * @see EngineType
     */
    public final String engineTypeAsString() {
        return engineType;
    }

    /**
     * <p>
     * The version of the runtime engine.
     * </p>
     * 
     * @return The version of the runtime engine.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a particular runtime environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a particular runtime environment.
     */
    public final String environmentArn() {
        return environmentArn;
    }

    /**
     * <p>
     * The unique identifier of a particular runtime environment.
     * </p>
     * 
     * @return The unique identifier of a particular runtime environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The instance type of the environment.
     * </p>
     * 
     * @return The instance type of the environment.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the environment
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the environment
     * @see EnvironmentLifecycle
     */
    public final EnvironmentLifecycle status() {
        return EnvironmentLifecycle.fromValue(status);
    }

    /**
     * <p>
     * The status of the environment
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the environment
     * @see EnvironmentLifecycle
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentSummary)) {
            return false;
        }
        EnvironmentSummary other = (EnvironmentSummary) obj;
        return Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(engineTypeAsString(), other.engineTypeAsString())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(environmentArn(), other.environmentArn())
                && Objects.equals(environmentId(), other.environmentId()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentSummary").add("CreationTime", creationTime()).add("EngineType", engineTypeAsString())
                .add("EngineVersion", engineVersion()).add("EnvironmentArn", environmentArn())
                .add("EnvironmentId", environmentId()).add("InstanceType", instanceType()).add("Name", name())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "engineType":
            return Optional.ofNullable(clazz.cast(engineTypeAsString()));
        case "engineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "environmentArn":
            return Optional.ofNullable(clazz.cast(environmentArn()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentSummary, T> g) {
        return obj -> g.apply((EnvironmentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentSummary> {
        /**
         * <p>
         * The timestamp when the environment was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when the environment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The target platform for the environment.
         * </p>
         * 
         * @param engineType
         *        The target platform for the environment.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(String engineType);

        /**
         * <p>
         * The target platform for the environment.
         * </p>
         * 
         * @param engineType
         *        The target platform for the environment.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(EngineType engineType);

        /**
         * <p>
         * The version of the runtime engine.
         * </p>
         * 
         * @param engineVersion
         *        The version of the runtime engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a particular runtime environment.
         * </p>
         * 
         * @param environmentArn
         *        The Amazon Resource Name (ARN) of a particular runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentArn(String environmentArn);

        /**
         * <p>
         * The unique identifier of a particular runtime environment.
         * </p>
         * 
         * @param environmentId
         *        The unique identifier of a particular runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The instance type of the environment.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param name
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the environment
         * </p>
         * 
         * @param status
         *        The status of the environment
         * @see EnvironmentLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentLifecycle
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the environment
         * </p>
         * 
         * @param status
         *        The status of the environment
         * @see EnvironmentLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentLifecycle
         */
        Builder status(EnvironmentLifecycle status);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String engineType;

        private String engineVersion;

        private String environmentArn;

        private String environmentId;

        private String instanceType;

        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentSummary model) {
            creationTime(model.creationTime);
            engineType(model.engineType);
            engineVersion(model.engineVersion);
            environmentArn(model.environmentArn);
            environmentId(model.environmentId);
            instanceType(model.instanceType);
            name(model.name);
            status(model.status);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getEngineType() {
            return engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEnvironmentArn() {
            return environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public EnvironmentSummary build() {
            return new EnvironmentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
