/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationResponse extends M2Response implements
        ToCopyableBuilder<GetApplicationResponse.Builder, GetApplicationResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationArn").getter(getter(GetApplicationResponse::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetApplicationResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetApplicationResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<DeployedVersionSummary> DEPLOYED_VERSION_FIELD = SdkField
            .<DeployedVersionSummary> builder(MarshallingType.SDK_POJO).memberName("deployedVersion")
            .getter(getter(GetApplicationResponse::deployedVersion)).setter(setter(Builder::deployedVersion))
            .constructor(DeployedVersionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployedVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetApplicationResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineType").getter(getter(GetApplicationResponse::engineTypeAsString))
            .setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(GetApplicationResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<Instant> LAST_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStartTime").getter(getter(GetApplicationResponse::lastStartTime))
            .setter(setter(Builder::lastStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartTime").build()).build();

    private static final SdkField<ApplicationVersionSummary> LATEST_VERSION_FIELD = SdkField
            .<ApplicationVersionSummary> builder(MarshallingType.SDK_POJO).memberName("latestVersion")
            .getter(getter(GetApplicationResponse::latestVersion)).setter(setter(Builder::latestVersion))
            .constructor(ApplicationVersionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()).build();

    private static final SdkField<List<String>> LISTENER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("listenerArns")
            .getter(getter(GetApplicationResponse::listenerArns))
            .setter(setter(Builder::listenerArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> LISTENER_PORTS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("listenerPorts")
            .getter(getter(GetApplicationResponse::listenerPorts))
            .setter(setter(Builder::listenerPorts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerPorts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOAD_BALANCER_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("loadBalancerDnsName").getter(getter(GetApplicationResponse::loadBalancerDnsName))
            .setter(setter(Builder::loadBalancerDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerDnsName").build())
            .build();

    private static final SdkField<List<LogGroupSummary>> LOG_GROUPS_FIELD = SdkField
            .<List<LogGroupSummary>> builder(MarshallingType.LIST)
            .memberName("logGroups")
            .getter(getter(GetApplicationResponse::logGroups))
            .setter(setter(Builder::logGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetApplicationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetApplicationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(GetApplicationResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetApplicationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGET_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("targetGroupArns")
            .getter(getter(GetApplicationResponse::targetGroupArns))
            .setter(setter(Builder::targetGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            APPLICATION_ID_FIELD, CREATION_TIME_FIELD, DEPLOYED_VERSION_FIELD, DESCRIPTION_FIELD, ENGINE_TYPE_FIELD,
            ENVIRONMENT_ID_FIELD, LAST_START_TIME_FIELD, LATEST_VERSION_FIELD, LISTENER_ARNS_FIELD, LISTENER_PORTS_FIELD,
            LOAD_BALANCER_DNS_NAME_FIELD, LOG_GROUPS_FIELD, NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TAGS_FIELD,
            TARGET_GROUP_ARNS_FIELD));

    private final String applicationArn;

    private final String applicationId;

    private final Instant creationTime;

    private final DeployedVersionSummary deployedVersion;

    private final String description;

    private final String engineType;

    private final String environmentId;

    private final Instant lastStartTime;

    private final ApplicationVersionSummary latestVersion;

    private final List<String> listenerArns;

    private final List<Integer> listenerPorts;

    private final String loadBalancerDnsName;

    private final List<LogGroupSummary> logGroups;

    private final String name;

    private final String status;

    private final String statusReason;

    private final Map<String, String> tags;

    private final List<String> targetGroupArns;

    private GetApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.applicationId = builder.applicationId;
        this.creationTime = builder.creationTime;
        this.deployedVersion = builder.deployedVersion;
        this.description = builder.description;
        this.engineType = builder.engineType;
        this.environmentId = builder.environmentId;
        this.lastStartTime = builder.lastStartTime;
        this.latestVersion = builder.latestVersion;
        this.listenerArns = builder.listenerArns;
        this.listenerPorts = builder.listenerPorts;
        this.loadBalancerDnsName = builder.loadBalancerDnsName;
        this.logGroups = builder.logGroups;
        this.name = builder.name;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.tags = builder.tags;
        this.targetGroupArns = builder.targetGroupArns;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The identifier of the application.
     * </p>
     * 
     * @return The identifier of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The timestamp when this application was created.
     * </p>
     * 
     * @return The timestamp when this application was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The version of the application that is deployed.
     * </p>
     * 
     * @return The version of the application that is deployed.
     */
    public final DeployedVersionSummary deployedVersion() {
        return deployedVersion;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * 
     * @return The description of the application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of the target platform for the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The type of the target platform for the application.
     * @see EngineType
     */
    public final EngineType engineType() {
        return EngineType.fromValue(engineType);
    }

    /**
     * <p>
     * The type of the target platform for the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The type of the target platform for the application.
     * @see EngineType
     */
    public final String engineTypeAsString() {
        return engineType;
    }

    /**
     * <p>
     * The identifier of the environment where the application will be deployed.
     * </p>
     * 
     * @return The identifier of the environment where the application will be deployed.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The timestamp when the application was last started. Null until the application has started running for the first
     * time.
     * </p>
     * 
     * @return The timestamp when the application was last started. Null until the application has started running for
     *         the first time.
     */
    public final Instant lastStartTime() {
        return lastStartTime;
    }

    /**
     * <p>
     * The latest version of the application.
     * </p>
     * 
     * @return The latest version of the application.
     */
    public final ApplicationVersionSummary latestVersion() {
        return latestVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListenerArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasListenerArns() {
        return listenerArns != null && !(listenerArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the network load balancer listener created in your Amazon Web Services
     * account. Amazon Web Services Mainframe Modernization creates this listener on your behalf the first time you
     * deploy an application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListenerArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the network load balancer listener created in your Amazon Web Services
     *         account. Amazon Web Services Mainframe Modernization creates this listener on your behalf the first time
     *         you deploy an application.
     */
    public final List<String> listenerArns() {
        return listenerArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListenerPorts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasListenerPorts() {
        return listenerPorts != null && !(listenerPorts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The port associated with the network load balancer listener created in your Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListenerPorts} method.
     * </p>
     * 
     * @return The port associated with the network load balancer listener created in your Amazon Web Services account.
     */
    public final List<Integer> listenerPorts() {
        return listenerPorts;
    }

    /**
     * <p>
     * The public DNS name of the load balancer created in your Amazon Web Services account.
     * </p>
     * 
     * @return The public DNS name of the load balancer created in your Amazon Web Services account.
     */
    public final String loadBalancerDnsName() {
        return loadBalancerDnsName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogGroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogGroups() {
        return logGroups != null && !(logGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of log summaries. Each log summary includes the log type as well as the log group identifier. These are
     * CloudWatch logs. The Amazon Web Services Mainframe Modernization application log is pushed to CloudWatch under
     * the customer's account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogGroups} method.
     * </p>
     * 
     * @return The list of log summaries. Each log summary includes the log type as well as the log group identifier.
     *         These are CloudWatch logs. The Amazon Web Services Mainframe Modernization application log is pushed to
     *         CloudWatch under the customer's account.
     */
    public final List<LogGroupSummary> logGroups() {
        return logGroups;
    }

    /**
     * <p>
     * The unique identifier of the application.
     * </p>
     * 
     * @return The unique identifier of the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationLifecycle
     */
    public final ApplicationLifecycle status() {
        return ApplicationLifecycle.fromValue(status);
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationLifecycle
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the reported status.
     * </p>
     * 
     * @return The reason for the reported status.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags associated with the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags associated with the application.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetGroupArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetGroupArns() {
        return targetGroupArns != null && !(targetGroupArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the Amazon Resource Names (ARNs) of the target groups that are attached to the network load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetGroupArns} method.
     * </p>
     * 
     * @return Returns the Amazon Resource Names (ARNs) of the target groups that are attached to the network load
     *         balancer.
     */
    public final List<String> targetGroupArns() {
        return targetGroupArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(deployedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(lastStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasListenerArns() ? listenerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasListenerPorts() ? listenerPorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogGroups() ? logGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetGroupArns() ? targetGroupArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse) obj;
        return Objects.equals(applicationArn(), other.applicationArn()) && Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(deployedVersion(), other.deployedVersion())
                && Objects.equals(description(), other.description())
                && Objects.equals(engineTypeAsString(), other.engineTypeAsString())
                && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(lastStartTime(), other.lastStartTime())
                && Objects.equals(latestVersion(), other.latestVersion()) && hasListenerArns() == other.hasListenerArns()
                && Objects.equals(listenerArns(), other.listenerArns()) && hasListenerPorts() == other.hasListenerPorts()
                && Objects.equals(listenerPorts(), other.listenerPorts())
                && Objects.equals(loadBalancerDnsName(), other.loadBalancerDnsName()) && hasLogGroups() == other.hasLogGroups()
                && Objects.equals(logGroups(), other.logGroups()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasTargetGroupArns() == other.hasTargetGroupArns()
                && Objects.equals(targetGroupArns(), other.targetGroupArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationResponse").add("ApplicationArn", applicationArn())
                .add("ApplicationId", applicationId()).add("CreationTime", creationTime())
                .add("DeployedVersion", deployedVersion()).add("Description", description())
                .add("EngineType", engineTypeAsString()).add("EnvironmentId", environmentId())
                .add("LastStartTime", lastStartTime()).add("LatestVersion", latestVersion())
                .add("ListenerArns", hasListenerArns() ? listenerArns() : null)
                .add("ListenerPorts", hasListenerPorts() ? listenerPorts() : null)
                .add("LoadBalancerDnsName", loadBalancerDnsName()).add("LogGroups", hasLogGroups() ? logGroups() : null)
                .add("Name", name()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("Tags", hasTags() ? tags() : null).add("TargetGroupArns", hasTargetGroupArns() ? targetGroupArns() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "deployedVersion":
            return Optional.ofNullable(clazz.cast(deployedVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "engineType":
            return Optional.ofNullable(clazz.cast(engineTypeAsString()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "lastStartTime":
            return Optional.ofNullable(clazz.cast(lastStartTime()));
        case "latestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "listenerArns":
            return Optional.ofNullable(clazz.cast(listenerArns()));
        case "listenerPorts":
            return Optional.ofNullable(clazz.cast(listenerPorts()));
        case "loadBalancerDnsName":
            return Optional.ofNullable(clazz.cast(loadBalancerDnsName()));
        case "logGroups":
            return Optional.ofNullable(clazz.cast(logGroups()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "targetGroupArns":
            return Optional.ofNullable(clazz.cast(targetGroupArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationResponse, T> g) {
        return obj -> g.apply((GetApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends M2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetApplicationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The identifier of the application.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The timestamp when this application was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when this application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The version of the application that is deployed.
         * </p>
         * 
         * @param deployedVersion
         *        The version of the application that is deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployedVersion(DeployedVersionSummary deployedVersion);

        /**
         * <p>
         * The version of the application that is deployed.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeployedVersionSummary.Builder} avoiding
         * the need to create one manually via {@link DeployedVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeployedVersionSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #deployedVersion(DeployedVersionSummary)}.
         * 
         * @param deployedVersion
         *        a consumer that will call methods on {@link DeployedVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deployedVersion(DeployedVersionSummary)
         */
        default Builder deployedVersion(Consumer<DeployedVersionSummary.Builder> deployedVersion) {
            return deployedVersion(DeployedVersionSummary.builder().applyMutation(deployedVersion).build());
        }

        /**
         * <p>
         * The description of the application.
         * </p>
         * 
         * @param description
         *        The description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the target platform for the application.
         * </p>
         * 
         * @param engineType
         *        The type of the target platform for the application.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(String engineType);

        /**
         * <p>
         * The type of the target platform for the application.
         * </p>
         * 
         * @param engineType
         *        The type of the target platform for the application.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(EngineType engineType);

        /**
         * <p>
         * The identifier of the environment where the application will be deployed.
         * </p>
         * 
         * @param environmentId
         *        The identifier of the environment where the application will be deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The timestamp when the application was last started. Null until the application has started running for the
         * first time.
         * </p>
         * 
         * @param lastStartTime
         *        The timestamp when the application was last started. Null until the application has started running
         *        for the first time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStartTime(Instant lastStartTime);

        /**
         * <p>
         * The latest version of the application.
         * </p>
         * 
         * @param latestVersion
         *        The latest version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(ApplicationVersionSummary latestVersion);

        /**
         * <p>
         * The latest version of the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationVersionSummary.Builder}
         * avoiding the need to create one manually via {@link ApplicationVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationVersionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #latestVersion(ApplicationVersionSummary)}.
         * 
         * @param latestVersion
         *        a consumer that will call methods on {@link ApplicationVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestVersion(ApplicationVersionSummary)
         */
        default Builder latestVersion(Consumer<ApplicationVersionSummary.Builder> latestVersion) {
            return latestVersion(ApplicationVersionSummary.builder().applyMutation(latestVersion).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the network load balancer listener created in your Amazon Web Services
         * account. Amazon Web Services Mainframe Modernization creates this listener on your behalf the first time you
         * deploy an application.
         * </p>
         * 
         * @param listenerArns
         *        The Amazon Resource Name (ARN) for the network load balancer listener created in your Amazon Web
         *        Services account. Amazon Web Services Mainframe Modernization creates this listener on your behalf the
         *        first time you deploy an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerArns(Collection<String> listenerArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the network load balancer listener created in your Amazon Web Services
         * account. Amazon Web Services Mainframe Modernization creates this listener on your behalf the first time you
         * deploy an application.
         * </p>
         * 
         * @param listenerArns
         *        The Amazon Resource Name (ARN) for the network load balancer listener created in your Amazon Web
         *        Services account. Amazon Web Services Mainframe Modernization creates this listener on your behalf the
         *        first time you deploy an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerArns(String... listenerArns);

        /**
         * <p>
         * The port associated with the network load balancer listener created in your Amazon Web Services account.
         * </p>
         * 
         * @param listenerPorts
         *        The port associated with the network load balancer listener created in your Amazon Web Services
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerPorts(Collection<Integer> listenerPorts);

        /**
         * <p>
         * The port associated with the network load balancer listener created in your Amazon Web Services account.
         * </p>
         * 
         * @param listenerPorts
         *        The port associated with the network load balancer listener created in your Amazon Web Services
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerPorts(Integer... listenerPorts);

        /**
         * <p>
         * The public DNS name of the load balancer created in your Amazon Web Services account.
         * </p>
         * 
         * @param loadBalancerDnsName
         *        The public DNS name of the load balancer created in your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerDnsName(String loadBalancerDnsName);

        /**
         * <p>
         * The list of log summaries. Each log summary includes the log type as well as the log group identifier. These
         * are CloudWatch logs. The Amazon Web Services Mainframe Modernization application log is pushed to CloudWatch
         * under the customer's account.
         * </p>
         * 
         * @param logGroups
         *        The list of log summaries. Each log summary includes the log type as well as the log group identifier.
         *        These are CloudWatch logs. The Amazon Web Services Mainframe Modernization application log is pushed
         *        to CloudWatch under the customer's account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroups(Collection<LogGroupSummary> logGroups);

        /**
         * <p>
         * The list of log summaries. Each log summary includes the log type as well as the log group identifier. These
         * are CloudWatch logs. The Amazon Web Services Mainframe Modernization application log is pushed to CloudWatch
         * under the customer's account.
         * </p>
         * 
         * @param logGroups
         *        The list of log summaries. Each log summary includes the log type as well as the log group identifier.
         *        These are CloudWatch logs. The Amazon Web Services Mainframe Modernization application log is pushed
         *        to CloudWatch under the customer's account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroups(LogGroupSummary... logGroups);

        /**
         * <p>
         * The list of log summaries. Each log summary includes the log type as well as the log group identifier. These
         * are CloudWatch logs. The Amazon Web Services Mainframe Modernization application log is pushed to CloudWatch
         * under the customer's account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.m2.model.LogGroupSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.m2.model.LogGroupSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.m2.model.LogGroupSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #logGroups(List<LogGroupSummary>)}.
         * 
         * @param logGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.m2.model.LogGroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logGroups(java.util.Collection<LogGroupSummary>)
         */
        Builder logGroups(Consumer<LogGroupSummary.Builder>... logGroups);

        /**
         * <p>
         * The unique identifier of the application.
         * </p>
         * 
         * @param name
         *        The unique identifier of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param status
         *        The status of the application.
         * @see ApplicationLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationLifecycle
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param status
         *        The status of the application.
         * @see ApplicationLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationLifecycle
         */
        Builder status(ApplicationLifecycle status);

        /**
         * <p>
         * The reason for the reported status.
         * </p>
         * 
         * @param statusReason
         *        The reason for the reported status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * A list of tags associated with the application.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Returns the Amazon Resource Names (ARNs) of the target groups that are attached to the network load balancer.
         * </p>
         * 
         * @param targetGroupArns
         *        Returns the Amazon Resource Names (ARNs) of the target groups that are attached to the network load
         *        balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupArns(Collection<String> targetGroupArns);

        /**
         * <p>
         * Returns the Amazon Resource Names (ARNs) of the target groups that are attached to the network load balancer.
         * </p>
         * 
         * @param targetGroupArns
         *        Returns the Amazon Resource Names (ARNs) of the target groups that are attached to the network load
         *        balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupArns(String... targetGroupArns);
    }

    static final class BuilderImpl extends M2Response.BuilderImpl implements Builder {
        private String applicationArn;

        private String applicationId;

        private Instant creationTime;

        private DeployedVersionSummary deployedVersion;

        private String description;

        private String engineType;

        private String environmentId;

        private Instant lastStartTime;

        private ApplicationVersionSummary latestVersion;

        private List<String> listenerArns = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> listenerPorts = DefaultSdkAutoConstructList.getInstance();

        private String loadBalancerDnsName;

        private List<LogGroupSummary> logGroups = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String status;

        private String statusReason;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> targetGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            super(model);
            applicationArn(model.applicationArn);
            applicationId(model.applicationId);
            creationTime(model.creationTime);
            deployedVersion(model.deployedVersion);
            description(model.description);
            engineType(model.engineType);
            environmentId(model.environmentId);
            lastStartTime(model.lastStartTime);
            latestVersion(model.latestVersion);
            listenerArns(model.listenerArns);
            listenerPorts(model.listenerPorts);
            loadBalancerDnsName(model.loadBalancerDnsName);
            logGroups(model.logGroups);
            name(model.name);
            status(model.status);
            statusReason(model.statusReason);
            tags(model.tags);
            targetGroupArns(model.targetGroupArns);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final DeployedVersionSummary.Builder getDeployedVersion() {
            return deployedVersion != null ? deployedVersion.toBuilder() : null;
        }

        public final void setDeployedVersion(DeployedVersionSummary.BuilderImpl deployedVersion) {
            this.deployedVersion = deployedVersion != null ? deployedVersion.build() : null;
        }

        @Override
        public final Builder deployedVersion(DeployedVersionSummary deployedVersion) {
            this.deployedVersion = deployedVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngineType() {
            return engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Instant getLastStartTime() {
            return lastStartTime;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final ApplicationVersionSummary.Builder getLatestVersion() {
            return latestVersion != null ? latestVersion.toBuilder() : null;
        }

        public final void setLatestVersion(ApplicationVersionSummary.BuilderImpl latestVersion) {
            this.latestVersion = latestVersion != null ? latestVersion.build() : null;
        }

        @Override
        public final Builder latestVersion(ApplicationVersionSummary latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final Collection<String> getListenerArns() {
            if (listenerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return listenerArns;
        }

        public final void setListenerArns(Collection<String> listenerArns) {
            this.listenerArns = ArnListCopier.copy(listenerArns);
        }

        @Override
        public final Builder listenerArns(Collection<String> listenerArns) {
            this.listenerArns = ArnListCopier.copy(listenerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerArns(String... listenerArns) {
            listenerArns(Arrays.asList(listenerArns));
            return this;
        }

        public final Collection<Integer> getListenerPorts() {
            if (listenerPorts instanceof SdkAutoConstructList) {
                return null;
            }
            return listenerPorts;
        }

        public final void setListenerPorts(Collection<Integer> listenerPorts) {
            this.listenerPorts = PortListCopier.copy(listenerPorts);
        }

        @Override
        public final Builder listenerPorts(Collection<Integer> listenerPorts) {
            this.listenerPorts = PortListCopier.copy(listenerPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerPorts(Integer... listenerPorts) {
            listenerPorts(Arrays.asList(listenerPorts));
            return this;
        }

        public final String getLoadBalancerDnsName() {
            return loadBalancerDnsName;
        }

        public final void setLoadBalancerDnsName(String loadBalancerDnsName) {
            this.loadBalancerDnsName = loadBalancerDnsName;
        }

        @Override
        public final Builder loadBalancerDnsName(String loadBalancerDnsName) {
            this.loadBalancerDnsName = loadBalancerDnsName;
            return this;
        }

        public final List<LogGroupSummary.Builder> getLogGroups() {
            List<LogGroupSummary.Builder> result = LogGroupSummariesCopier.copyToBuilder(this.logGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogGroups(Collection<LogGroupSummary.BuilderImpl> logGroups) {
            this.logGroups = LogGroupSummariesCopier.copyFromBuilder(logGroups);
        }

        @Override
        public final Builder logGroups(Collection<LogGroupSummary> logGroups) {
            this.logGroups = LogGroupSummariesCopier.copy(logGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(LogGroupSummary... logGroups) {
            logGroups(Arrays.asList(logGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(Consumer<LogGroupSummary.Builder>... logGroups) {
            logGroups(Stream.of(logGroups).map(c -> LogGroupSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getTargetGroupArns() {
            if (targetGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return targetGroupArns;
        }

        public final void setTargetGroupArns(Collection<String> targetGroupArns) {
            this.targetGroupArns = ArnListCopier.copy(targetGroupArns);
        }

        @Override
        public final Builder targetGroupArns(Collection<String> targetGroupArns) {
            this.targetGroupArns = ArnListCopier.copy(targetGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupArns(String... targetGroupArns) {
            targetGroupArns(Arrays.asList(targetGroupArns));
            return this;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
