/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationVersionResponse extends M2Response implements
        ToCopyableBuilder<GetApplicationVersionResponse.Builder, GetApplicationVersionResponse> {
    private static final SdkField<Integer> APPLICATION_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("applicationVersion").getter(getter(GetApplicationVersionResponse::applicationVersion))
            .setter(setter(Builder::applicationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetApplicationVersionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> DEFINITION_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definitionContent").getter(getter(GetApplicationVersionResponse::definitionContent))
            .setter(setter(Builder::definitionContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionContent").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetApplicationVersionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetApplicationVersionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetApplicationVersionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(GetApplicationVersionResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_VERSION_FIELD,
            CREATION_TIME_FIELD, DEFINITION_CONTENT_FIELD, DESCRIPTION_FIELD, NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));

    private final Integer applicationVersion;

    private final Instant creationTime;

    private final String definitionContent;

    private final String description;

    private final String name;

    private final String status;

    private final String statusReason;

    private GetApplicationVersionResponse(BuilderImpl builder) {
        super(builder);
        this.applicationVersion = builder.applicationVersion;
        this.creationTime = builder.creationTime;
        this.definitionContent = builder.definitionContent;
        this.description = builder.description;
        this.name = builder.name;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The specific version of the application.
     * </p>
     * 
     * @return The specific version of the application.
     */
    public final Integer applicationVersion() {
        return applicationVersion;
    }

    /**
     * <p>
     * The timestamp when the application version was created.
     * </p>
     * 
     * @return The timestamp when the application version was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The content of the application definition. This is a JSON object that contains the resource
     * configuration/definitions that identify an application.
     * </p>
     * 
     * @return The content of the application definition. This is a JSON object that contains the resource
     *         configuration/definitions that identify an application.
     */
    public final String definitionContent() {
        return definitionContent;
    }

    /**
     * <p>
     * The application description.
     * </p>
     * 
     * @return The application description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the application version.
     * </p>
     * 
     * @return The name of the application version.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the application version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationVersionLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the application version.
     * @see ApplicationVersionLifecycle
     */
    public final ApplicationVersionLifecycle status() {
        return ApplicationVersionLifecycle.fromValue(status);
    }

    /**
     * <p>
     * The status of the application version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationVersionLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the application version.
     * @see ApplicationVersionLifecycle
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the reported status.
     * </p>
     * 
     * @return The reason for the reported status.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(definitionContent());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationVersionResponse)) {
            return false;
        }
        GetApplicationVersionResponse other = (GetApplicationVersionResponse) obj;
        return Objects.equals(applicationVersion(), other.applicationVersion())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(definitionContent(), other.definitionContent())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationVersionResponse").add("ApplicationVersion", applicationVersion())
                .add("CreationTime", creationTime()).add("DefinitionContent", definitionContent())
                .add("Description", description()).add("Name", name()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationVersion":
            return Optional.ofNullable(clazz.cast(applicationVersion()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "definitionContent":
            return Optional.ofNullable(clazz.cast(definitionContent()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationVersionResponse, T> g) {
        return obj -> g.apply((GetApplicationVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends M2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetApplicationVersionResponse> {
        /**
         * <p>
         * The specific version of the application.
         * </p>
         * 
         * @param applicationVersion
         *        The specific version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersion(Integer applicationVersion);

        /**
         * <p>
         * The timestamp when the application version was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when the application version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The content of the application definition. This is a JSON object that contains the resource
         * configuration/definitions that identify an application.
         * </p>
         * 
         * @param definitionContent
         *        The content of the application definition. This is a JSON object that contains the resource
         *        configuration/definitions that identify an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionContent(String definitionContent);

        /**
         * <p>
         * The application description.
         * </p>
         * 
         * @param description
         *        The application description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the application version.
         * </p>
         * 
         * @param name
         *        The name of the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the application version.
         * </p>
         * 
         * @param status
         *        The status of the application version.
         * @see ApplicationVersionLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationVersionLifecycle
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the application version.
         * </p>
         * 
         * @param status
         *        The status of the application version.
         * @see ApplicationVersionLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationVersionLifecycle
         */
        Builder status(ApplicationVersionLifecycle status);

        /**
         * <p>
         * The reason for the reported status.
         * </p>
         * 
         * @param statusReason
         *        The reason for the reported status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl extends M2Response.BuilderImpl implements Builder {
        private Integer applicationVersion;

        private Instant creationTime;

        private String definitionContent;

        private String description;

        private String name;

        private String status;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationVersionResponse model) {
            super(model);
            applicationVersion(model.applicationVersion);
            creationTime(model.creationTime);
            definitionContent(model.definitionContent);
            description(model.description);
            name(model.name);
            status(model.status);
            statusReason(model.statusReason);
        }

        public final Integer getApplicationVersion() {
            return applicationVersion;
        }

        public final void setApplicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        @Override
        public final Builder applicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDefinitionContent() {
            return definitionContent;
        }

        public final void setDefinitionContent(String definitionContent) {
            this.definitionContent = definitionContent;
        }

        @Override
        public final Builder definitionContent(String definitionContent) {
            this.definitionContent = definitionContent;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationVersionLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public GetApplicationVersionResponse build() {
            return new GetApplicationVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
