/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The required attributes for a generation data group data set. A generation data set is one of a collection of
 * successive, historically related, catalogued data sets that together are known as a generation data group (GDG). Use
 * this structure when you want to import a GDG. For more information on GDG, see <a
 * href="https://www.ibm.com/docs/en/zos/2.3.0?topic=guide-generation-data-sets">Generation data sets</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GdgAttributes implements SdkPojo, Serializable, ToCopyableBuilder<GdgAttributes.Builder, GdgAttributes> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(GdgAttributes::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final SdkField<String> ROLL_DISPOSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rollDisposition").getter(getter(GdgAttributes::rollDisposition))
            .setter(setter(Builder::rollDisposition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollDisposition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD,
            ROLL_DISPOSITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer limit;

    private final String rollDisposition;

    private GdgAttributes(BuilderImpl builder) {
        this.limit = builder.limit;
        this.rollDisposition = builder.rollDisposition;
    }

    /**
     * <p>
     * The maximum number of generation data sets, up to 255, in a GDG.
     * </p>
     * 
     * @return The maximum number of generation data sets, up to 255, in a GDG.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The disposition of the data set in the catalog.
     * </p>
     * 
     * @return The disposition of the data set in the catalog.
     */
    public final String rollDisposition() {
        return rollDisposition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(rollDisposition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GdgAttributes)) {
            return false;
        }
        GdgAttributes other = (GdgAttributes) obj;
        return Objects.equals(limit(), other.limit()) && Objects.equals(rollDisposition(), other.rollDisposition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GdgAttributes").add("Limit", limit()).add("RollDisposition", rollDisposition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "rollDisposition":
            return Optional.ofNullable(clazz.cast(rollDisposition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GdgAttributes, T> g) {
        return obj -> g.apply((GdgAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GdgAttributes> {
        /**
         * <p>
         * The maximum number of generation data sets, up to 255, in a GDG.
         * </p>
         * 
         * @param limit
         *        The maximum number of generation data sets, up to 255, in a GDG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The disposition of the data set in the catalog.
         * </p>
         * 
         * @param rollDisposition
         *        The disposition of the data set in the catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollDisposition(String rollDisposition);
    }

    static final class BuilderImpl implements Builder {
        private Integer limit;

        private String rollDisposition;

        private BuilderImpl() {
        }

        private BuilderImpl(GdgAttributes model) {
            limit(model.limit);
            rollDisposition(model.rollDisposition);
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getRollDisposition() {
            return rollDisposition;
        }

        public final void setRollDisposition(String rollDisposition) {
            this.rollDisposition = rollDisposition;
        }

        @Override
        public final Builder rollDisposition(String rollDisposition) {
            this.rollDisposition = rollDisposition;
            return this;
        }

        @Override
        public GdgAttributes build() {
            return new GdgAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
