/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.m2.model.CancelBatchJobExecutionRequest;
import software.amazon.awssdk.services.m2.model.CancelBatchJobExecutionResponse;
import software.amazon.awssdk.services.m2.model.CreateApplicationRequest;
import software.amazon.awssdk.services.m2.model.CreateApplicationResponse;
import software.amazon.awssdk.services.m2.model.CreateDataSetImportTaskRequest;
import software.amazon.awssdk.services.m2.model.CreateDataSetImportTaskResponse;
import software.amazon.awssdk.services.m2.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.m2.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.m2.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.m2.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.m2.model.DeleteApplicationFromEnvironmentRequest;
import software.amazon.awssdk.services.m2.model.DeleteApplicationFromEnvironmentResponse;
import software.amazon.awssdk.services.m2.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.m2.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.m2.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.m2.model.DeleteEnvironmentResponse;
import software.amazon.awssdk.services.m2.model.GetApplicationRequest;
import software.amazon.awssdk.services.m2.model.GetApplicationResponse;
import software.amazon.awssdk.services.m2.model.GetApplicationVersionRequest;
import software.amazon.awssdk.services.m2.model.GetApplicationVersionResponse;
import software.amazon.awssdk.services.m2.model.GetBatchJobExecutionRequest;
import software.amazon.awssdk.services.m2.model.GetBatchJobExecutionResponse;
import software.amazon.awssdk.services.m2.model.GetDataSetDetailsRequest;
import software.amazon.awssdk.services.m2.model.GetDataSetDetailsResponse;
import software.amazon.awssdk.services.m2.model.GetDataSetImportTaskRequest;
import software.amazon.awssdk.services.m2.model.GetDataSetImportTaskResponse;
import software.amazon.awssdk.services.m2.model.GetDeploymentRequest;
import software.amazon.awssdk.services.m2.model.GetDeploymentResponse;
import software.amazon.awssdk.services.m2.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.m2.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.m2.model.ListApplicationVersionsRequest;
import software.amazon.awssdk.services.m2.model.ListApplicationVersionsResponse;
import software.amazon.awssdk.services.m2.model.ListApplicationsRequest;
import software.amazon.awssdk.services.m2.model.ListApplicationsResponse;
import software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsRequest;
import software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsResponse;
import software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsRequest;
import software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsResponse;
import software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryRequest;
import software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryResponse;
import software.amazon.awssdk.services.m2.model.ListDataSetsRequest;
import software.amazon.awssdk.services.m2.model.ListDataSetsResponse;
import software.amazon.awssdk.services.m2.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.m2.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.m2.model.ListEngineVersionsRequest;
import software.amazon.awssdk.services.m2.model.ListEngineVersionsResponse;
import software.amazon.awssdk.services.m2.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.m2.model.ListEnvironmentsResponse;
import software.amazon.awssdk.services.m2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.m2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.m2.model.StartApplicationRequest;
import software.amazon.awssdk.services.m2.model.StartApplicationResponse;
import software.amazon.awssdk.services.m2.model.StartBatchJobRequest;
import software.amazon.awssdk.services.m2.model.StartBatchJobResponse;
import software.amazon.awssdk.services.m2.model.StopApplicationRequest;
import software.amazon.awssdk.services.m2.model.StopApplicationResponse;
import software.amazon.awssdk.services.m2.model.TagResourceRequest;
import software.amazon.awssdk.services.m2.model.TagResourceResponse;
import software.amazon.awssdk.services.m2.model.UntagResourceRequest;
import software.amazon.awssdk.services.m2.model.UntagResourceResponse;
import software.amazon.awssdk.services.m2.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.m2.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.m2.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.m2.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.m2.paginators.ListApplicationVersionsPublisher;
import software.amazon.awssdk.services.m2.paginators.ListApplicationsPublisher;
import software.amazon.awssdk.services.m2.paginators.ListBatchJobDefinitionsPublisher;
import software.amazon.awssdk.services.m2.paginators.ListBatchJobExecutionsPublisher;
import software.amazon.awssdk.services.m2.paginators.ListDataSetImportHistoryPublisher;
import software.amazon.awssdk.services.m2.paginators.ListDataSetsPublisher;
import software.amazon.awssdk.services.m2.paginators.ListDeploymentsPublisher;
import software.amazon.awssdk.services.m2.paginators.ListEngineVersionsPublisher;
import software.amazon.awssdk.services.m2.paginators.ListEnvironmentsPublisher;

/**
 * Service client for accessing AWSMainframeModernization asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services Mainframe Modernization provides tools and resources to help you plan and implement migration and
 * modernization from mainframes to Amazon Web Services managed runtime environments. It provides tools for analyzing
 * existing mainframe applications, developing or updating mainframe applications using COBOL or PL/I, and implementing
 * an automated pipeline for continuous integration and continuous delivery (CI/CD) of the applications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface M2AsyncClient extends SdkClient {
    String SERVICE_NAME = "m2";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "m2";

    /**
     * <p>
     * Cancels the running of a specific batch job execution.
     * </p>
     *
     * @param cancelBatchJobExecutionRequest
     * @return A Java Future containing the result of the CancelBatchJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.CancelBatchJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CancelBatchJobExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelBatchJobExecutionResponse> cancelBatchJobExecution(
            CancelBatchJobExecutionRequest cancelBatchJobExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the running of a specific batch job execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelBatchJobExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link CancelBatchJobExecutionRequest#builder()}
     * </p>
     *
     * @param cancelBatchJobExecutionRequest
     *        A {@link Consumer} that will call methods on {@link CancelBatchJobExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelBatchJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.CancelBatchJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CancelBatchJobExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelBatchJobExecutionResponse> cancelBatchJobExecution(
            Consumer<CancelBatchJobExecutionRequest.Builder> cancelBatchJobExecutionRequest) {
        return cancelBatchJobExecution(CancelBatchJobExecutionRequest.builder().applyMutation(cancelBatchJobExecutionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new application with given parameters. Requires an existing runtime environment and application
     * definition file.
     * </p>
     *
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ServiceQuotaExceededException One or more quotas for Amazon Web Services Mainframe Modernization
     *         exceeds the limit.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new application with given parameters. Requires an existing runtime environment and application
     * definition file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ServiceQuotaExceededException One or more quotas for Amazon Web Services Mainframe Modernization
     *         exceeds the limit.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Starts a data set import task for a specific application.
     * </p>
     *
     * @param createDataSetImportTaskRequest
     * @return A Java Future containing the result of the CreateDataSetImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ServiceQuotaExceededException One or more quotas for Amazon Web Services Mainframe Modernization
     *         exceeds the limit.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.CreateDataSetImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateDataSetImportTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataSetImportTaskResponse> createDataSetImportTask(
            CreateDataSetImportTaskRequest createDataSetImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a data set import task for a specific application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSetImportTaskRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDataSetImportTaskRequest#builder()}
     * </p>
     *
     * @param createDataSetImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataSetImportTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataSetImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ServiceQuotaExceededException One or more quotas for Amazon Web Services Mainframe Modernization
     *         exceeds the limit.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.CreateDataSetImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateDataSetImportTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataSetImportTaskResponse> createDataSetImportTask(
            Consumer<CreateDataSetImportTaskRequest.Builder> createDataSetImportTaskRequest) {
        return createDataSetImportTask(CreateDataSetImportTaskRequest.builder().applyMutation(createDataSetImportTaskRequest)
                .build());
    }

    /**
     * <p>
     * Creates and starts a deployment to deploy an application into a runtime environment.
     * </p>
     *
     * @param createDeploymentRequest
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ServiceQuotaExceededException One or more quotas for Amazon Web Services Mainframe Modernization
     *         exceeds the limit.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and starts a deployment to deploy an application into a runtime environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeploymentRequest#builder()}
     * </p>
     *
     * @param createDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ServiceQuotaExceededException One or more quotas for Amazon Web Services Mainframe Modernization
     *         exceeds the limit.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDeploymentResponse> createDeployment(
            Consumer<CreateDeploymentRequest.Builder> createDeploymentRequest) {
        return createDeployment(CreateDeploymentRequest.builder().applyMutation(createDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates a runtime environment for a given runtime engine.
     * </p>
     *
     * @param createEnvironmentRequest
     * @return A Java Future containing the result of the CreateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ServiceQuotaExceededException One or more quotas for Amazon Web Services Mainframe Modernization
     *         exceeds the limit.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentResponse> createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a runtime environment for a given runtime engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEnvironmentRequest#builder()}
     * </p>
     *
     * @param createEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateEnvironmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ServiceQuotaExceededException One or more quotas for Amazon Web Services Mainframe Modernization
     *         exceeds the limit.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.CreateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/CreateEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentResponse> createEnvironment(
            Consumer<CreateEnvironmentRequest.Builder> createEnvironmentRequest) {
        return createEnvironment(CreateEnvironmentRequest.builder().applyMutation(createEnvironmentRequest).build());
    }

    /**
     * <p>
     * Deletes a specific application. You cannot delete a running application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/DeleteApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific application. You cannot delete a running application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/DeleteApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(
            Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest) {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes a specific application from the specific runtime environment where it was previously deployed. You cannot
     * delete a runtime environment using DeleteEnvironment if any application has ever been deployed to it. This API
     * removes the association of the application with the runtime environment so you can delete the environment
     * smoothly.
     * </p>
     *
     * @param deleteApplicationFromEnvironmentRequest
     * @return A Java Future containing the result of the DeleteApplicationFromEnvironment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.DeleteApplicationFromEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/DeleteApplicationFromEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationFromEnvironmentResponse> deleteApplicationFromEnvironment(
            DeleteApplicationFromEnvironmentRequest deleteApplicationFromEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific application from the specific runtime environment where it was previously deployed. You cannot
     * delete a runtime environment using DeleteEnvironment if any application has ever been deployed to it. This API
     * removes the association of the application with the runtime environment so you can delete the environment
     * smoothly.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationFromEnvironmentRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteApplicationFromEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteApplicationFromEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationFromEnvironmentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteApplicationFromEnvironment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.DeleteApplicationFromEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/DeleteApplicationFromEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationFromEnvironmentResponse> deleteApplicationFromEnvironment(
            Consumer<DeleteApplicationFromEnvironmentRequest.Builder> deleteApplicationFromEnvironmentRequest) {
        return deleteApplicationFromEnvironment(DeleteApplicationFromEnvironmentRequest.builder()
                .applyMutation(deleteApplicationFromEnvironmentRequest).build());
    }

    /**
     * <p>
     * Deletes a specific runtime environment. The environment cannot contain deployed applications. If it does, you
     * must delete those applications before you delete the environment.
     * </p>
     *
     * @param deleteEnvironmentRequest
     * @return A Java Future containing the result of the DeleteEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/DeleteEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific runtime environment. The environment cannot contain deployed applications. If it does, you
     * must delete those applications before you delete the environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEnvironmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/DeleteEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(
            Consumer<DeleteEnvironmentRequest.Builder> deleteEnvironmentRequest) {
        return deleteEnvironment(DeleteEnvironmentRequest.builder().applyMutation(deleteEnvironmentRequest).build());
    }

    /**
     * <p>
     * Describes the details of a specific application.
     * </p>
     *
     * @param getApplicationRequest
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details of a specific application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on {@link GetApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest) {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * Returns details about a specific version of a specific application.
     * </p>
     *
     * @param getApplicationVersionRequest
     * @return A Java Future containing the result of the GetApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetApplicationVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApplicationVersionResponse> getApplicationVersion(
            GetApplicationVersionRequest getApplicationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a specific version of a specific application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationVersionRequest.Builder} avoiding the
     * need to create one manually via {@link GetApplicationVersionRequest#builder()}
     * </p>
     *
     * @param getApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetApplicationVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetApplicationVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApplicationVersionResponse> getApplicationVersion(
            Consumer<GetApplicationVersionRequest.Builder> getApplicationVersionRequest) {
        return getApplicationVersion(GetApplicationVersionRequest.builder().applyMutation(getApplicationVersionRequest).build());
    }

    /**
     * <p>
     * Gets the details of a specific batch job execution for a specific application.
     * </p>
     *
     * @param getBatchJobExecutionRequest
     * @return A Java Future containing the result of the GetBatchJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetBatchJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetBatchJobExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBatchJobExecutionResponse> getBatchJobExecution(
            GetBatchJobExecutionRequest getBatchJobExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a specific batch job execution for a specific application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBatchJobExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link GetBatchJobExecutionRequest#builder()}
     * </p>
     *
     * @param getBatchJobExecutionRequest
     *        A {@link Consumer} that will call methods on {@link GetBatchJobExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetBatchJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetBatchJobExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetBatchJobExecution" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBatchJobExecutionResponse> getBatchJobExecution(
            Consumer<GetBatchJobExecutionRequest.Builder> getBatchJobExecutionRequest) {
        return getBatchJobExecution(GetBatchJobExecutionRequest.builder().applyMutation(getBatchJobExecutionRequest).build());
    }

    /**
     * <p>
     * Gets the details of a specific data set.
     * </p>
     *
     * @param getDataSetDetailsRequest
     * @return A Java Future containing the result of the GetDataSetDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetDataSetDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetDataSetDetails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSetDetailsResponse> getDataSetDetails(GetDataSetDetailsRequest getDataSetDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a specific data set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSetDetailsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDataSetDetailsRequest#builder()}
     * </p>
     *
     * @param getDataSetDetailsRequest
     *        A {@link Consumer} that will call methods on {@link GetDataSetDetailsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDataSetDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetDataSetDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetDataSetDetails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSetDetailsResponse> getDataSetDetails(
            Consumer<GetDataSetDetailsRequest.Builder> getDataSetDetailsRequest) {
        return getDataSetDetails(GetDataSetDetailsRequest.builder().applyMutation(getDataSetDetailsRequest).build());
    }

    /**
     * <p>
     * Gets the status of a data set import task initiated with the <a>CreateDataSetImportTask</a> operation.
     * </p>
     *
     * @param getDataSetImportTaskRequest
     * @return A Java Future containing the result of the GetDataSetImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetDataSetImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetDataSetImportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSetImportTaskResponse> getDataSetImportTask(
            GetDataSetImportTaskRequest getDataSetImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of a data set import task initiated with the <a>CreateDataSetImportTask</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSetImportTaskRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataSetImportTaskRequest#builder()}
     * </p>
     *
     * @param getDataSetImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetDataSetImportTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDataSetImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetDataSetImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetDataSetImportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSetImportTaskResponse> getDataSetImportTask(
            Consumer<GetDataSetImportTaskRequest.Builder> getDataSetImportTaskRequest) {
        return getDataSetImportTask(GetDataSetImportTaskRequest.builder().applyMutation(getDataSetImportTaskRequest).build());
    }

    /**
     * <p>
     * Gets details of a specific deployment with a given deployment identifier.
     * </p>
     *
     * @param getDeploymentRequest
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details of a specific deployment with a given deployment identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentRequest#builder()}
     * </p>
     *
     * @param getDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetDeployment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest) {
        return getDeployment(GetDeploymentRequest.builder().applyMutation(getDeploymentRequest).build());
    }

    /**
     * <p>
     * Describes a specific runtime environment.
     * </p>
     *
     * @param getEnvironmentRequest
     * @return A Java Future containing the result of the GetEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEnvironmentResponse> getEnvironment(GetEnvironmentRequest getEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a specific runtime environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnvironmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetEnvironmentRequest#builder()}
     * </p>
     *
     * @param getEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link GetEnvironmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.GetEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/GetEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEnvironmentResponse> getEnvironment(Consumer<GetEnvironmentRequest.Builder> getEnvironmentRequest) {
        return getEnvironment(GetEnvironmentRequest.builder().applyMutation(getEnvironmentRequest).build());
    }

    /**
     * <p>
     * Returns a list of the application versions for a specific application.
     * </p>
     *
     * @param listApplicationVersionsRequest
     * @return A Java Future containing the result of the ListApplicationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListApplicationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListApplicationVersionsResponse> listApplicationVersions(
            ListApplicationVersionsRequest listApplicationVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the application versions for a specific application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationVersionsRequest#builder()}
     * </p>
     *
     * @param listApplicationVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApplicationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListApplicationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListApplicationVersionsResponse> listApplicationVersions(
            Consumer<ListApplicationVersionsRequest.Builder> listApplicationVersionsRequest) {
        return listApplicationVersions(ListApplicationVersionsRequest.builder().applyMutation(listApplicationVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the application versions for a specific application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationVersions(software.amazon.awssdk.services.m2.model.ListApplicationVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListApplicationVersionsPublisher publisher = client.listApplicationVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListApplicationVersionsPublisher publisher = client.listApplicationVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListApplicationVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListApplicationVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationVersions(software.amazon.awssdk.services.m2.model.ListApplicationVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListApplicationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationVersionsPublisher listApplicationVersionsPaginator(
            ListApplicationVersionsRequest listApplicationVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the application versions for a specific application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationVersions(software.amazon.awssdk.services.m2.model.ListApplicationVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListApplicationVersionsPublisher publisher = client.listApplicationVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListApplicationVersionsPublisher publisher = client.listApplicationVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListApplicationVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListApplicationVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationVersions(software.amazon.awssdk.services.m2.model.ListApplicationVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationVersionsRequest#builder()}
     * </p>
     *
     * @param listApplicationVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListApplicationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationVersionsPublisher listApplicationVersionsPaginator(
            Consumer<ListApplicationVersionsRequest.Builder> listApplicationVersionsRequest) {
        return listApplicationVersionsPaginator(ListApplicationVersionsRequest.builder()
                .applyMutation(listApplicationVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the applications associated with a specific Amazon Web Services account. You can provide the unique
     * identifier of a specific runtime environment in a query parameter to see all applications associated with that
     * environment.
     * </p>
     *
     * @param listApplicationsRequest
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the applications associated with a specific Amazon Web Services account. You can provide the unique
     * identifier of a specific runtime environment in a query parameter to see all applications associated with that
     * environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(
            Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists the applications associated with a specific Amazon Web Services account. You can provide the unique
     * identifier of a specific runtime environment in a query parameter to see all applications associated with that
     * environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApplications(software.amazon.awssdk.services.m2.model.ListApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.m2.model.ListApplicationsRequest)} operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the applications associated with a specific Amazon Web Services account. You can provide the unique
     * identifier of a specific runtime environment in a query parameter to see all applications associated with that
     * environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApplications(software.amazon.awssdk.services.m2.model.ListApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.m2.model.ListApplicationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists all the available batch job definitions based on the batch job resources uploaded during the application
     * creation. You can use the batch job definitions in the list to start a batch job.
     * </p>
     *
     * @param listBatchJobDefinitionsRequest
     * @return A Java Future containing the result of the ListBatchJobDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListBatchJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListBatchJobDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBatchJobDefinitionsResponse> listBatchJobDefinitions(
            ListBatchJobDefinitionsRequest listBatchJobDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the available batch job definitions based on the batch job resources uploaded during the application
     * creation. You can use the batch job definitions in the list to start a batch job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBatchJobDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListBatchJobDefinitionsRequest#builder()}
     * </p>
     *
     * @param listBatchJobDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBatchJobDefinitionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBatchJobDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListBatchJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListBatchJobDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBatchJobDefinitionsResponse> listBatchJobDefinitions(
            Consumer<ListBatchJobDefinitionsRequest.Builder> listBatchJobDefinitionsRequest) {
        return listBatchJobDefinitions(ListBatchJobDefinitionsRequest.builder().applyMutation(listBatchJobDefinitionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the available batch job definitions based on the batch job resources uploaded during the application
     * creation. You can use the batch job definitions in the list to start a batch job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBatchJobDefinitions(software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListBatchJobDefinitionsPublisher publisher = client.listBatchJobDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListBatchJobDefinitionsPublisher publisher = client.listBatchJobDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBatchJobDefinitions(software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBatchJobDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListBatchJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListBatchJobDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBatchJobDefinitionsPublisher listBatchJobDefinitionsPaginator(
            ListBatchJobDefinitionsRequest listBatchJobDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the available batch job definitions based on the batch job resources uploaded during the application
     * creation. You can use the batch job definitions in the list to start a batch job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBatchJobDefinitions(software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListBatchJobDefinitionsPublisher publisher = client.listBatchJobDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListBatchJobDefinitionsPublisher publisher = client.listBatchJobDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBatchJobDefinitions(software.amazon.awssdk.services.m2.model.ListBatchJobDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBatchJobDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListBatchJobDefinitionsRequest#builder()}
     * </p>
     *
     * @param listBatchJobDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBatchJobDefinitionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListBatchJobDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListBatchJobDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBatchJobDefinitionsPublisher listBatchJobDefinitionsPaginator(
            Consumer<ListBatchJobDefinitionsRequest.Builder> listBatchJobDefinitionsRequest) {
        return listBatchJobDefinitionsPaginator(ListBatchJobDefinitionsRequest.builder()
                .applyMutation(listBatchJobDefinitionsRequest).build());
    }

    /**
     * <p>
     * Lists historical, current, and scheduled batch job executions for a specific application.
     * </p>
     *
     * @param listBatchJobExecutionsRequest
     * @return A Java Future containing the result of the ListBatchJobExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListBatchJobExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListBatchJobExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBatchJobExecutionsResponse> listBatchJobExecutions(
            ListBatchJobExecutionsRequest listBatchJobExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists historical, current, and scheduled batch job executions for a specific application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBatchJobExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBatchJobExecutionsRequest#builder()}
     * </p>
     *
     * @param listBatchJobExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBatchJobExecutionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBatchJobExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListBatchJobExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListBatchJobExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBatchJobExecutionsResponse> listBatchJobExecutions(
            Consumer<ListBatchJobExecutionsRequest.Builder> listBatchJobExecutionsRequest) {
        return listBatchJobExecutions(ListBatchJobExecutionsRequest.builder().applyMutation(listBatchJobExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists historical, current, and scheduled batch job executions for a specific application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBatchJobExecutions(software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListBatchJobExecutionsPublisher publisher = client.listBatchJobExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListBatchJobExecutionsPublisher publisher = client.listBatchJobExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBatchJobExecutions(software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBatchJobExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListBatchJobExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListBatchJobExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBatchJobExecutionsPublisher listBatchJobExecutionsPaginator(
            ListBatchJobExecutionsRequest listBatchJobExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists historical, current, and scheduled batch job executions for a specific application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBatchJobExecutions(software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListBatchJobExecutionsPublisher publisher = client.listBatchJobExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListBatchJobExecutionsPublisher publisher = client.listBatchJobExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBatchJobExecutions(software.amazon.awssdk.services.m2.model.ListBatchJobExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBatchJobExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBatchJobExecutionsRequest#builder()}
     * </p>
     *
     * @param listBatchJobExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBatchJobExecutionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListBatchJobExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListBatchJobExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBatchJobExecutionsPublisher listBatchJobExecutionsPaginator(
            Consumer<ListBatchJobExecutionsRequest.Builder> listBatchJobExecutionsRequest) {
        return listBatchJobExecutionsPaginator(ListBatchJobExecutionsRequest.builder()
                .applyMutation(listBatchJobExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists the data set imports for the specified application.
     * </p>
     *
     * @param listDataSetImportHistoryRequest
     * @return A Java Future containing the result of the ListDataSetImportHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListDataSetImportHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDataSetImportHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDataSetImportHistoryResponse> listDataSetImportHistory(
            ListDataSetImportHistoryRequest listDataSetImportHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the data set imports for the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSetImportHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataSetImportHistoryRequest#builder()}
     * </p>
     *
     * @param listDataSetImportHistoryRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSetImportHistoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDataSetImportHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListDataSetImportHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDataSetImportHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDataSetImportHistoryResponse> listDataSetImportHistory(
            Consumer<ListDataSetImportHistoryRequest.Builder> listDataSetImportHistoryRequest) {
        return listDataSetImportHistory(ListDataSetImportHistoryRequest.builder().applyMutation(listDataSetImportHistoryRequest)
                .build());
    }

    /**
     * <p>
     * Lists the data set imports for the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSetImportHistory(software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListDataSetImportHistoryPublisher publisher = client.listDataSetImportHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListDataSetImportHistoryPublisher publisher = client.listDataSetImportHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSetImportHistory(software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataSetImportHistoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListDataSetImportHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDataSetImportHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSetImportHistoryPublisher listDataSetImportHistoryPaginator(
            ListDataSetImportHistoryRequest listDataSetImportHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the data set imports for the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSetImportHistory(software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListDataSetImportHistoryPublisher publisher = client.listDataSetImportHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListDataSetImportHistoryPublisher publisher = client.listDataSetImportHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSetImportHistory(software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSetImportHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataSetImportHistoryRequest#builder()}
     * </p>
     *
     * @param listDataSetImportHistoryRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSetImportHistoryRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListDataSetImportHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDataSetImportHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataSetImportHistoryPublisher listDataSetImportHistoryPaginator(
            Consumer<ListDataSetImportHistoryRequest.Builder> listDataSetImportHistoryRequest) {
        return listDataSetImportHistoryPaginator(ListDataSetImportHistoryRequest.builder()
                .applyMutation(listDataSetImportHistoryRequest).build());
    }

    /**
     * <p>
     * Lists the data sets imported for a specific application. In Amazon Web Services Mainframe Modernization, data
     * sets are associated with applications deployed on runtime environments. This is known as importing data sets.
     * Currently, Amazon Web Services Mainframe Modernization can import data sets into catalogs using <a
     * href="https://docs.aws.amazon.com/m2/latest/APIReference/API_CreateDataSetImportTask.html"
     * >CreateDataSetImportTask</a>.
     * </p>
     *
     * @param listDataSetsRequest
     * @return A Java Future containing the result of the ListDataSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListDataSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSetsResponse> listDataSets(ListDataSetsRequest listDataSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the data sets imported for a specific application. In Amazon Web Services Mainframe Modernization, data
     * sets are associated with applications deployed on runtime environments. This is known as importing data sets.
     * Currently, Amazon Web Services Mainframe Modernization can import data sets into catalogs using <a
     * href="https://docs.aws.amazon.com/m2/latest/APIReference/API_CreateDataSetImportTask.html"
     * >CreateDataSetImportTask</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDataSetsRequest#builder()}
     * </p>
     *
     * @param listDataSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDataSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListDataSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSetsResponse> listDataSets(Consumer<ListDataSetsRequest.Builder> listDataSetsRequest) {
        return listDataSets(ListDataSetsRequest.builder().applyMutation(listDataSetsRequest).build());
    }

    /**
     * <p>
     * Lists the data sets imported for a specific application. In Amazon Web Services Mainframe Modernization, data
     * sets are associated with applications deployed on runtime environments. This is known as importing data sets.
     * Currently, Amazon Web Services Mainframe Modernization can import data sets into catalogs using <a
     * href="https://docs.aws.amazon.com/m2/latest/APIReference/API_CreateDataSetImportTask.html"
     * >CreateDataSetImportTask</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDataSets(software.amazon.awssdk.services.m2.model.ListDataSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListDataSetsPublisher publisher = client.listDataSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListDataSetsPublisher publisher = client.listDataSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListDataSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListDataSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSets(software.amazon.awssdk.services.m2.model.ListDataSetsRequest)} operation.</b>
     * </p>
     *
     * @param listDataSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListDataSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSetsPublisher listDataSetsPaginator(ListDataSetsRequest listDataSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the data sets imported for a specific application. In Amazon Web Services Mainframe Modernization, data
     * sets are associated with applications deployed on runtime environments. This is known as importing data sets.
     * Currently, Amazon Web Services Mainframe Modernization can import data sets into catalogs using <a
     * href="https://docs.aws.amazon.com/m2/latest/APIReference/API_CreateDataSetImportTask.html"
     * >CreateDataSetImportTask</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDataSets(software.amazon.awssdk.services.m2.model.ListDataSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListDataSetsPublisher publisher = client.listDataSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListDataSetsPublisher publisher = client.listDataSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListDataSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListDataSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSets(software.amazon.awssdk.services.m2.model.ListDataSetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDataSetsRequest#builder()}
     * </p>
     *
     * @param listDataSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDataSetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListDataSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSetsPublisher listDataSetsPaginator(Consumer<ListDataSetsRequest.Builder> listDataSetsRequest) {
        return listDataSetsPaginator(ListDataSetsRequest.builder().applyMutation(listDataSetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all deployments of a specific application. A deployment is a combination of a specific
     * application and a specific version of that application. Each deployment is mapped to a particular application
     * version.
     * </p>
     *
     * @param listDeploymentsRequest
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest listDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all deployments of a specific application. A deployment is a combination of a specific
     * application and a specific version of that application. Each deployment is mapped to a particular application
     * version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDeploymentsResponse> listDeployments(
            Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest) {
        return listDeployments(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all deployments of a specific application. A deployment is a combination of a specific
     * application and a specific version of that application. Each deployment is mapped to a particular application
     * version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDeployments(software.amazon.awssdk.services.m2.model.ListDeploymentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.m2.model.ListDeploymentsRequest)} operation.</b>
     * </p>
     *
     * @param listDeploymentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDeploymentsPublisher listDeploymentsPaginator(ListDeploymentsRequest listDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all deployments of a specific application. A deployment is a combination of a specific
     * application and a specific version of that application. Each deployment is mapped to a particular application
     * version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDeployments(software.amazon.awssdk.services.m2.model.ListDeploymentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListDeploymentsPublisher publisher = client.listDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.m2.model.ListDeploymentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListDeployments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDeploymentsPublisher listDeploymentsPaginator(Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest) {
        return listDeploymentsPaginator(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * Lists the available engine versions.
     * </p>
     *
     * @param listEngineVersionsRequest
     * @return A Java Future containing the result of the ListEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListEngineVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEngineVersionsResponse> listEngineVersions(ListEngineVersionsRequest listEngineVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the available engine versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngineVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEngineVersionsRequest#builder()}
     * </p>
     *
     * @param listEngineVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListEngineVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListEngineVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEngineVersionsResponse> listEngineVersions(
            Consumer<ListEngineVersionsRequest.Builder> listEngineVersionsRequest) {
        return listEngineVersions(ListEngineVersionsRequest.builder().applyMutation(listEngineVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the available engine versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEngineVersions(software.amazon.awssdk.services.m2.model.ListEngineVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListEngineVersionsPublisher publisher = client.listEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListEngineVersionsPublisher publisher = client.listEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngineVersions(software.amazon.awssdk.services.m2.model.ListEngineVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listEngineVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListEngineVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEngineVersionsPublisher listEngineVersionsPaginator(ListEngineVersionsRequest listEngineVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the available engine versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEngineVersions(software.amazon.awssdk.services.m2.model.ListEngineVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListEngineVersionsPublisher publisher = client.listEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListEngineVersionsPublisher publisher = client.listEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngineVersions(software.amazon.awssdk.services.m2.model.ListEngineVersionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngineVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEngineVersionsRequest#builder()}
     * </p>
     *
     * @param listEngineVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListEngineVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListEngineVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEngineVersionsPublisher listEngineVersionsPaginator(
            Consumer<ListEngineVersionsRequest.Builder> listEngineVersionsRequest) {
        return listEngineVersionsPaginator(ListEngineVersionsRequest.builder().applyMutation(listEngineVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the runtime environments.
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return A Java Future containing the result of the ListEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEnvironmentsResponse> listEnvironments(ListEnvironmentsRequest listEnvironmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the runtime environments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListEnvironmentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEnvironmentsResponse> listEnvironments(
            Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) {
        return listEnvironments(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Lists the runtime environments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listEnvironments(software.amazon.awssdk.services.m2.model.ListEnvironmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.m2.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsPublisher listEnvironmentsPaginator(ListEnvironmentsRequest listEnvironmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the runtime environments.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listEnvironments(software.amazon.awssdk.services.m2.model.ListEnvironmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.m2.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.m2.model.ListEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.m2.model.ListEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.m2.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListEnvironmentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsPublisher listEnvironmentsPaginator(Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) {
        return listEnvironmentsPaginator(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts an application that is currently stopped.
     * </p>
     *
     * @param startApplicationRequest
     * @return A Java Future containing the result of the StartApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.StartApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/StartApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartApplicationResponse> startApplication(StartApplicationRequest startApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an application that is currently stopped.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StartApplicationRequest#builder()}
     * </p>
     *
     * @param startApplicationRequest
     *        A {@link Consumer} that will call methods on {@link StartApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.StartApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/StartApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartApplicationResponse> startApplication(
            Consumer<StartApplicationRequest.Builder> startApplicationRequest) {
        return startApplication(StartApplicationRequest.builder().applyMutation(startApplicationRequest).build());
    }

    /**
     * <p>
     * Starts a batch job and returns the unique identifier of this execution of the batch job. The associated
     * application must be running in order to start the batch job.
     * </p>
     *
     * @param startBatchJobRequest
     * @return A Java Future containing the result of the StartBatchJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.StartBatchJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/StartBatchJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartBatchJobResponse> startBatchJob(StartBatchJobRequest startBatchJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a batch job and returns the unique identifier of this execution of the batch job. The associated
     * application must be running in order to start the batch job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartBatchJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartBatchJobRequest#builder()}
     * </p>
     *
     * @param startBatchJobRequest
     *        A {@link Consumer} that will call methods on {@link StartBatchJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartBatchJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.StartBatchJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/StartBatchJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartBatchJobResponse> startBatchJob(Consumer<StartBatchJobRequest.Builder> startBatchJobRequest) {
        return startBatchJob(StartBatchJobRequest.builder().applyMutation(startBatchJobRequest).build());
    }

    /**
     * <p>
     * Stops a running application.
     * </p>
     *
     * @param stopApplicationRequest
     * @return A Java Future containing the result of the StopApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.StopApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/StopApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopApplicationResponse> stopApplication(StopApplicationRequest stopApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a running application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StopApplicationRequest#builder()}
     * </p>
     *
     * @param stopApplicationRequest
     *        A {@link Consumer} that will call methods on {@link StopApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.StopApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/StopApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopApplicationResponse> stopApplication(
            Consumer<StopApplicationRequest.Builder> stopApplicationRequest) {
        return stopApplication(StopApplicationRequest.builder().applyMutation(stopApplicationRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ServiceQuotaExceededException One or more quotas for Amazon Web Services Mainframe Modernization
     *         exceeds the limit.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ServiceQuotaExceededException One or more quotas for Amazon Web Services Mainframe Modernization
     *         exceeds the limit.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an application and creates a new version.
     * </p>
     *
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/UpdateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an application and creates a new version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/UpdateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates the configuration details for a specific runtime environment.
     * </p>
     *
     * @param updateEnvironmentRequest
     * @return A Java Future containing the result of the UpdateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ServiceQuotaExceededException One or more quotas for Amazon Web Services Mainframe Modernization
     *         exceeds the limit.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/UpdateEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration details for a specific runtime environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEnvironmentRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEnvironmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One or more parameters provided in the request is not valid.</li>
     *         <li>ServiceQuotaExceededException One or more quotas for Amazon Web Services Mainframe Modernization
     *         exceeds the limit.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>M2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample M2AsyncClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/m2-2021-04-28/UpdateEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(
            Consumer<UpdateEnvironmentRequest.Builder> updateEnvironmentRequest) {
        return updateEnvironment(UpdateEnvironmentRequest.builder().applyMutation(updateEnvironmentRequest).build());
    }

    /**
     * Create a {@link M2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static M2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link M2AsyncClient}.
     */
    static M2AsyncClientBuilder builder() {
        return new DefaultM2AsyncClientBuilder();
    }
}
