/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A subset of the possible application attributes. Used in the application list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationSummary.Builder, ApplicationSummary> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationArn").getter(getter(ApplicationSummary::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(ApplicationSummary::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<Integer> APPLICATION_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("applicationVersion").getter(getter(ApplicationSummary::applicationVersion))
            .setter(setter(Builder::applicationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(ApplicationSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentStatus").getter(getter(ApplicationSummary::deploymentStatusAsString))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ApplicationSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineType").getter(getter(ApplicationSummary::engineTypeAsString)).setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(ApplicationSummary::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<Instant> LAST_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStartTime").getter(getter(ApplicationSummary::lastStartTime)).setter(setter(Builder::lastStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ApplicationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ApplicationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VERSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionStatus").getter(getter(ApplicationSummary::versionStatusAsString))
            .setter(setter(Builder::versionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            APPLICATION_ID_FIELD, APPLICATION_VERSION_FIELD, CREATION_TIME_FIELD, DEPLOYMENT_STATUS_FIELD, DESCRIPTION_FIELD,
            ENGINE_TYPE_FIELD, ENVIRONMENT_ID_FIELD, LAST_START_TIME_FIELD, NAME_FIELD, STATUS_FIELD, VERSION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationArn;

    private final String applicationId;

    private final Integer applicationVersion;

    private final Instant creationTime;

    private final String deploymentStatus;

    private final String description;

    private final String engineType;

    private final String environmentId;

    private final Instant lastStartTime;

    private final String name;

    private final String status;

    private final String versionStatus;

    private ApplicationSummary(BuilderImpl builder) {
        this.applicationArn = builder.applicationArn;
        this.applicationId = builder.applicationId;
        this.applicationVersion = builder.applicationVersion;
        this.creationTime = builder.creationTime;
        this.deploymentStatus = builder.deploymentStatus;
        this.description = builder.description;
        this.engineType = builder.engineType;
        this.environmentId = builder.environmentId;
        this.lastStartTime = builder.lastStartTime;
        this.name = builder.name;
        this.status = builder.status;
        this.versionStatus = builder.versionStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The unique identifier of the application.
     * </p>
     * 
     * @return The unique identifier of the application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The version of the application.
     * </p>
     * 
     * @return The version of the application.
     */
    public final Integer applicationVersion() {
        return applicationVersion;
    }

    /**
     * <p>
     * The timestamp when the application was created.
     * </p>
     * 
     * @return The timestamp when the application was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Indicates either an ongoing deployment or if the application has ever deployed successfully.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link ApplicationDeploymentLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return Indicates either an ongoing deployment or if the application has ever deployed successfully.
     * @see ApplicationDeploymentLifecycle
     */
    public final ApplicationDeploymentLifecycle deploymentStatus() {
        return ApplicationDeploymentLifecycle.fromValue(deploymentStatus);
    }

    /**
     * <p>
     * Indicates either an ongoing deployment or if the application has ever deployed successfully.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link ApplicationDeploymentLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return Indicates either an ongoing deployment or if the application has ever deployed successfully.
     * @see ApplicationDeploymentLifecycle
     */
    public final String deploymentStatusAsString() {
        return deploymentStatus;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * 
     * @return The description of the application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of the target platform for this application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The type of the target platform for this application.
     * @see EngineType
     */
    public final EngineType engineType() {
        return EngineType.fromValue(engineType);
    }

    /**
     * <p>
     * The type of the target platform for this application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The type of the target platform for this application.
     * @see EngineType
     */
    public final String engineTypeAsString() {
        return engineType;
    }

    /**
     * <p>
     * The unique identifier of the runtime environment that hosts this application.
     * </p>
     * 
     * @return The unique identifier of the runtime environment that hosts this application.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The timestamp when you last started the application. Null until the application runs for the first time.
     * </p>
     * 
     * @return The timestamp when you last started the application. Null until the application runs for the first time.
     */
    public final Instant lastStartTime() {
        return lastStartTime;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationLifecycle
     */
    public final ApplicationLifecycle status() {
        return ApplicationLifecycle.fromValue(status);
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see ApplicationLifecycle
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indicates the status of the latest version of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #versionStatus}
     * will return {@link ApplicationVersionLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #versionStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the latest version of the application.
     * @see ApplicationVersionLifecycle
     */
    public final ApplicationVersionLifecycle versionStatus() {
        return ApplicationVersionLifecycle.fromValue(versionStatus);
    }

    /**
     * <p>
     * Indicates the status of the latest version of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #versionStatus}
     * will return {@link ApplicationVersionLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #versionStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the latest version of the application.
     * @see ApplicationVersionLifecycle
     */
    public final String versionStatusAsString() {
        return versionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(lastStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(versionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary) obj;
        return Objects.equals(applicationArn(), other.applicationArn()) && Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(applicationVersion(), other.applicationVersion())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(deploymentStatusAsString(), other.deploymentStatusAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(engineTypeAsString(), other.engineTypeAsString())
                && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(lastStartTime(), other.lastStartTime()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(versionStatusAsString(), other.versionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationSummary").add("ApplicationArn", applicationArn())
                .add("ApplicationId", applicationId()).add("ApplicationVersion", applicationVersion())
                .add("CreationTime", creationTime()).add("DeploymentStatus", deploymentStatusAsString())
                .add("Description", description()).add("EngineType", engineTypeAsString()).add("EnvironmentId", environmentId())
                .add("LastStartTime", lastStartTime()).add("Name", name()).add("Status", statusAsString())
                .add("VersionStatus", versionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "applicationVersion":
            return Optional.ofNullable(clazz.cast(applicationVersion()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "deploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatusAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "engineType":
            return Optional.ofNullable(clazz.cast(engineTypeAsString()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "lastStartTime":
            return Optional.ofNullable(clazz.cast(lastStartTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "versionStatus":
            return Optional.ofNullable(clazz.cast(versionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSummary, T> g) {
        return obj -> g.apply((ApplicationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The unique identifier of the application.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The version of the application.
         * </p>
         * 
         * @param applicationVersion
         *        The version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersion(Integer applicationVersion);

        /**
         * <p>
         * The timestamp when the application was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when the application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Indicates either an ongoing deployment or if the application has ever deployed successfully.
         * </p>
         * 
         * @param deploymentStatus
         *        Indicates either an ongoing deployment or if the application has ever deployed successfully.
         * @see ApplicationDeploymentLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationDeploymentLifecycle
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * Indicates either an ongoing deployment or if the application has ever deployed successfully.
         * </p>
         * 
         * @param deploymentStatus
         *        Indicates either an ongoing deployment or if the application has ever deployed successfully.
         * @see ApplicationDeploymentLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationDeploymentLifecycle
         */
        Builder deploymentStatus(ApplicationDeploymentLifecycle deploymentStatus);

        /**
         * <p>
         * The description of the application.
         * </p>
         * 
         * @param description
         *        The description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the target platform for this application.
         * </p>
         * 
         * @param engineType
         *        The type of the target platform for this application.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(String engineType);

        /**
         * <p>
         * The type of the target platform for this application.
         * </p>
         * 
         * @param engineType
         *        The type of the target platform for this application.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(EngineType engineType);

        /**
         * <p>
         * The unique identifier of the runtime environment that hosts this application.
         * </p>
         * 
         * @param environmentId
         *        The unique identifier of the runtime environment that hosts this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The timestamp when you last started the application. Null until the application runs for the first time.
         * </p>
         * 
         * @param lastStartTime
         *        The timestamp when you last started the application. Null until the application runs for the first
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStartTime(Instant lastStartTime);

        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param name
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param status
         *        The status of the application.
         * @see ApplicationLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationLifecycle
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param status
         *        The status of the application.
         * @see ApplicationLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationLifecycle
         */
        Builder status(ApplicationLifecycle status);

        /**
         * <p>
         * Indicates the status of the latest version of the application.
         * </p>
         * 
         * @param versionStatus
         *        Indicates the status of the latest version of the application.
         * @see ApplicationVersionLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationVersionLifecycle
         */
        Builder versionStatus(String versionStatus);

        /**
         * <p>
         * Indicates the status of the latest version of the application.
         * </p>
         * 
         * @param versionStatus
         *        Indicates the status of the latest version of the application.
         * @see ApplicationVersionLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationVersionLifecycle
         */
        Builder versionStatus(ApplicationVersionLifecycle versionStatus);
    }

    static final class BuilderImpl implements Builder {
        private String applicationArn;

        private String applicationId;

        private Integer applicationVersion;

        private Instant creationTime;

        private String deploymentStatus;

        private String description;

        private String engineType;

        private String environmentId;

        private Instant lastStartTime;

        private String name;

        private String status;

        private String versionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            applicationArn(model.applicationArn);
            applicationId(model.applicationId);
            applicationVersion(model.applicationVersion);
            creationTime(model.creationTime);
            deploymentStatus(model.deploymentStatus);
            description(model.description);
            engineType(model.engineType);
            environmentId(model.environmentId);
            lastStartTime(model.lastStartTime);
            name(model.name);
            status(model.status);
            versionStatus(model.versionStatus);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Integer getApplicationVersion() {
            return applicationVersion;
        }

        public final void setApplicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        @Override
        public final Builder applicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(ApplicationDeploymentLifecycle deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngineType() {
            return engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Instant getLastStartTime() {
            return lastStartTime;
        }

        public final void setLastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
        }

        @Override
        public final Builder lastStartTime(Instant lastStartTime) {
            this.lastStartTime = lastStartTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVersionStatus() {
            return versionStatus;
        }

        public final void setVersionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
        }

        @Override
        public final Builder versionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
            return this;
        }

        @Override
        public final Builder versionStatus(ApplicationVersionLifecycle versionStatus) {
            this.versionStatus(versionStatus == null ? null : versionStatus.toString());
            return this;
        }

        @Override
        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
