/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An identifier for the StartBatchJob API to show that it is a restart operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestartBatchJobIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<RestartBatchJobIdentifier.Builder, RestartBatchJobIdentifier> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(RestartBatchJobIdentifier::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<JobStepRestartMarker> JOB_STEP_RESTART_MARKER_FIELD = SdkField
            .<JobStepRestartMarker> builder(MarshallingType.SDK_POJO).memberName("jobStepRestartMarker")
            .getter(getter(RestartBatchJobIdentifier::jobStepRestartMarker)).setter(setter(Builder::jobStepRestartMarker))
            .constructor(JobStepRestartMarker::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStepRestartMarker").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD,
            JOB_STEP_RESTART_MARKER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String executionId;

    private final JobStepRestartMarker jobStepRestartMarker;

    private RestartBatchJobIdentifier(BuilderImpl builder) {
        this.executionId = builder.executionId;
        this.jobStepRestartMarker = builder.jobStepRestartMarker;
    }

    /**
     * <p>
     * The executionId from the StartBatchJob response when the job ran for the first time.
     * </p>
     * 
     * @return The executionId from the StartBatchJob response when the job ran for the first time.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The restart step information for the most recent restart operation.
     * </p>
     * 
     * @return The restart step information for the most recent restart operation.
     */
    public final JobStepRestartMarker jobStepRestartMarker() {
        return jobStepRestartMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(jobStepRestartMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestartBatchJobIdentifier)) {
            return false;
        }
        RestartBatchJobIdentifier other = (RestartBatchJobIdentifier) obj;
        return Objects.equals(executionId(), other.executionId())
                && Objects.equals(jobStepRestartMarker(), other.jobStepRestartMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestartBatchJobIdentifier").add("ExecutionId", executionId())
                .add("JobStepRestartMarker", jobStepRestartMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "jobStepRestartMarker":
            return Optional.ofNullable(clazz.cast(jobStepRestartMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestartBatchJobIdentifier, T> g) {
        return obj -> g.apply((RestartBatchJobIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestartBatchJobIdentifier> {
        /**
         * <p>
         * The executionId from the StartBatchJob response when the job ran for the first time.
         * </p>
         * 
         * @param executionId
         *        The executionId from the StartBatchJob response when the job ran for the first time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The restart step information for the most recent restart operation.
         * </p>
         * 
         * @param jobStepRestartMarker
         *        The restart step information for the most recent restart operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobStepRestartMarker(JobStepRestartMarker jobStepRestartMarker);

        /**
         * <p>
         * The restart step information for the most recent restart operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobStepRestartMarker.Builder} avoiding
         * the need to create one manually via {@link JobStepRestartMarker#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobStepRestartMarker.Builder#build()} is called immediately and
         * its result is passed to {@link #jobStepRestartMarker(JobStepRestartMarker)}.
         * 
         * @param jobStepRestartMarker
         *        a consumer that will call methods on {@link JobStepRestartMarker.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobStepRestartMarker(JobStepRestartMarker)
         */
        default Builder jobStepRestartMarker(Consumer<JobStepRestartMarker.Builder> jobStepRestartMarker) {
            return jobStepRestartMarker(JobStepRestartMarker.builder().applyMutation(jobStepRestartMarker).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String executionId;

        private JobStepRestartMarker jobStepRestartMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(RestartBatchJobIdentifier model) {
            executionId(model.executionId);
            jobStepRestartMarker(model.jobStepRestartMarker);
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final JobStepRestartMarker.Builder getJobStepRestartMarker() {
            return jobStepRestartMarker != null ? jobStepRestartMarker.toBuilder() : null;
        }

        public final void setJobStepRestartMarker(JobStepRestartMarker.BuilderImpl jobStepRestartMarker) {
            this.jobStepRestartMarker = jobStepRestartMarker != null ? jobStepRestartMarker.build() : null;
        }

        @Override
        public final Builder jobStepRestartMarker(JobStepRestartMarker jobStepRestartMarker) {
            this.jobStepRestartMarker = jobStepRestartMarker;
            return this;
        }

        @Override
        public RestartBatchJobIdentifier build() {
            return new RestartBatchJobIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
