/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataSetImportHistoryResponse extends M2Response implements
        ToCopyableBuilder<ListDataSetImportHistoryResponse.Builder, ListDataSetImportHistoryResponse> {
    private static final SdkField<List<DataSetImportTask>> DATA_SET_IMPORT_TASKS_FIELD = SdkField
            .<List<DataSetImportTask>> builder(MarshallingType.LIST)
            .memberName("dataSetImportTasks")
            .getter(getter(ListDataSetImportHistoryResponse::dataSetImportTasks))
            .setter(setter(Builder::dataSetImportTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetImportTasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSetImportTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSetImportTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDataSetImportHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_IMPORT_TASKS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DataSetImportTask> dataSetImportTasks;

    private final String nextToken;

    private ListDataSetImportHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.dataSetImportTasks = builder.dataSetImportTasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSetImportTasks property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSetImportTasks() {
        return dataSetImportTasks != null && !(dataSetImportTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data set import tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSetImportTasks} method.
     * </p>
     * 
     * @return The data set import tasks.
     */
    public final List<DataSetImportTask> dataSetImportTasks() {
        return dataSetImportTasks;
    }

    /**
     * <p>
     * If there are more items to return, this contains a token that is passed to a subsequent call to this operation to
     * retrieve the next set of items.
     * </p>
     * 
     * @return If there are more items to return, this contains a token that is passed to a subsequent call to this
     *         operation to retrieve the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSetImportTasks() ? dataSetImportTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSetImportHistoryResponse)) {
            return false;
        }
        ListDataSetImportHistoryResponse other = (ListDataSetImportHistoryResponse) obj;
        return hasDataSetImportTasks() == other.hasDataSetImportTasks()
                && Objects.equals(dataSetImportTasks(), other.dataSetImportTasks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataSetImportHistoryResponse")
                .add("DataSetImportTasks", hasDataSetImportTasks() ? dataSetImportTasks() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSetImportTasks":
            return Optional.ofNullable(clazz.cast(dataSetImportTasks()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSetImportHistoryResponse, T> g) {
        return obj -> g.apply((ListDataSetImportHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends M2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListDataSetImportHistoryResponse> {
        /**
         * <p>
         * The data set import tasks.
         * </p>
         * 
         * @param dataSetImportTasks
         *        The data set import tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetImportTasks(Collection<DataSetImportTask> dataSetImportTasks);

        /**
         * <p>
         * The data set import tasks.
         * </p>
         * 
         * @param dataSetImportTasks
         *        The data set import tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetImportTasks(DataSetImportTask... dataSetImportTasks);

        /**
         * <p>
         * The data set import tasks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.m2.model.DataSetImportTask.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.m2.model.DataSetImportTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.m2.model.DataSetImportTask.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSetImportTasks(List<DataSetImportTask>)}.
         * 
         * @param dataSetImportTasks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.m2.model.DataSetImportTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSetImportTasks(java.util.Collection<DataSetImportTask>)
         */
        Builder dataSetImportTasks(Consumer<DataSetImportTask.Builder>... dataSetImportTasks);

        /**
         * <p>
         * If there are more items to return, this contains a token that is passed to a subsequent call to this
         * operation to retrieve the next set of items.
         * </p>
         * 
         * @param nextToken
         *        If there are more items to return, this contains a token that is passed to a subsequent call to this
         *        operation to retrieve the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends M2Response.BuilderImpl implements Builder {
        private List<DataSetImportTask> dataSetImportTasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSetImportHistoryResponse model) {
            super(model);
            dataSetImportTasks(model.dataSetImportTasks);
            nextToken(model.nextToken);
        }

        public final List<DataSetImportTask.Builder> getDataSetImportTasks() {
            List<DataSetImportTask.Builder> result = DataSetImportTaskListCopier.copyToBuilder(this.dataSetImportTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSetImportTasks(Collection<DataSetImportTask.BuilderImpl> dataSetImportTasks) {
            this.dataSetImportTasks = DataSetImportTaskListCopier.copyFromBuilder(dataSetImportTasks);
        }

        @Override
        public final Builder dataSetImportTasks(Collection<DataSetImportTask> dataSetImportTasks) {
            this.dataSetImportTasks = DataSetImportTaskListCopier.copy(dataSetImportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetImportTasks(DataSetImportTask... dataSetImportTasks) {
            dataSetImportTasks(Arrays.asList(dataSetImportTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetImportTasks(Consumer<DataSetImportTask.Builder>... dataSetImportTasks) {
            dataSetImportTasks(Stream.of(dataSetImportTasks).map(c -> DataSetImportTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataSetImportHistoryResponse build() {
            return new ListDataSetImportHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
