/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides step/procedure step information for a restart batch job operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobStepRestartMarker implements SdkPojo, Serializable,
        ToCopyableBuilder<JobStepRestartMarker.Builder, JobStepRestartMarker> {
    private static final SdkField<String> FROM_PROC_STEP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fromProcStep").getter(getter(JobStepRestartMarker::fromProcStep)).setter(setter(Builder::fromProcStep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromProcStep").build()).build();

    private static final SdkField<String> FROM_STEP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fromStep").getter(getter(JobStepRestartMarker::fromStep)).setter(setter(Builder::fromStep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromStep").build()).build();

    private static final SdkField<String> TO_PROC_STEP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toProcStep").getter(getter(JobStepRestartMarker::toProcStep)).setter(setter(Builder::toProcStep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toProcStep").build()).build();

    private static final SdkField<String> TO_STEP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("toStep")
            .getter(getter(JobStepRestartMarker::toStep)).setter(setter(Builder::toStep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toStep").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PROC_STEP_FIELD,
            FROM_STEP_FIELD, TO_PROC_STEP_FIELD, TO_STEP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fromProcStep;

    private final String fromStep;

    private final String toProcStep;

    private final String toStep;

    private JobStepRestartMarker(BuilderImpl builder) {
        this.fromProcStep = builder.fromProcStep;
        this.fromStep = builder.fromStep;
        this.toProcStep = builder.toProcStep;
        this.toStep = builder.toStep;
    }

    /**
     * <p>
     * The procedure step name that a batch job was restarted from.
     * </p>
     * 
     * @return The procedure step name that a batch job was restarted from.
     */
    public final String fromProcStep() {
        return fromProcStep;
    }

    /**
     * <p>
     * The step name that a batch job was restarted from.
     * </p>
     * 
     * @return The step name that a batch job was restarted from.
     */
    public final String fromStep() {
        return fromStep;
    }

    /**
     * <p>
     * The procedure step name that a batch job was restarted to.
     * </p>
     * 
     * @return The procedure step name that a batch job was restarted to.
     */
    public final String toProcStep() {
        return toProcStep;
    }

    /**
     * <p>
     * The step name that a batch job was restarted to.
     * </p>
     * 
     * @return The step name that a batch job was restarted to.
     */
    public final String toStep() {
        return toStep;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromProcStep());
        hashCode = 31 * hashCode + Objects.hashCode(fromStep());
        hashCode = 31 * hashCode + Objects.hashCode(toProcStep());
        hashCode = 31 * hashCode + Objects.hashCode(toStep());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobStepRestartMarker)) {
            return false;
        }
        JobStepRestartMarker other = (JobStepRestartMarker) obj;
        return Objects.equals(fromProcStep(), other.fromProcStep()) && Objects.equals(fromStep(), other.fromStep())
                && Objects.equals(toProcStep(), other.toProcStep()) && Objects.equals(toStep(), other.toStep());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobStepRestartMarker").add("FromProcStep", fromProcStep()).add("FromStep", fromStep())
                .add("ToProcStep", toProcStep()).add("ToStep", toStep()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fromProcStep":
            return Optional.ofNullable(clazz.cast(fromProcStep()));
        case "fromStep":
            return Optional.ofNullable(clazz.cast(fromStep()));
        case "toProcStep":
            return Optional.ofNullable(clazz.cast(toProcStep()));
        case "toStep":
            return Optional.ofNullable(clazz.cast(toStep()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobStepRestartMarker, T> g) {
        return obj -> g.apply((JobStepRestartMarker) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobStepRestartMarker> {
        /**
         * <p>
         * The procedure step name that a batch job was restarted from.
         * </p>
         * 
         * @param fromProcStep
         *        The procedure step name that a batch job was restarted from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromProcStep(String fromProcStep);

        /**
         * <p>
         * The step name that a batch job was restarted from.
         * </p>
         * 
         * @param fromStep
         *        The step name that a batch job was restarted from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromStep(String fromStep);

        /**
         * <p>
         * The procedure step name that a batch job was restarted to.
         * </p>
         * 
         * @param toProcStep
         *        The procedure step name that a batch job was restarted to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toProcStep(String toProcStep);

        /**
         * <p>
         * The step name that a batch job was restarted to.
         * </p>
         * 
         * @param toStep
         *        The step name that a batch job was restarted to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toStep(String toStep);
    }

    static final class BuilderImpl implements Builder {
        private String fromProcStep;

        private String fromStep;

        private String toProcStep;

        private String toStep;

        private BuilderImpl() {
        }

        private BuilderImpl(JobStepRestartMarker model) {
            fromProcStep(model.fromProcStep);
            fromStep(model.fromStep);
            toProcStep(model.toProcStep);
            toStep(model.toStep);
        }

        public final String getFromProcStep() {
            return fromProcStep;
        }

        public final void setFromProcStep(String fromProcStep) {
            this.fromProcStep = fromProcStep;
        }

        @Override
        public final Builder fromProcStep(String fromProcStep) {
            this.fromProcStep = fromProcStep;
            return this;
        }

        public final String getFromStep() {
            return fromStep;
        }

        public final void setFromStep(String fromStep) {
            this.fromStep = fromStep;
        }

        @Override
        public final Builder fromStep(String fromStep) {
            this.fromStep = fromStep;
            return this;
        }

        public final String getToProcStep() {
            return toProcStep;
        }

        public final void setToProcStep(String toProcStep) {
            this.toProcStep = toProcStep;
        }

        @Override
        public final Builder toProcStep(String toProcStep) {
            this.toProcStep = toProcStep;
            return this;
        }

        public final String getToStep() {
            return toStep;
        }

        public final void setToStep(String toStep) {
            this.toStep = toStep;
        }

        @Override
        public final Builder toStep(String toStep) {
            this.toStep = toStep;
            return this;
        }

        @Override
        public JobStepRestartMarker build() {
            return new JobStepRestartMarker(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
