/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.m2.model.M2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentRequest
extends M2Request
implements ToCopyableBuilder<Builder, CreateDeploymentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::applicationId)).setter(CreateDeploymentRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<Integer> APPLICATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("applicationVersion").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::applicationVersion)).setter(CreateDeploymentRequest.setter(Builder::applicationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::clientToken)).setter(CreateDeploymentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::environmentId)).setter(CreateDeploymentRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, APPLICATION_VERSION_FIELD, CLIENT_TOKEN_FIELD, ENVIRONMENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("applicationVersion", APPLICATION_VERSION_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("environmentId", ENVIRONMENT_ID_FIELD);
        }
    });
    private final String applicationId;
    private final Integer applicationVersion;
    private final String clientToken;
    private final String environmentId;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.applicationVersion = builder.applicationVersion;
        this.clientToken = builder.clientToken;
        this.environmentId = builder.environmentId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final Integer applicationVersion() {
        return this.applicationVersion;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.applicationVersion(), other.applicationVersion()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.environmentId(), other.environmentId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeploymentRequest").add("ApplicationId", (Object)this.applicationId()).add("ApplicationVersion", (Object)this.applicationVersion()).add("ClientToken", (Object)this.clientToken()).add("EnvironmentId", (Object)this.environmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "applicationVersion": {
                return Optional.ofNullable(clazz.cast(this.applicationVersion()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentRequest, T> g) {
        return obj -> g.apply((CreateDeploymentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Request.BuilderImpl
    implements Builder {
        private String applicationId;
        private Integer applicationVersion;
        private String clientToken;
        private String environmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.applicationVersion(model.applicationVersion);
            this.clientToken(model.clientToken);
            this.environmentId(model.environmentId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Integer getApplicationVersion() {
            return this.applicationVersion;
        }

        public final void setApplicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        @Override
        public final Builder applicationVersion(Integer applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends M2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentRequest> {
        public Builder applicationId(String var1);

        public Builder applicationVersion(Integer var1);

        public Builder clientToken(String var1);

        public Builder environmentId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

