/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the details of a batch job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchJobDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchJobDefinition.Builder, BatchJobDefinition> {
    private static final SdkField<FileBatchJobDefinition> FILE_BATCH_JOB_DEFINITION_FIELD = SdkField
            .<FileBatchJobDefinition> builder(MarshallingType.SDK_POJO).memberName("fileBatchJobDefinition")
            .getter(getter(BatchJobDefinition::fileBatchJobDefinition)).setter(setter(Builder::fileBatchJobDefinition))
            .constructor(FileBatchJobDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileBatchJobDefinition").build())
            .build();

    private static final SdkField<ScriptBatchJobDefinition> SCRIPT_BATCH_JOB_DEFINITION_FIELD = SdkField
            .<ScriptBatchJobDefinition> builder(MarshallingType.SDK_POJO).memberName("scriptBatchJobDefinition")
            .getter(getter(BatchJobDefinition::scriptBatchJobDefinition)).setter(setter(Builder::scriptBatchJobDefinition))
            .constructor(ScriptBatchJobDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptBatchJobDefinition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FILE_BATCH_JOB_DEFINITION_FIELD, SCRIPT_BATCH_JOB_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FileBatchJobDefinition fileBatchJobDefinition;

    private final ScriptBatchJobDefinition scriptBatchJobDefinition;

    private final Type type;

    private BatchJobDefinition(BuilderImpl builder) {
        this.fileBatchJobDefinition = builder.fileBatchJobDefinition;
        this.scriptBatchJobDefinition = builder.scriptBatchJobDefinition;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies a file containing a batch job definition.
     * </p>
     * 
     * @return Specifies a file containing a batch job definition.
     */
    public final FileBatchJobDefinition fileBatchJobDefinition() {
        return fileBatchJobDefinition;
    }

    /**
     * <p>
     * A script containing a batch job definition.
     * </p>
     * 
     * @return A script containing a batch job definition.
     */
    public final ScriptBatchJobDefinition scriptBatchJobDefinition() {
        return scriptBatchJobDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileBatchJobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(scriptBatchJobDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchJobDefinition)) {
            return false;
        }
        BatchJobDefinition other = (BatchJobDefinition) obj;
        return Objects.equals(fileBatchJobDefinition(), other.fileBatchJobDefinition())
                && Objects.equals(scriptBatchJobDefinition(), other.scriptBatchJobDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchJobDefinition").add("FileBatchJobDefinition", fileBatchJobDefinition())
                .add("ScriptBatchJobDefinition", scriptBatchJobDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileBatchJobDefinition":
            return Optional.ofNullable(clazz.cast(fileBatchJobDefinition()));
        case "scriptBatchJobDefinition":
            return Optional.ofNullable(clazz.cast(scriptBatchJobDefinition()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #fileBatchJobDefinition()} initialized to the given value.
     *
     * <p>
     * Specifies a file containing a batch job definition.
     * </p>
     * 
     * @param fileBatchJobDefinition
     *        Specifies a file containing a batch job definition.
     */
    public static BatchJobDefinition fromFileBatchJobDefinition(FileBatchJobDefinition fileBatchJobDefinition) {
        return builder().fileBatchJobDefinition(fileBatchJobDefinition).build();
    }

    /**
     * Create an instance of this class with {@link #fileBatchJobDefinition()} initialized to the given value.
     *
     * <p>
     * Specifies a file containing a batch job definition.
     * </p>
     * 
     * @param fileBatchJobDefinition
     *        Specifies a file containing a batch job definition.
     */
    public static BatchJobDefinition fromFileBatchJobDefinition(Consumer<FileBatchJobDefinition.Builder> fileBatchJobDefinition) {
        FileBatchJobDefinition.Builder builder = FileBatchJobDefinition.builder();
        fileBatchJobDefinition.accept(builder);
        return fromFileBatchJobDefinition(builder.build());
    }

    /**
     * Create an instance of this class with {@link #scriptBatchJobDefinition()} initialized to the given value.
     *
     * <p>
     * A script containing a batch job definition.
     * </p>
     * 
     * @param scriptBatchJobDefinition
     *        A script containing a batch job definition.
     */
    public static BatchJobDefinition fromScriptBatchJobDefinition(ScriptBatchJobDefinition scriptBatchJobDefinition) {
        return builder().scriptBatchJobDefinition(scriptBatchJobDefinition).build();
    }

    /**
     * Create an instance of this class with {@link #scriptBatchJobDefinition()} initialized to the given value.
     *
     * <p>
     * A script containing a batch job definition.
     * </p>
     * 
     * @param scriptBatchJobDefinition
     *        A script containing a batch job definition.
     */
    public static BatchJobDefinition fromScriptBatchJobDefinition(
            Consumer<ScriptBatchJobDefinition.Builder> scriptBatchJobDefinition) {
        ScriptBatchJobDefinition.Builder builder = ScriptBatchJobDefinition.builder();
        scriptBatchJobDefinition.accept(builder);
        return fromScriptBatchJobDefinition(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fileBatchJobDefinition", FILE_BATCH_JOB_DEFINITION_FIELD);
        map.put("scriptBatchJobDefinition", SCRIPT_BATCH_JOB_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchJobDefinition, T> g) {
        return obj -> g.apply((BatchJobDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchJobDefinition> {
        /**
         * <p>
         * Specifies a file containing a batch job definition.
         * </p>
         * 
         * @param fileBatchJobDefinition
         *        Specifies a file containing a batch job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileBatchJobDefinition(FileBatchJobDefinition fileBatchJobDefinition);

        /**
         * <p>
         * Specifies a file containing a batch job definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileBatchJobDefinition.Builder} avoiding
         * the need to create one manually via {@link FileBatchJobDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileBatchJobDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #fileBatchJobDefinition(FileBatchJobDefinition)}.
         * 
         * @param fileBatchJobDefinition
         *        a consumer that will call methods on {@link FileBatchJobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileBatchJobDefinition(FileBatchJobDefinition)
         */
        default Builder fileBatchJobDefinition(Consumer<FileBatchJobDefinition.Builder> fileBatchJobDefinition) {
            return fileBatchJobDefinition(FileBatchJobDefinition.builder().applyMutation(fileBatchJobDefinition).build());
        }

        /**
         * <p>
         * A script containing a batch job definition.
         * </p>
         * 
         * @param scriptBatchJobDefinition
         *        A script containing a batch job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptBatchJobDefinition(ScriptBatchJobDefinition scriptBatchJobDefinition);

        /**
         * <p>
         * A script containing a batch job definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScriptBatchJobDefinition.Builder}
         * avoiding the need to create one manually via {@link ScriptBatchJobDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScriptBatchJobDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #scriptBatchJobDefinition(ScriptBatchJobDefinition)}.
         * 
         * @param scriptBatchJobDefinition
         *        a consumer that will call methods on {@link ScriptBatchJobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scriptBatchJobDefinition(ScriptBatchJobDefinition)
         */
        default Builder scriptBatchJobDefinition(Consumer<ScriptBatchJobDefinition.Builder> scriptBatchJobDefinition) {
            return scriptBatchJobDefinition(ScriptBatchJobDefinition.builder().applyMutation(scriptBatchJobDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FileBatchJobDefinition fileBatchJobDefinition;

        private ScriptBatchJobDefinition scriptBatchJobDefinition;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(BatchJobDefinition model) {
            fileBatchJobDefinition(model.fileBatchJobDefinition);
            scriptBatchJobDefinition(model.scriptBatchJobDefinition);
        }

        public final FileBatchJobDefinition.Builder getFileBatchJobDefinition() {
            return fileBatchJobDefinition != null ? fileBatchJobDefinition.toBuilder() : null;
        }

        public final void setFileBatchJobDefinition(FileBatchJobDefinition.BuilderImpl fileBatchJobDefinition) {
            Object oldValue = this.fileBatchJobDefinition;
            this.fileBatchJobDefinition = fileBatchJobDefinition != null ? fileBatchJobDefinition.build() : null;
            handleUnionValueChange(Type.FILE_BATCH_JOB_DEFINITION, oldValue, this.fileBatchJobDefinition);
        }

        @Override
        public final Builder fileBatchJobDefinition(FileBatchJobDefinition fileBatchJobDefinition) {
            Object oldValue = this.fileBatchJobDefinition;
            this.fileBatchJobDefinition = fileBatchJobDefinition;
            handleUnionValueChange(Type.FILE_BATCH_JOB_DEFINITION, oldValue, this.fileBatchJobDefinition);
            return this;
        }

        public final ScriptBatchJobDefinition.Builder getScriptBatchJobDefinition() {
            return scriptBatchJobDefinition != null ? scriptBatchJobDefinition.toBuilder() : null;
        }

        public final void setScriptBatchJobDefinition(ScriptBatchJobDefinition.BuilderImpl scriptBatchJobDefinition) {
            Object oldValue = this.scriptBatchJobDefinition;
            this.scriptBatchJobDefinition = scriptBatchJobDefinition != null ? scriptBatchJobDefinition.build() : null;
            handleUnionValueChange(Type.SCRIPT_BATCH_JOB_DEFINITION, oldValue, this.scriptBatchJobDefinition);
        }

        @Override
        public final Builder scriptBatchJobDefinition(ScriptBatchJobDefinition scriptBatchJobDefinition) {
            Object oldValue = this.scriptBatchJobDefinition;
            this.scriptBatchJobDefinition = scriptBatchJobDefinition;
            handleUnionValueChange(Type.SCRIPT_BATCH_JOB_DEFINITION, oldValue, this.scriptBatchJobDefinition);
            return this;
        }

        @Override
        public BatchJobDefinition build() {
            return new BatchJobDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see BatchJobDefinition#type()
     */
    public enum Type {
        FILE_BATCH_JOB_DEFINITION,

        SCRIPT_BATCH_JOB_DEFINITION,

        UNKNOWN_TO_SDK_VERSION
    }
}
