/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a data set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSet implements SdkPojo, Serializable, ToCopyableBuilder<DataSet.Builder, DataSet> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetName").getter(getter(DataSet::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetName").build()).build();

    private static final SdkField<DatasetOrgAttributes> DATASET_ORG_FIELD = SdkField
            .<DatasetOrgAttributes> builder(MarshallingType.SDK_POJO).memberName("datasetOrg")
            .getter(getter(DataSet::datasetOrg)).setter(setter(Builder::datasetOrg)).constructor(DatasetOrgAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetOrg").build()).build();

    private static final SdkField<RecordLength> RECORD_LENGTH_FIELD = SdkField.<RecordLength> builder(MarshallingType.SDK_POJO)
            .memberName("recordLength").getter(getter(DataSet::recordLength)).setter(setter(Builder::recordLength))
            .constructor(RecordLength::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordLength").build()).build();

    private static final SdkField<String> RELATIVE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relativePath").getter(getter(DataSet::relativePath)).setter(setter(Builder::relativePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relativePath").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageType").getter(getter(DataSet::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            DATASET_ORG_FIELD, RECORD_LENGTH_FIELD, RELATIVE_PATH_FIELD, STORAGE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String datasetName;

    private final DatasetOrgAttributes datasetOrg;

    private final RecordLength recordLength;

    private final String relativePath;

    private final String storageType;

    private DataSet(BuilderImpl builder) {
        this.datasetName = builder.datasetName;
        this.datasetOrg = builder.datasetOrg;
        this.recordLength = builder.recordLength;
        this.relativePath = builder.relativePath;
        this.storageType = builder.storageType;
    }

    /**
     * <p>
     * The logical identifier for a specific data set (in mainframe format).
     * </p>
     * 
     * @return The logical identifier for a specific data set (in mainframe format).
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The type of dataset. The only supported value is VSAM.
     * </p>
     * 
     * @return The type of dataset. The only supported value is VSAM.
     */
    public final DatasetOrgAttributes datasetOrg() {
        return datasetOrg;
    }

    /**
     * <p>
     * The length of a record.
     * </p>
     * 
     * @return The length of a record.
     */
    public final RecordLength recordLength() {
        return recordLength;
    }

    /**
     * <p>
     * The relative location of the data set in the database or file system.
     * </p>
     * 
     * @return The relative location of the data set in the database or file system.
     */
    public final String relativePath() {
        return relativePath;
    }

    /**
     * <p>
     * The storage type of the data set: database or file system. For Micro Focus, database corresponds to datastore and
     * file system corresponds to EFS/FSX. For Blu Age, there is no support of file system and database corresponds to
     * Blusam.
     * </p>
     * 
     * @return The storage type of the data set: database or file system. For Micro Focus, database corresponds to
     *         datastore and file system corresponds to EFS/FSX. For Blu Age, there is no support of file system and
     *         database corresponds to Blusam.
     */
    public final String storageType() {
        return storageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetOrg());
        hashCode = 31 * hashCode + Objects.hashCode(recordLength());
        hashCode = 31 * hashCode + Objects.hashCode(relativePath());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        DataSet other = (DataSet) obj;
        return Objects.equals(datasetName(), other.datasetName()) && Objects.equals(datasetOrg(), other.datasetOrg())
                && Objects.equals(recordLength(), other.recordLength()) && Objects.equals(relativePath(), other.relativePath())
                && Objects.equals(storageType(), other.storageType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSet").add("DatasetName", datasetName()).add("DatasetOrg", datasetOrg())
                .add("RecordLength", recordLength()).add("RelativePath", relativePath()).add("StorageType", storageType())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "datasetOrg":
            return Optional.ofNullable(clazz.cast(datasetOrg()));
        case "recordLength":
            return Optional.ofNullable(clazz.cast(recordLength()));
        case "relativePath":
            return Optional.ofNullable(clazz.cast(relativePath()));
        case "storageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datasetName", DATASET_NAME_FIELD);
        map.put("datasetOrg", DATASET_ORG_FIELD);
        map.put("recordLength", RECORD_LENGTH_FIELD);
        map.put("relativePath", RELATIVE_PATH_FIELD);
        map.put("storageType", STORAGE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSet, T> g) {
        return obj -> g.apply((DataSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSet> {
        /**
         * <p>
         * The logical identifier for a specific data set (in mainframe format).
         * </p>
         * 
         * @param datasetName
         *        The logical identifier for a specific data set (in mainframe format).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The type of dataset. The only supported value is VSAM.
         * </p>
         * 
         * @param datasetOrg
         *        The type of dataset. The only supported value is VSAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetOrg(DatasetOrgAttributes datasetOrg);

        /**
         * <p>
         * The type of dataset. The only supported value is VSAM.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetOrgAttributes.Builder} avoiding
         * the need to create one manually via {@link DatasetOrgAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetOrgAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #datasetOrg(DatasetOrgAttributes)}.
         * 
         * @param datasetOrg
         *        a consumer that will call methods on {@link DatasetOrgAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetOrg(DatasetOrgAttributes)
         */
        default Builder datasetOrg(Consumer<DatasetOrgAttributes.Builder> datasetOrg) {
            return datasetOrg(DatasetOrgAttributes.builder().applyMutation(datasetOrg).build());
        }

        /**
         * <p>
         * The length of a record.
         * </p>
         * 
         * @param recordLength
         *        The length of a record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordLength(RecordLength recordLength);

        /**
         * <p>
         * The length of a record.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecordLength.Builder} avoiding the need
         * to create one manually via {@link RecordLength#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecordLength.Builder#build()} is called immediately and its
         * result is passed to {@link #recordLength(RecordLength)}.
         * 
         * @param recordLength
         *        a consumer that will call methods on {@link RecordLength.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordLength(RecordLength)
         */
        default Builder recordLength(Consumer<RecordLength.Builder> recordLength) {
            return recordLength(RecordLength.builder().applyMutation(recordLength).build());
        }

        /**
         * <p>
         * The relative location of the data set in the database or file system.
         * </p>
         * 
         * @param relativePath
         *        The relative location of the data set in the database or file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relativePath(String relativePath);

        /**
         * <p>
         * The storage type of the data set: database or file system. For Micro Focus, database corresponds to datastore
         * and file system corresponds to EFS/FSX. For Blu Age, there is no support of file system and database
         * corresponds to Blusam.
         * </p>
         * 
         * @param storageType
         *        The storage type of the data set: database or file system. For Micro Focus, database corresponds to
         *        datastore and file system corresponds to EFS/FSX. For Blu Age, there is no support of file system and
         *        database corresponds to Blusam.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);
    }

    static final class BuilderImpl implements Builder {
        private String datasetName;

        private DatasetOrgAttributes datasetOrg;

        private RecordLength recordLength;

        private String relativePath;

        private String storageType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSet model) {
            datasetName(model.datasetName);
            datasetOrg(model.datasetOrg);
            recordLength(model.recordLength);
            relativePath(model.relativePath);
            storageType(model.storageType);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final DatasetOrgAttributes.Builder getDatasetOrg() {
            return datasetOrg != null ? datasetOrg.toBuilder() : null;
        }

        public final void setDatasetOrg(DatasetOrgAttributes.BuilderImpl datasetOrg) {
            this.datasetOrg = datasetOrg != null ? datasetOrg.build() : null;
        }

        @Override
        public final Builder datasetOrg(DatasetOrgAttributes datasetOrg) {
            this.datasetOrg = datasetOrg;
            return this;
        }

        public final RecordLength.Builder getRecordLength() {
            return recordLength != null ? recordLength.toBuilder() : null;
        }

        public final void setRecordLength(RecordLength.BuilderImpl recordLength) {
            this.recordLength = recordLength != null ? recordLength.build() : null;
        }

        @Override
        public final Builder recordLength(RecordLength recordLength) {
            this.recordLength = recordLength;
            return this;
        }

        public final String getRelativePath() {
            return relativePath;
        }

        public final void setRelativePath(String relativePath) {
            this.relativePath = relativePath;
        }

        @Override
        public final Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public DataSet build() {
            return new DataSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
