/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the storage configuration for an Amazon FSx file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FsxStorageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FsxStorageConfiguration.Builder, FsxStorageConfiguration> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileSystemId").getter(getter(FsxStorageConfiguration::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file-system-id").build()).build();

    private static final SdkField<String> MOUNT_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mountPoint").getter(getter(FsxStorageConfiguration::mountPoint)).setter(setter(Builder::mountPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mount-point").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            MOUNT_POINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileSystemId;

    private final String mountPoint;

    private FsxStorageConfiguration(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.mountPoint = builder.mountPoint;
    }

    /**
     * <p>
     * The file system identifier.
     * </p>
     * 
     * @return The file system identifier.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The mount point for the file system.
     * </p>
     * 
     * @return The mount point for the file system.
     */
    public final String mountPoint() {
        return mountPoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(mountPoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FsxStorageConfiguration)) {
            return false;
        }
        FsxStorageConfiguration other = (FsxStorageConfiguration) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(mountPoint(), other.mountPoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FsxStorageConfiguration").add("FileSystemId", fileSystemId()).add("MountPoint", mountPoint())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "mountPoint":
            return Optional.ofNullable(clazz.cast(mountPoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("file-system-id", FILE_SYSTEM_ID_FIELD);
        map.put("mount-point", MOUNT_POINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FsxStorageConfiguration, T> g) {
        return obj -> g.apply((FsxStorageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FsxStorageConfiguration> {
        /**
         * <p>
         * The file system identifier.
         * </p>
         * 
         * @param fileSystemId
         *        The file system identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The mount point for the file system.
         * </p>
         * 
         * @param mountPoint
         *        The mount point for the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoint(String mountPoint);
    }

    static final class BuilderImpl implements Builder {
        private String fileSystemId;

        private String mountPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(FsxStorageConfiguration model) {
            fileSystemId(model.fileSystemId);
            mountPoint(model.mountPoint);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getMountPoint() {
            return mountPoint;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        @Override
        public FsxStorageConfiguration build() {
            return new FsxStorageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
