/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationVersionsResponse extends M2Response implements
        ToCopyableBuilder<ListApplicationVersionsResponse.Builder, ListApplicationVersionsResponse> {
    private static final SdkField<List<ApplicationVersionSummary>> APPLICATION_VERSIONS_FIELD = SdkField
            .<List<ApplicationVersionSummary>> builder(MarshallingType.LIST)
            .memberName("applicationVersions")
            .getter(getter(ListApplicationVersionsResponse::applicationVersions))
            .setter(setter(Builder::applicationVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListApplicationVersionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ApplicationVersionSummary> applicationVersions;

    private final String nextToken;

    private ListApplicationVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationVersions = builder.applicationVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationVersions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicationVersions() {
        return applicationVersions != null && !(applicationVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of application versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationVersions} method.
     * </p>
     * 
     * @return The list of application versions.
     */
    public final List<ApplicationVersionSummary> applicationVersions() {
        return applicationVersions;
    }

    /**
     * <p>
     * If there are more items to return, this contains a token that is passed to a subsequent call to this operation to
     * retrieve the next set of items.
     * </p>
     * 
     * @return If there are more items to return, this contains a token that is passed to a subsequent call to this
     *         operation to retrieve the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationVersions() ? applicationVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationVersionsResponse)) {
            return false;
        }
        ListApplicationVersionsResponse other = (ListApplicationVersionsResponse) obj;
        return hasApplicationVersions() == other.hasApplicationVersions()
                && Objects.equals(applicationVersions(), other.applicationVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationVersionsResponse")
                .add("ApplicationVersions", hasApplicationVersions() ? applicationVersions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationVersions":
            return Optional.ofNullable(clazz.cast(applicationVersions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationVersions", APPLICATION_VERSIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationVersionsResponse, T> g) {
        return obj -> g.apply((ListApplicationVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends M2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListApplicationVersionsResponse> {
        /**
         * <p>
         * The list of application versions.
         * </p>
         * 
         * @param applicationVersions
         *        The list of application versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersions(Collection<ApplicationVersionSummary> applicationVersions);

        /**
         * <p>
         * The list of application versions.
         * </p>
         * 
         * @param applicationVersions
         *        The list of application versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersions(ApplicationVersionSummary... applicationVersions);

        /**
         * <p>
         * The list of application versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.m2.model.ApplicationVersionSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.m2.model.ApplicationVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.m2.model.ApplicationVersionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #applicationVersions(List<ApplicationVersionSummary>)}.
         * 
         * @param applicationVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.m2.model.ApplicationVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationVersions(java.util.Collection<ApplicationVersionSummary>)
         */
        Builder applicationVersions(Consumer<ApplicationVersionSummary.Builder>... applicationVersions);

        /**
         * <p>
         * If there are more items to return, this contains a token that is passed to a subsequent call to this
         * operation to retrieve the next set of items.
         * </p>
         * 
         * @param nextToken
         *        If there are more items to return, this contains a token that is passed to a subsequent call to this
         *        operation to retrieve the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends M2Response.BuilderImpl implements Builder {
        private List<ApplicationVersionSummary> applicationVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationVersionsResponse model) {
            super(model);
            applicationVersions(model.applicationVersions);
            nextToken(model.nextToken);
        }

        public final List<ApplicationVersionSummary.Builder> getApplicationVersions() {
            List<ApplicationVersionSummary.Builder> result = ApplicationVersionSummaryListCopier
                    .copyToBuilder(this.applicationVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationVersions(Collection<ApplicationVersionSummary.BuilderImpl> applicationVersions) {
            this.applicationVersions = ApplicationVersionSummaryListCopier.copyFromBuilder(applicationVersions);
        }

        @Override
        public final Builder applicationVersions(Collection<ApplicationVersionSummary> applicationVersions) {
            this.applicationVersions = ApplicationVersionSummaryListCopier.copy(applicationVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationVersions(ApplicationVersionSummary... applicationVersions) {
            applicationVersions(Arrays.asList(applicationVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationVersions(Consumer<ApplicationVersionSummary.Builder>... applicationVersions) {
            applicationVersions(Stream.of(applicationVersions)
                    .map(c -> ApplicationVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationVersionsResponse build() {
            return new ListApplicationVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
