/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSetImportTaskRequest extends M2Request implements
        ToCopyableBuilder<CreateDataSetImportTaskRequest.Builder, CreateDataSetImportTaskRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(CreateDataSetImportTaskRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateDataSetImportTaskRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<DataSetImportConfig> IMPORT_CONFIG_FIELD = SdkField
            .<DataSetImportConfig> builder(MarshallingType.SDK_POJO).memberName("importConfig")
            .getter(getter(CreateDataSetImportTaskRequest::importConfig)).setter(setter(Builder::importConfig))
            .constructor(DataSetImportConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CLIENT_TOKEN_FIELD, IMPORT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String clientToken;

    private final DataSetImportConfig importConfig;

    private CreateDataSetImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.clientToken = builder.clientToken;
        this.importConfig = builder.importConfig;
    }

    /**
     * <p>
     * The unique identifier of the application for which you want to import data sets.
     * </p>
     * 
     * @return The unique identifier of the application for which you want to import data sets.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create a data set
     * import. The service generates the clientToken when the API call is triggered. The token expires after one hour,
     * so if you retry the API within this timeframe with the same clientToken, you will get the same response. The
     * service also handles deleting the clientToken after it expires.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create a data
     *         set import. The service generates the clientToken when the API call is triggered. The token expires after
     *         one hour, so if you retry the API within this timeframe with the same clientToken, you will get the same
     *         response. The service also handles deleting the clientToken after it expires.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The data set import task configuration.
     * </p>
     * 
     * @return The data set import task configuration.
     */
    public final DataSetImportConfig importConfig() {
        return importConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(importConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSetImportTaskRequest)) {
            return false;
        }
        CreateDataSetImportTaskRequest other = (CreateDataSetImportTaskRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(importConfig(), other.importConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataSetImportTaskRequest").add("ApplicationId", applicationId())
                .add("ClientToken", clientToken()).add("ImportConfig", importConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "importConfig":
            return Optional.ofNullable(clazz.cast(importConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("importConfig", IMPORT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSetImportTaskRequest, T> g) {
        return obj -> g.apply((CreateDataSetImportTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends M2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataSetImportTaskRequest> {
        /**
         * <p>
         * The unique identifier of the application for which you want to import data sets.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the application for which you want to import data sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create a data set
         * import. The service generates the clientToken when the API call is triggered. The token expires after one
         * hour, so if you retry the API within this timeframe with the same clientToken, you will get the same
         * response. The service also handles deleting the clientToken after it expires.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create a
         *        data set import. The service generates the clientToken when the API call is triggered. The token
         *        expires after one hour, so if you retry the API within this timeframe with the same clientToken, you
         *        will get the same response. The service also handles deleting the clientToken after it expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The data set import task configuration.
         * </p>
         * 
         * @param importConfig
         *        The data set import task configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importConfig(DataSetImportConfig importConfig);

        /**
         * <p>
         * The data set import task configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetImportConfig.Builder} avoiding the
         * need to create one manually via {@link DataSetImportConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetImportConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #importConfig(DataSetImportConfig)}.
         * 
         * @param importConfig
         *        a consumer that will call methods on {@link DataSetImportConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importConfig(DataSetImportConfig)
         */
        default Builder importConfig(Consumer<DataSetImportConfig.Builder> importConfig) {
            return importConfig(DataSetImportConfig.builder().applyMutation(importConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends M2Request.BuilderImpl implements Builder {
        private String applicationId;

        private String clientToken;

        private DataSetImportConfig importConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSetImportTaskRequest model) {
            super(model);
            applicationId(model.applicationId);
            clientToken(model.clientToken);
            importConfig(model.importConfig);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DataSetImportConfig.Builder getImportConfig() {
            return importConfig != null ? importConfig.toBuilder() : null;
        }

        public final void setImportConfig(DataSetImportConfig.BuilderImpl importConfig) {
            this.importConfig = importConfig != null ? importConfig.build() : null;
        }

        @Override
        public final Builder importConfig(DataSetImportConfig importConfig) {
            this.importConfig = importConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSetImportTaskRequest build() {
            return new CreateDataSetImportTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
