/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A subset of the possible data set attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetSummary implements SdkPojo, Serializable, ToCopyableBuilder<DataSetSummary.Builder, DataSetSummary> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(DataSetSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> DATA_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSetName").getter(getter(DataSetSummary::dataSetName)).setter(setter(Builder::dataSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetName").build()).build();

    private static final SdkField<String> DATA_SET_ORG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSetOrg").getter(getter(DataSetSummary::dataSetOrg)).setter(setter(Builder::dataSetOrg))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetOrg").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(DataSetSummary::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<Instant> LAST_REFERENCED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastReferencedTime").getter(getter(DataSetSummary::lastReferencedTime))
            .setter(setter(Builder::lastReferencedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastReferencedTime").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTime").getter(getter(DataSetSummary::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            DATA_SET_NAME_FIELD, DATA_SET_ORG_FIELD, FORMAT_FIELD, LAST_REFERENCED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String dataSetName;

    private final String dataSetOrg;

    private final String format;

    private final Instant lastReferencedTime;

    private final Instant lastUpdatedTime;

    private DataSetSummary(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.dataSetName = builder.dataSetName;
        this.dataSetOrg = builder.dataSetOrg;
        this.format = builder.format;
        this.lastReferencedTime = builder.lastReferencedTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The timestamp when the data set was created.
     * </p>
     * 
     * @return The timestamp when the data set was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The name of the data set.
     * </p>
     * 
     * @return The name of the data set.
     */
    public final String dataSetName() {
        return dataSetName;
    }

    /**
     * <p>
     * The type of data set. The only supported value is VSAM.
     * </p>
     * 
     * @return The type of data set. The only supported value is VSAM.
     */
    public final String dataSetOrg() {
        return dataSetOrg;
    }

    /**
     * <p>
     * The format of the data set.
     * </p>
     * 
     * @return The format of the data set.
     */
    public final String format() {
        return format;
    }

    /**
     * <p>
     * The last time the data set was referenced.
     * </p>
     * 
     * @return The last time the data set was referenced.
     */
    public final Instant lastReferencedTime() {
        return lastReferencedTime;
    }

    /**
     * <p>
     * The last time the data set was updated.
     * </p>
     * 
     * @return The last time the data set was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetName());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetOrg());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(lastReferencedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetSummary)) {
            return false;
        }
        DataSetSummary other = (DataSetSummary) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(dataSetName(), other.dataSetName())
                && Objects.equals(dataSetOrg(), other.dataSetOrg()) && Objects.equals(format(), other.format())
                && Objects.equals(lastReferencedTime(), other.lastReferencedTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetSummary").add("CreationTime", creationTime()).add("DataSetName", dataSetName())
                .add("DataSetOrg", dataSetOrg()).add("Format", format()).add("LastReferencedTime", lastReferencedTime())
                .add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "dataSetName":
            return Optional.ofNullable(clazz.cast(dataSetName()));
        case "dataSetOrg":
            return Optional.ofNullable(clazz.cast(dataSetOrg()));
        case "format":
            return Optional.ofNullable(clazz.cast(format()));
        case "lastReferencedTime":
            return Optional.ofNullable(clazz.cast(lastReferencedTime()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("dataSetName", DATA_SET_NAME_FIELD);
        map.put("dataSetOrg", DATA_SET_ORG_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("lastReferencedTime", LAST_REFERENCED_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetSummary, T> g) {
        return obj -> g.apply((DataSetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetSummary> {
        /**
         * <p>
         * The timestamp when the data set was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when the data set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The name of the data set.
         * </p>
         * 
         * @param dataSetName
         *        The name of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetName(String dataSetName);

        /**
         * <p>
         * The type of data set. The only supported value is VSAM.
         * </p>
         * 
         * @param dataSetOrg
         *        The type of data set. The only supported value is VSAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetOrg(String dataSetOrg);

        /**
         * <p>
         * The format of the data set.
         * </p>
         * 
         * @param format
         *        The format of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The last time the data set was referenced.
         * </p>
         * 
         * @param lastReferencedTime
         *        The last time the data set was referenced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastReferencedTime(Instant lastReferencedTime);

        /**
         * <p>
         * The last time the data set was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last time the data set was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String dataSetName;

        private String dataSetOrg;

        private String format;

        private Instant lastReferencedTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetSummary model) {
            creationTime(model.creationTime);
            dataSetName(model.dataSetName);
            dataSetOrg(model.dataSetOrg);
            format(model.format);
            lastReferencedTime(model.lastReferencedTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDataSetName() {
            return dataSetName;
        }

        public final void setDataSetName(String dataSetName) {
            this.dataSetName = dataSetName;
        }

        @Override
        public final Builder dataSetName(String dataSetName) {
            this.dataSetName = dataSetName;
            return this;
        }

        public final String getDataSetOrg() {
            return dataSetOrg;
        }

        public final void setDataSetOrg(String dataSetOrg) {
            this.dataSetOrg = dataSetOrg;
        }

        @Override
        public final Builder dataSetOrg(String dataSetOrg) {
            this.dataSetOrg = dataSetOrg;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final Instant getLastReferencedTime() {
            return lastReferencedTime;
        }

        public final void setLastReferencedTime(Instant lastReferencedTime) {
            this.lastReferencedTime = lastReferencedTime;
        }

        @Override
        public final Builder lastReferencedTime(Instant lastReferencedTime) {
            this.lastReferencedTime = lastReferencedTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public DataSetSummary build() {
            return new DataSetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
