/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The primary key for a KSDS data set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrimaryKey implements SdkPojo, Serializable, ToCopyableBuilder<PrimaryKey.Builder, PrimaryKey> {
    private static final SdkField<Integer> LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("length").getter(getter(PrimaryKey::length)).setter(setter(Builder::length))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("length").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PrimaryKey::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("offset").getter(getter(PrimaryKey::offset)).setter(setter(Builder::offset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENGTH_FIELD, NAME_FIELD,
            OFFSET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer length;

    private final String name;

    private final Integer offset;

    private PrimaryKey(BuilderImpl builder) {
        this.length = builder.length;
        this.name = builder.name;
        this.offset = builder.offset;
    }

    /**
     * <p>
     * A strictly positive integer value representing the length of the primary key.
     * </p>
     * 
     * @return A strictly positive integer value representing the length of the primary key.
     */
    public final Integer length() {
        return length;
    }

    /**
     * <p>
     * A name for the Primary Key.
     * </p>
     * 
     * @return A name for the Primary Key.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A positive integer value representing the offset to mark the start of the primary key in the record byte array.
     * </p>
     * 
     * @return A positive integer value representing the offset to mark the start of the primary key in the record byte
     *         array.
     */
    public final Integer offset() {
        return offset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(length());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrimaryKey)) {
            return false;
        }
        PrimaryKey other = (PrimaryKey) obj;
        return Objects.equals(length(), other.length()) && Objects.equals(name(), other.name())
                && Objects.equals(offset(), other.offset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrimaryKey").add("Length", length()).add("Name", name()).add("Offset", offset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "length":
            return Optional.ofNullable(clazz.cast(length()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "offset":
            return Optional.ofNullable(clazz.cast(offset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("length", LENGTH_FIELD);
        map.put("name", NAME_FIELD);
        map.put("offset", OFFSET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrimaryKey, T> g) {
        return obj -> g.apply((PrimaryKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrimaryKey> {
        /**
         * <p>
         * A strictly positive integer value representing the length of the primary key.
         * </p>
         * 
         * @param length
         *        A strictly positive integer value representing the length of the primary key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder length(Integer length);

        /**
         * <p>
         * A name for the Primary Key.
         * </p>
         * 
         * @param name
         *        A name for the Primary Key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A positive integer value representing the offset to mark the start of the primary key in the record byte
         * array.
         * </p>
         * 
         * @param offset
         *        A positive integer value representing the offset to mark the start of the primary key in the record
         *        byte array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(Integer offset);
    }

    static final class BuilderImpl implements Builder {
        private Integer length;

        private String name;

        private Integer offset;

        private BuilderImpl() {
        }

        private BuilderImpl(PrimaryKey model) {
            length(model.length);
            name(model.name);
            offset(model.offset);
        }

        public final Integer getLength() {
            return length;
        }

        public final void setLength(Integer length) {
            this.length = length;
        }

        @Override
        public final Builder length(Integer length) {
            this.length = length;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getOffset() {
            return offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public PrimaryKey build() {
            return new PrimaryKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
