/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataSetDetailsResponse extends M2Response implements
        ToCopyableBuilder<GetDataSetDetailsResponse.Builder, GetDataSetDetailsResponse> {
    private static final SdkField<Integer> BLOCKSIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("blocksize").getter(getter(GetDataSetDetailsResponse::blocksize)).setter(setter(Builder::blocksize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blocksize").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetDataSetDetailsResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> DATA_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSetName").getter(getter(GetDataSetDetailsResponse::dataSetName))
            .setter(setter(Builder::dataSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetName").build()).build();

    private static final SdkField<DatasetDetailOrgAttributes> DATA_SET_ORG_FIELD = SdkField
            .<DatasetDetailOrgAttributes> builder(MarshallingType.SDK_POJO).memberName("dataSetOrg")
            .getter(getter(GetDataSetDetailsResponse::dataSetOrg)).setter(setter(Builder::dataSetOrg))
            .constructor(DatasetDetailOrgAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetOrg").build()).build();

    private static final SdkField<Long> FILE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("fileSize")
            .getter(getter(GetDataSetDetailsResponse::fileSize)).setter(setter(Builder::fileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSize").build()).build();

    private static final SdkField<Instant> LAST_REFERENCED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastReferencedTime").getter(getter(GetDataSetDetailsResponse::lastReferencedTime))
            .setter(setter(Builder::lastReferencedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastReferencedTime").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTime").getter(getter(GetDataSetDetailsResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(GetDataSetDetailsResponse::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<Integer> RECORD_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("recordLength").getter(getter(GetDataSetDetailsResponse::recordLength))
            .setter(setter(Builder::recordLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordLength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKSIZE_FIELD,
            CREATION_TIME_FIELD, DATA_SET_NAME_FIELD, DATA_SET_ORG_FIELD, FILE_SIZE_FIELD, LAST_REFERENCED_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD, LOCATION_FIELD, RECORD_LENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer blocksize;

    private final Instant creationTime;

    private final String dataSetName;

    private final DatasetDetailOrgAttributes dataSetOrg;

    private final Long fileSize;

    private final Instant lastReferencedTime;

    private final Instant lastUpdatedTime;

    private final String location;

    private final Integer recordLength;

    private GetDataSetDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.blocksize = builder.blocksize;
        this.creationTime = builder.creationTime;
        this.dataSetName = builder.dataSetName;
        this.dataSetOrg = builder.dataSetOrg;
        this.fileSize = builder.fileSize;
        this.lastReferencedTime = builder.lastReferencedTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.location = builder.location;
        this.recordLength = builder.recordLength;
    }

    /**
     * <p>
     * The size of the block on disk.
     * </p>
     * 
     * @return The size of the block on disk.
     */
    public final Integer blocksize() {
        return blocksize;
    }

    /**
     * <p>
     * The timestamp when the data set was created.
     * </p>
     * 
     * @return The timestamp when the data set was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The name of the data set.
     * </p>
     * 
     * @return The name of the data set.
     */
    public final String dataSetName() {
        return dataSetName;
    }

    /**
     * <p>
     * The type of data set. The only supported value is VSAM.
     * </p>
     * 
     * @return The type of data set. The only supported value is VSAM.
     */
    public final DatasetDetailOrgAttributes dataSetOrg() {
        return dataSetOrg;
    }

    /**
     * <p>
     * File size of the dataset.
     * </p>
     * 
     * @return File size of the dataset.
     */
    public final Long fileSize() {
        return fileSize;
    }

    /**
     * <p>
     * The last time the data set was referenced.
     * </p>
     * 
     * @return The last time the data set was referenced.
     */
    public final Instant lastReferencedTime() {
        return lastReferencedTime;
    }

    /**
     * <p>
     * The last time the data set was updated.
     * </p>
     * 
     * @return The last time the data set was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The location where the data set is stored.
     * </p>
     * 
     * @return The location where the data set is stored.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The length of records in the data set.
     * </p>
     * 
     * @return The length of records in the data set.
     */
    public final Integer recordLength() {
        return recordLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blocksize());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetName());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetOrg());
        hashCode = 31 * hashCode + Objects.hashCode(fileSize());
        hashCode = 31 * hashCode + Objects.hashCode(lastReferencedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(recordLength());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataSetDetailsResponse)) {
            return false;
        }
        GetDataSetDetailsResponse other = (GetDataSetDetailsResponse) obj;
        return Objects.equals(blocksize(), other.blocksize()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(dataSetName(), other.dataSetName()) && Objects.equals(dataSetOrg(), other.dataSetOrg())
                && Objects.equals(fileSize(), other.fileSize())
                && Objects.equals(lastReferencedTime(), other.lastReferencedTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(location(), other.location())
                && Objects.equals(recordLength(), other.recordLength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataSetDetailsResponse").add("Blocksize", blocksize()).add("CreationTime", creationTime())
                .add("DataSetName", dataSetName()).add("DataSetOrg", dataSetOrg()).add("FileSize", fileSize())
                .add("LastReferencedTime", lastReferencedTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("Location", location()).add("RecordLength", recordLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blocksize":
            return Optional.ofNullable(clazz.cast(blocksize()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "dataSetName":
            return Optional.ofNullable(clazz.cast(dataSetName()));
        case "dataSetOrg":
            return Optional.ofNullable(clazz.cast(dataSetOrg()));
        case "fileSize":
            return Optional.ofNullable(clazz.cast(fileSize()));
        case "lastReferencedTime":
            return Optional.ofNullable(clazz.cast(lastReferencedTime()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "recordLength":
            return Optional.ofNullable(clazz.cast(recordLength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blocksize", BLOCKSIZE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("dataSetName", DATA_SET_NAME_FIELD);
        map.put("dataSetOrg", DATA_SET_ORG_FIELD);
        map.put("fileSize", FILE_SIZE_FIELD);
        map.put("lastReferencedTime", LAST_REFERENCED_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("recordLength", RECORD_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataSetDetailsResponse, T> g) {
        return obj -> g.apply((GetDataSetDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends M2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetDataSetDetailsResponse> {
        /**
         * <p>
         * The size of the block on disk.
         * </p>
         * 
         * @param blocksize
         *        The size of the block on disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocksize(Integer blocksize);

        /**
         * <p>
         * The timestamp when the data set was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when the data set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The name of the data set.
         * </p>
         * 
         * @param dataSetName
         *        The name of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetName(String dataSetName);

        /**
         * <p>
         * The type of data set. The only supported value is VSAM.
         * </p>
         * 
         * @param dataSetOrg
         *        The type of data set. The only supported value is VSAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetOrg(DatasetDetailOrgAttributes dataSetOrg);

        /**
         * <p>
         * The type of data set. The only supported value is VSAM.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetDetailOrgAttributes.Builder}
         * avoiding the need to create one manually via {@link DatasetDetailOrgAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetDetailOrgAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSetOrg(DatasetDetailOrgAttributes)}.
         * 
         * @param dataSetOrg
         *        a consumer that will call methods on {@link DatasetDetailOrgAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSetOrg(DatasetDetailOrgAttributes)
         */
        default Builder dataSetOrg(Consumer<DatasetDetailOrgAttributes.Builder> dataSetOrg) {
            return dataSetOrg(DatasetDetailOrgAttributes.builder().applyMutation(dataSetOrg).build());
        }

        /**
         * <p>
         * File size of the dataset.
         * </p>
         * 
         * @param fileSize
         *        File size of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSize(Long fileSize);

        /**
         * <p>
         * The last time the data set was referenced.
         * </p>
         * 
         * @param lastReferencedTime
         *        The last time the data set was referenced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastReferencedTime(Instant lastReferencedTime);

        /**
         * <p>
         * The last time the data set was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last time the data set was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The location where the data set is stored.
         * </p>
         * 
         * @param location
         *        The location where the data set is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The length of records in the data set.
         * </p>
         * 
         * @param recordLength
         *        The length of records in the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordLength(Integer recordLength);
    }

    static final class BuilderImpl extends M2Response.BuilderImpl implements Builder {
        private Integer blocksize;

        private Instant creationTime;

        private String dataSetName;

        private DatasetDetailOrgAttributes dataSetOrg;

        private Long fileSize;

        private Instant lastReferencedTime;

        private Instant lastUpdatedTime;

        private String location;

        private Integer recordLength;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataSetDetailsResponse model) {
            super(model);
            blocksize(model.blocksize);
            creationTime(model.creationTime);
            dataSetName(model.dataSetName);
            dataSetOrg(model.dataSetOrg);
            fileSize(model.fileSize);
            lastReferencedTime(model.lastReferencedTime);
            lastUpdatedTime(model.lastUpdatedTime);
            location(model.location);
            recordLength(model.recordLength);
        }

        public final Integer getBlocksize() {
            return blocksize;
        }

        public final void setBlocksize(Integer blocksize) {
            this.blocksize = blocksize;
        }

        @Override
        public final Builder blocksize(Integer blocksize) {
            this.blocksize = blocksize;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDataSetName() {
            return dataSetName;
        }

        public final void setDataSetName(String dataSetName) {
            this.dataSetName = dataSetName;
        }

        @Override
        public final Builder dataSetName(String dataSetName) {
            this.dataSetName = dataSetName;
            return this;
        }

        public final DatasetDetailOrgAttributes.Builder getDataSetOrg() {
            return dataSetOrg != null ? dataSetOrg.toBuilder() : null;
        }

        public final void setDataSetOrg(DatasetDetailOrgAttributes.BuilderImpl dataSetOrg) {
            this.dataSetOrg = dataSetOrg != null ? dataSetOrg.build() : null;
        }

        @Override
        public final Builder dataSetOrg(DatasetDetailOrgAttributes dataSetOrg) {
            this.dataSetOrg = dataSetOrg;
            return this;
        }

        public final Long getFileSize() {
            return fileSize;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        @Override
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final Instant getLastReferencedTime() {
            return lastReferencedTime;
        }

        public final void setLastReferencedTime(Instant lastReferencedTime) {
            this.lastReferencedTime = lastReferencedTime;
        }

        @Override
        public final Builder lastReferencedTime(Instant lastReferencedTime) {
            this.lastReferencedTime = lastReferencedTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final Integer getRecordLength() {
            return recordLength;
        }

        public final void setRecordLength(Integer recordLength) {
            this.recordLength = recordLength;
        }

        @Override
        public final Builder recordLength(Integer recordLength) {
            this.recordLength = recordLength;
            return this;
        }

        @Override
        public GetDataSetDetailsResponse build() {
            return new GetDataSetDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
