/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBatchJobDefinitionsResponse extends M2Response implements
        ToCopyableBuilder<ListBatchJobDefinitionsResponse.Builder, ListBatchJobDefinitionsResponse> {
    private static final SdkField<List<BatchJobDefinition>> BATCH_JOB_DEFINITIONS_FIELD = SdkField
            .<List<BatchJobDefinition>> builder(MarshallingType.LIST)
            .memberName("batchJobDefinitions")
            .getter(getter(ListBatchJobDefinitionsResponse::batchJobDefinitions))
            .setter(setter(Builder::batchJobDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchJobDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchJobDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchJobDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBatchJobDefinitionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_JOB_DEFINITIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchJobDefinition> batchJobDefinitions;

    private final String nextToken;

    private ListBatchJobDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.batchJobDefinitions = builder.batchJobDefinitions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BatchJobDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBatchJobDefinitions() {
        return batchJobDefinitions != null && !(batchJobDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of batch job definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBatchJobDefinitions} method.
     * </p>
     * 
     * @return The list of batch job definitions.
     */
    public final List<BatchJobDefinition> batchJobDefinitions() {
        return batchJobDefinitions;
    }

    /**
     * <p>
     * If there are more items to return, this contains a token that is passed to a subsequent call to this operation to
     * retrieve the next set of items.
     * </p>
     * 
     * @return If there are more items to return, this contains a token that is passed to a subsequent call to this
     *         operation to retrieve the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBatchJobDefinitions() ? batchJobDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBatchJobDefinitionsResponse)) {
            return false;
        }
        ListBatchJobDefinitionsResponse other = (ListBatchJobDefinitionsResponse) obj;
        return hasBatchJobDefinitions() == other.hasBatchJobDefinitions()
                && Objects.equals(batchJobDefinitions(), other.batchJobDefinitions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBatchJobDefinitionsResponse")
                .add("BatchJobDefinitions", hasBatchJobDefinitions() ? batchJobDefinitions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchJobDefinitions":
            return Optional.ofNullable(clazz.cast(batchJobDefinitions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("batchJobDefinitions", BATCH_JOB_DEFINITIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBatchJobDefinitionsResponse, T> g) {
        return obj -> g.apply((ListBatchJobDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends M2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListBatchJobDefinitionsResponse> {
        /**
         * <p>
         * The list of batch job definitions.
         * </p>
         * 
         * @param batchJobDefinitions
         *        The list of batch job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchJobDefinitions(Collection<BatchJobDefinition> batchJobDefinitions);

        /**
         * <p>
         * The list of batch job definitions.
         * </p>
         * 
         * @param batchJobDefinitions
         *        The list of batch job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchJobDefinitions(BatchJobDefinition... batchJobDefinitions);

        /**
         * <p>
         * The list of batch job definitions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.m2.model.BatchJobDefinition.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.m2.model.BatchJobDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.m2.model.BatchJobDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #batchJobDefinitions(List<BatchJobDefinition>)}.
         * 
         * @param batchJobDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.m2.model.BatchJobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchJobDefinitions(java.util.Collection<BatchJobDefinition>)
         */
        Builder batchJobDefinitions(Consumer<BatchJobDefinition.Builder>... batchJobDefinitions);

        /**
         * <p>
         * If there are more items to return, this contains a token that is passed to a subsequent call to this
         * operation to retrieve the next set of items.
         * </p>
         * 
         * @param nextToken
         *        If there are more items to return, this contains a token that is passed to a subsequent call to this
         *        operation to retrieve the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends M2Response.BuilderImpl implements Builder {
        private List<BatchJobDefinition> batchJobDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBatchJobDefinitionsResponse model) {
            super(model);
            batchJobDefinitions(model.batchJobDefinitions);
            nextToken(model.nextToken);
        }

        public final List<BatchJobDefinition.Builder> getBatchJobDefinitions() {
            List<BatchJobDefinition.Builder> result = BatchJobDefinitionsCopier.copyToBuilder(this.batchJobDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchJobDefinitions(Collection<BatchJobDefinition.BuilderImpl> batchJobDefinitions) {
            this.batchJobDefinitions = BatchJobDefinitionsCopier.copyFromBuilder(batchJobDefinitions);
        }

        @Override
        public final Builder batchJobDefinitions(Collection<BatchJobDefinition> batchJobDefinitions) {
            this.batchJobDefinitions = BatchJobDefinitionsCopier.copy(batchJobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchJobDefinitions(BatchJobDefinition... batchJobDefinitions) {
            batchJobDefinitions(Arrays.asList(batchJobDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchJobDefinitions(Consumer<BatchJobDefinition.Builder>... batchJobDefinitions) {
            batchJobDefinitions(Stream.of(batchJobDefinitions).map(c -> BatchJobDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBatchJobDefinitionsResponse build() {
            return new ListBatchJobDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
