/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attributes of a VSAM type data set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VsamAttributes implements SdkPojo, Serializable, ToCopyableBuilder<VsamAttributes.Builder, VsamAttributes> {
    private static final SdkField<List<AlternateKey>> ALTERNATE_KEYS_FIELD = SdkField
            .<List<AlternateKey>> builder(MarshallingType.LIST)
            .memberName("alternateKeys")
            .getter(getter(VsamAttributes::alternateKeys))
            .setter(setter(Builder::alternateKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternateKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlternateKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlternateKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> COMPRESSED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("compressed").getter(getter(VsamAttributes::compressed)).setter(setter(Builder::compressed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compressed").build()).build();

    private static final SdkField<String> ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encoding").getter(getter(VsamAttributes::encoding)).setter(setter(Builder::encoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoding").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(VsamAttributes::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<PrimaryKey> PRIMARY_KEY_FIELD = SdkField.<PrimaryKey> builder(MarshallingType.SDK_POJO)
            .memberName("primaryKey").getter(getter(VsamAttributes::primaryKey)).setter(setter(Builder::primaryKey))
            .constructor(PrimaryKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALTERNATE_KEYS_FIELD,
            COMPRESSED_FIELD, ENCODING_FIELD, FORMAT_FIELD, PRIMARY_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AlternateKey> alternateKeys;

    private final Boolean compressed;

    private final String encoding;

    private final String format;

    private final PrimaryKey primaryKey;

    private VsamAttributes(BuilderImpl builder) {
        this.alternateKeys = builder.alternateKeys;
        this.compressed = builder.compressed;
        this.encoding = builder.encoding;
        this.format = builder.format;
        this.primaryKey = builder.primaryKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlternateKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlternateKeys() {
        return alternateKeys != null && !(alternateKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The alternate key definitions, if any. A legacy dataset might not have any alternate key defined, but if those
     * alternate keys definitions exist, provide them as some applications will make use of them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlternateKeys} method.
     * </p>
     * 
     * @return The alternate key definitions, if any. A legacy dataset might not have any alternate key defined, but if
     *         those alternate keys definitions exist, provide them as some applications will make use of them.
     */
    public final List<AlternateKey> alternateKeys() {
        return alternateKeys;
    }

    /**
     * <p>
     * Indicates whether indexes for this dataset are stored as compressed values. If you have a large data set
     * (typically &gt; 100 Mb), consider setting this flag to True.
     * </p>
     * 
     * @return Indicates whether indexes for this dataset are stored as compressed values. If you have a large data set
     *         (typically &gt; 100 Mb), consider setting this flag to True.
     */
    public final Boolean compressed() {
        return compressed;
    }

    /**
     * <p>
     * The character set used by the data set. Can be ASCII, EBCDIC, or unknown.
     * </p>
     * 
     * @return The character set used by the data set. Can be ASCII, EBCDIC, or unknown.
     */
    public final String encoding() {
        return encoding;
    }

    /**
     * <p>
     * The record format of the data set.
     * </p>
     * 
     * @return The record format of the data set.
     */
    public final String format() {
        return format;
    }

    /**
     * <p>
     * The primary key of the data set.
     * </p>
     * 
     * @return The primary key of the data set.
     */
    public final PrimaryKey primaryKey() {
        return primaryKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAlternateKeys() ? alternateKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(compressed());
        hashCode = 31 * hashCode + Objects.hashCode(encoding());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(primaryKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VsamAttributes)) {
            return false;
        }
        VsamAttributes other = (VsamAttributes) obj;
        return hasAlternateKeys() == other.hasAlternateKeys() && Objects.equals(alternateKeys(), other.alternateKeys())
                && Objects.equals(compressed(), other.compressed()) && Objects.equals(encoding(), other.encoding())
                && Objects.equals(format(), other.format()) && Objects.equals(primaryKey(), other.primaryKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VsamAttributes").add("AlternateKeys", hasAlternateKeys() ? alternateKeys() : null)
                .add("Compressed", compressed()).add("Encoding", encoding()).add("Format", format())
                .add("PrimaryKey", primaryKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alternateKeys":
            return Optional.ofNullable(clazz.cast(alternateKeys()));
        case "compressed":
            return Optional.ofNullable(clazz.cast(compressed()));
        case "encoding":
            return Optional.ofNullable(clazz.cast(encoding()));
        case "format":
            return Optional.ofNullable(clazz.cast(format()));
        case "primaryKey":
            return Optional.ofNullable(clazz.cast(primaryKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("alternateKeys", ALTERNATE_KEYS_FIELD);
        map.put("compressed", COMPRESSED_FIELD);
        map.put("encoding", ENCODING_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("primaryKey", PRIMARY_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VsamAttributes, T> g) {
        return obj -> g.apply((VsamAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VsamAttributes> {
        /**
         * <p>
         * The alternate key definitions, if any. A legacy dataset might not have any alternate key defined, but if
         * those alternate keys definitions exist, provide them as some applications will make use of them.
         * </p>
         * 
         * @param alternateKeys
         *        The alternate key definitions, if any. A legacy dataset might not have any alternate key defined, but
         *        if those alternate keys definitions exist, provide them as some applications will make use of them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateKeys(Collection<AlternateKey> alternateKeys);

        /**
         * <p>
         * The alternate key definitions, if any. A legacy dataset might not have any alternate key defined, but if
         * those alternate keys definitions exist, provide them as some applications will make use of them.
         * </p>
         * 
         * @param alternateKeys
         *        The alternate key definitions, if any. A legacy dataset might not have any alternate key defined, but
         *        if those alternate keys definitions exist, provide them as some applications will make use of them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateKeys(AlternateKey... alternateKeys);

        /**
         * <p>
         * The alternate key definitions, if any. A legacy dataset might not have any alternate key defined, but if
         * those alternate keys definitions exist, provide them as some applications will make use of them.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.m2.model.AlternateKey.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.m2.model.AlternateKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.m2.model.AlternateKey.Builder#build()} is called immediately and its
         * result is passed to {@link #alternateKeys(List<AlternateKey>)}.
         * 
         * @param alternateKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.m2.model.AlternateKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alternateKeys(java.util.Collection<AlternateKey>)
         */
        Builder alternateKeys(Consumer<AlternateKey.Builder>... alternateKeys);

        /**
         * <p>
         * Indicates whether indexes for this dataset are stored as compressed values. If you have a large data set
         * (typically &gt; 100 Mb), consider setting this flag to True.
         * </p>
         * 
         * @param compressed
         *        Indicates whether indexes for this dataset are stored as compressed values. If you have a large data
         *        set (typically &gt; 100 Mb), consider setting this flag to True.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compressed(Boolean compressed);

        /**
         * <p>
         * The character set used by the data set. Can be ASCII, EBCDIC, or unknown.
         * </p>
         * 
         * @param encoding
         *        The character set used by the data set. Can be ASCII, EBCDIC, or unknown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encoding(String encoding);

        /**
         * <p>
         * The record format of the data set.
         * </p>
         * 
         * @param format
         *        The record format of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The primary key of the data set.
         * </p>
         * 
         * @param primaryKey
         *        The primary key of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryKey(PrimaryKey primaryKey);

        /**
         * <p>
         * The primary key of the data set.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrimaryKey.Builder} avoiding the need to
         * create one manually via {@link PrimaryKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrimaryKey.Builder#build()} is called immediately and its result
         * is passed to {@link #primaryKey(PrimaryKey)}.
         * 
         * @param primaryKey
         *        a consumer that will call methods on {@link PrimaryKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryKey(PrimaryKey)
         */
        default Builder primaryKey(Consumer<PrimaryKey.Builder> primaryKey) {
            return primaryKey(PrimaryKey.builder().applyMutation(primaryKey).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<AlternateKey> alternateKeys = DefaultSdkAutoConstructList.getInstance();

        private Boolean compressed;

        private String encoding;

        private String format;

        private PrimaryKey primaryKey;

        private BuilderImpl() {
        }

        private BuilderImpl(VsamAttributes model) {
            alternateKeys(model.alternateKeys);
            compressed(model.compressed);
            encoding(model.encoding);
            format(model.format);
            primaryKey(model.primaryKey);
        }

        public final List<AlternateKey.Builder> getAlternateKeys() {
            List<AlternateKey.Builder> result = AlternateKeyListCopier.copyToBuilder(this.alternateKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlternateKeys(Collection<AlternateKey.BuilderImpl> alternateKeys) {
            this.alternateKeys = AlternateKeyListCopier.copyFromBuilder(alternateKeys);
        }

        @Override
        public final Builder alternateKeys(Collection<AlternateKey> alternateKeys) {
            this.alternateKeys = AlternateKeyListCopier.copy(alternateKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateKeys(AlternateKey... alternateKeys) {
            alternateKeys(Arrays.asList(alternateKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateKeys(Consumer<AlternateKey.Builder>... alternateKeys) {
            alternateKeys(Stream.of(alternateKeys).map(c -> AlternateKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCompressed() {
            return compressed;
        }

        public final void setCompressed(Boolean compressed) {
            this.compressed = compressed;
        }

        @Override
        public final Builder compressed(Boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        public final String getEncoding() {
            return encoding;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final PrimaryKey.Builder getPrimaryKey() {
            return primaryKey != null ? primaryKey.toBuilder() : null;
        }

        public final void setPrimaryKey(PrimaryKey.BuilderImpl primaryKey) {
            this.primaryKey = primaryKey != null ? primaryKey.build() : null;
        }

        @Override
        public final Builder primaryKey(PrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        @Override
        public VsamAttributes build() {
            return new VsamAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
