/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeMLModels</code> operation. The content is essentially a list of
 * <code>MLModel</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMLModelsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeMLModelsResponse.Builder, DescribeMLModelsResponse> {
    private final List<MLModel> results;

    private final String nextToken;

    private DescribeMLModelsResponse(BuilderImpl builder) {
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>MLModel</code> that meet the search criteria.
     * </p>
     * 
     * @return A list of <code>MLModel</code> that meet the search criteria.
     */
    public List<MLModel> results() {
        return results;
    }

    /**
     * <p>
     * The ID of the next page in the paginated results that indicates at least one more page follows.
     * </p>
     * 
     * @return The ID of the next page in the paginated results that indicates at least one more page follows.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((results() == null) ? 0 : results().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMLModelsResponse)) {
            return false;
        }
        DescribeMLModelsResponse other = (DescribeMLModelsResponse) obj;
        if (other.results() == null ^ this.results() == null) {
            return false;
        }
        if (other.results() != null && !other.results().equals(this.results())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (results() != null) {
            sb.append("Results: ").append(results()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMLModelsResponse> {
        /**
         * <p>
         * A list of <code>MLModel</code> that meet the search criteria.
         * </p>
         * 
         * @param results
         *        A list of <code>MLModel</code> that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<MLModel> results);

        /**
         * <p>
         * A list of <code>MLModel</code> that meet the search criteria.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setResults(java.util.Collection)} or {@link #withResults(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param results
         *        A list of <code>MLModel</code> that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(MLModel... results);

        /**
         * <p>
         * The ID of the next page in the paginated results that indicates at least one more page follows.
         * </p>
         * 
         * @param nextToken
         *        The ID of the next page in the paginated results that indicates at least one more page follows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<MLModel> results = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMLModelsResponse model) {
            setResults(model.results);
            setNextToken(model.nextToken);
        }

        public final Collection<MLModel> getResults() {
            return results;
        }

        @Override
        public final Builder results(Collection<MLModel> results) {
            this.results = MLModelsCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(MLModel... results) {
            if (this.results == null) {
                this.results = new SdkInternalList<>(results.length);
            }
            for (MLModel e : results) {
                this.results.add(e);
            }
            return this;
        }

        public final void setResults(Collection<MLModel> results) {
            this.results = MLModelsCopier.copy(results);
        }

        @SafeVarargs
        public final void setResults(MLModel... results) {
            if (this.results == null) {
                this.results = new SdkInternalList<>(results.length);
            }
            for (MLModel e : results) {
                this.results.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMLModelsResponse build() {
            return new DescribeMLModelsResponse(this);
        }
    }
}
