/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetMLModelRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetMLModelRequest.Builder, GetMLModelRequest> {
    private final String mlModelId;

    private final Boolean verbose;

    private GetMLModelRequest(BuilderImpl builder) {
        this.mlModelId = builder.mlModelId;
        this.verbose = builder.verbose;
    }

    /**
     * <p>
     * The ID assigned to the <code>MLModel</code> at creation.
     * </p>
     * 
     * @return The ID assigned to the <code>MLModel</code> at creation.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.
     * </p>
     * <p>
     * If true, <code>Recipe</code> is returned.
     * </p>
     * <p>
     * If false, <code>Recipe</code> is not returned.
     * </p>
     * 
     * @return Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p>
     *         <p>
     *         If true, <code>Recipe</code> is returned.
     *         </p>
     *         <p>
     *         If false, <code>Recipe</code> is not returned.
     */
    public Boolean verbose() {
        return verbose;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((mlModelId() == null) ? 0 : mlModelId().hashCode());
        hashCode = 31 * hashCode + ((verbose() == null) ? 0 : verbose().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMLModelRequest)) {
            return false;
        }
        GetMLModelRequest other = (GetMLModelRequest) obj;
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.verbose() == null ^ this.verbose() == null) {
            return false;
        }
        if (other.verbose() != null && !other.verbose().equals(this.verbose())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (mlModelId() != null) {
            sb.append("MLModelId: ").append(mlModelId()).append(",");
        }
        if (verbose() != null) {
            sb.append("Verbose: ").append(verbose()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetMLModelRequest> {
        /**
         * <p>
         * The ID assigned to the <code>MLModel</code> at creation.
         * </p>
         * 
         * @param mlModelId
         *        The ID assigned to the <code>MLModel</code> at creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.
         * </p>
         * <p>
         * If true, <code>Recipe</code> is returned.
         * </p>
         * <p>
         * If false, <code>Recipe</code> is not returned.
         * </p>
         * 
         * @param verbose
         *        Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p>
         *        <p>
         *        If true, <code>Recipe</code> is returned.
         *        </p>
         *        <p>
         *        If false, <code>Recipe</code> is not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verbose(Boolean verbose);
    }

    private static final class BuilderImpl implements Builder {
        private String mlModelId;

        private Boolean verbose;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMLModelRequest model) {
            setMLModelId(model.mlModelId);
            setVerbose(model.verbose);
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final Boolean getVerbose() {
            return verbose;
        }

        @Override
        public final Builder verbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public final void setVerbose(Boolean verbose) {
            this.verbose = verbose;
        }

        @Override
        public GetMLModelRequest build() {
            return new GetMLModelRequest(this);
        }
    }
}
