/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A second request to use or change an object was not allowed. This can result from retrying a request using a
 * parameter that was not present in the original request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IdempotentParameterMismatchException extends MachineLearningException implements
        ToCopyableBuilder<IdempotentParameterMismatchException.Builder, IdempotentParameterMismatchException> {
    private final Integer code;

    private IdempotentParameterMismatchException(BuilderImpl builder) {
        super(builder.message);
        this.code = builder.code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     *
     * @return
     */
    public Integer code() {
        return code;
    }

    public interface Builder extends CopyableBuilder<Builder, IdempotentParameterMismatchException> {
        /**
         *
         * @param code
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Integer code);

        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private Integer code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(IdempotentParameterMismatchException model) {
            setCode(model.code);
            this.message = model.getMessage();
        }

        public final Integer getCode() {
            return code;
        }

        @Override
        public final Builder code(Integer code) {
            this.code = code;
            return this;
        }

        @JsonProperty("code")
        public final void setCode(Integer code) {
            this.code = code;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public IdempotentParameterMismatchException build() {
            return new IdempotentParameterMismatchException(this);
        }
    }
}
