/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.RDSMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The datasource details that are specific to Amazon RDS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RDSMetadata implements StructuredPojo, ToCopyableBuilder<RDSMetadata.Builder, RDSMetadata> {
    private final RDSDatabase database;

    private final String databaseUserName;

    private final String selectSqlQuery;

    private final String resourceRole;

    private final String serviceRole;

    private final String dataPipelineId;

    private RDSMetadata(BuilderImpl builder) {
        this.database = builder.database;
        this.databaseUserName = builder.databaseUserName;
        this.selectSqlQuery = builder.selectSqlQuery;
        this.resourceRole = builder.resourceRole;
        this.serviceRole = builder.serviceRole;
        this.dataPipelineId = builder.dataPipelineId;
    }

    /**
     * <p>
     * The database details required to connect to an Amazon RDS.
     * </p>
     * 
     * @return The database details required to connect to an Amazon RDS.
     */
    public RDSDatabase database() {
        return database;
    }

    /**
     *
     * @return
     */
    public String databaseUserName() {
        return databaseUserName;
    }

    /**
     * <p>
     * The SQL query that is supplied during <a>CreateDataSourceFromRDS</a>. Returns only if <code>Verbose</code> is
     * true in <code>GetDataSourceInput</code>.
     * </p>
     * 
     * @return The SQL query that is supplied during <a>CreateDataSourceFromRDS</a>. Returns only if
     *         <code>Verbose</code> is true in <code>GetDataSourceInput</code>.
     */
    public String selectSqlQuery() {
        return selectSqlQuery;
    }

    /**
     * <p>
     * The role (DataPipelineDefaultResourceRole) assumed by an Amazon EC2 instance to carry out the copy task from
     * Amazon RDS to Amazon S3. For more information, see <a
     * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
     * data pipelines.
     * </p>
     * 
     * @return The role (DataPipelineDefaultResourceRole) assumed by an Amazon EC2 instance to carry out the copy task
     *         from Amazon RDS to Amazon S3. For more information, see <a
     *         href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a>
     *         for data pipelines.
     */
    public String resourceRole() {
        return resourceRole;
    }

    /**
     * <p>
     * The role (DataPipelineDefaultRole) assumed by the Data Pipeline service to monitor the progress of the copy task
     * from Amazon RDS to Amazon S3. For more information, see <a
     * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
     * data pipelines.
     * </p>
     * 
     * @return The role (DataPipelineDefaultRole) assumed by the Data Pipeline service to monitor the progress of the
     *         copy task from Amazon RDS to Amazon S3. For more information, see <a
     *         href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a>
     *         for data pipelines.
     */
    public String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The ID of the Data Pipeline instance that is used to carry to copy data from Amazon RDS to Amazon S3. You can use
     * the ID to find details about the instance in the Data Pipeline console.
     * </p>
     * 
     * @return The ID of the Data Pipeline instance that is used to carry to copy data from Amazon RDS to Amazon S3. You
     *         can use the ID to find details about the instance in the Data Pipeline console.
     */
    public String dataPipelineId() {
        return dataPipelineId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((database() == null) ? 0 : database().hashCode());
        hashCode = 31 * hashCode + ((databaseUserName() == null) ? 0 : databaseUserName().hashCode());
        hashCode = 31 * hashCode + ((selectSqlQuery() == null) ? 0 : selectSqlQuery().hashCode());
        hashCode = 31 * hashCode + ((resourceRole() == null) ? 0 : resourceRole().hashCode());
        hashCode = 31 * hashCode + ((serviceRole() == null) ? 0 : serviceRole().hashCode());
        hashCode = 31 * hashCode + ((dataPipelineId() == null) ? 0 : dataPipelineId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSMetadata)) {
            return false;
        }
        RDSMetadata other = (RDSMetadata) obj;
        if (other.database() == null ^ this.database() == null) {
            return false;
        }
        if (other.database() != null && !other.database().equals(this.database())) {
            return false;
        }
        if (other.databaseUserName() == null ^ this.databaseUserName() == null) {
            return false;
        }
        if (other.databaseUserName() != null && !other.databaseUserName().equals(this.databaseUserName())) {
            return false;
        }
        if (other.selectSqlQuery() == null ^ this.selectSqlQuery() == null) {
            return false;
        }
        if (other.selectSqlQuery() != null && !other.selectSqlQuery().equals(this.selectSqlQuery())) {
            return false;
        }
        if (other.resourceRole() == null ^ this.resourceRole() == null) {
            return false;
        }
        if (other.resourceRole() != null && !other.resourceRole().equals(this.resourceRole())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        if (other.serviceRole() != null && !other.serviceRole().equals(this.serviceRole())) {
            return false;
        }
        if (other.dataPipelineId() == null ^ this.dataPipelineId() == null) {
            return false;
        }
        if (other.dataPipelineId() != null && !other.dataPipelineId().equals(this.dataPipelineId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (database() != null) {
            sb.append("Database: ").append(database()).append(",");
        }
        if (databaseUserName() != null) {
            sb.append("DatabaseUserName: ").append(databaseUserName()).append(",");
        }
        if (selectSqlQuery() != null) {
            sb.append("SelectSqlQuery: ").append(selectSqlQuery()).append(",");
        }
        if (resourceRole() != null) {
            sb.append("ResourceRole: ").append(resourceRole()).append(",");
        }
        if (serviceRole() != null) {
            sb.append("ServiceRole: ").append(serviceRole()).append(",");
        }
        if (dataPipelineId() != null) {
            sb.append("DataPipelineId: ").append(dataPipelineId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RDSMetadata> {
        /**
         * <p>
         * The database details required to connect to an Amazon RDS.
         * </p>
         * 
         * @param database
         *        The database details required to connect to an Amazon RDS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(RDSDatabase database);

        /**
         *
         * @param databaseUserName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseUserName(String databaseUserName);

        /**
         * <p>
         * The SQL query that is supplied during <a>CreateDataSourceFromRDS</a>. Returns only if <code>Verbose</code> is
         * true in <code>GetDataSourceInput</code>.
         * </p>
         * 
         * @param selectSqlQuery
         *        The SQL query that is supplied during <a>CreateDataSourceFromRDS</a>. Returns only if
         *        <code>Verbose</code> is true in <code>GetDataSourceInput</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectSqlQuery(String selectSqlQuery);

        /**
         * <p>
         * The role (DataPipelineDefaultResourceRole) assumed by an Amazon EC2 instance to carry out the copy task from
         * Amazon RDS to Amazon S3. For more information, see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
         * data pipelines.
         * </p>
         * 
         * @param resourceRole
         *        The role (DataPipelineDefaultResourceRole) assumed by an Amazon EC2 instance to carry out the copy
         *        task from Amazon RDS to Amazon S3. For more information, see <a
         *        href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role
         *        templates</a> for data pipelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRole(String resourceRole);

        /**
         * <p>
         * The role (DataPipelineDefaultRole) assumed by the Data Pipeline service to monitor the progress of the copy
         * task from Amazon RDS to Amazon S3. For more information, see <a
         * href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for
         * data pipelines.
         * </p>
         * 
         * @param serviceRole
         *        The role (DataPipelineDefaultRole) assumed by the Data Pipeline service to monitor the progress of the
         *        copy task from Amazon RDS to Amazon S3. For more information, see <a
         *        href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role
         *        templates</a> for data pipelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The ID of the Data Pipeline instance that is used to carry to copy data from Amazon RDS to Amazon S3. You can
         * use the ID to find details about the instance in the Data Pipeline console.
         * </p>
         * 
         * @param dataPipelineId
         *        The ID of the Data Pipeline instance that is used to carry to copy data from Amazon RDS to Amazon S3.
         *        You can use the ID to find details about the instance in the Data Pipeline console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPipelineId(String dataPipelineId);
    }

    private static final class BuilderImpl implements Builder {
        private RDSDatabase database;

        private String databaseUserName;

        private String selectSqlQuery;

        private String resourceRole;

        private String serviceRole;

        private String dataPipelineId;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSMetadata model) {
            setDatabase(model.database);
            setDatabaseUserName(model.databaseUserName);
            setSelectSqlQuery(model.selectSqlQuery);
            setResourceRole(model.resourceRole);
            setServiceRole(model.serviceRole);
            setDataPipelineId(model.dataPipelineId);
        }

        public final RDSDatabase getDatabase() {
            return database;
        }

        @Override
        public final Builder database(RDSDatabase database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(RDSDatabase database) {
            this.database = database;
        }

        public final String getDatabaseUserName() {
            return databaseUserName;
        }

        @Override
        public final Builder databaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
            return this;
        }

        public final void setDatabaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
        }

        public final String getSelectSqlQuery() {
            return selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        public final String getResourceRole() {
            return resourceRole;
        }

        @Override
        public final Builder resourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
            return this;
        }

        public final void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getDataPipelineId() {
            return dataPipelineId;
        }

        @Override
        public final Builder dataPipelineId(String dataPipelineId) {
            this.dataPipelineId = dataPipelineId;
            return this;
        }

        public final void setDataPipelineId(String dataPipelineId) {
            this.dataPipelineId = dataPipelineId;
        }

        @Override
        public RDSMetadata build() {
            return new RDSMetadata(this);
        }
    }
}
