/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.RedshiftDatabaseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the database details required to connect to an Amazon Redshift database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RedshiftDatabase implements StructuredPojo, ToCopyableBuilder<RedshiftDatabase.Builder, RedshiftDatabase> {
    private final String databaseName;

    private final String clusterIdentifier;

    private RedshiftDatabase(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.clusterIdentifier = builder.clusterIdentifier;
    }

    /**
     *
     * @return
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     *
     * @return
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((databaseName() == null) ? 0 : databaseName().hashCode());
        hashCode = 31 * hashCode + ((clusterIdentifier() == null) ? 0 : clusterIdentifier().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDatabase)) {
            return false;
        }
        RedshiftDatabase other = (RedshiftDatabase) obj;
        if (other.databaseName() == null ^ this.databaseName() == null) {
            return false;
        }
        if (other.databaseName() != null && !other.databaseName().equals(this.databaseName())) {
            return false;
        }
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (databaseName() != null) {
            sb.append("DatabaseName: ").append(databaseName()).append(",");
        }
        if (clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(clusterIdentifier()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftDatabaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RedshiftDatabase> {
        /**
         *
         * @param databaseName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         *
         * @param clusterIdentifier
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);
    }

    private static final class BuilderImpl implements Builder {
        private String databaseName;

        private String clusterIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDatabase model) {
            setDatabaseName(model.databaseName);
            setClusterIdentifier(model.clusterIdentifier);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public RedshiftDatabase build() {
            return new RedshiftDatabase(this);
        }
    }
}
