/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.machinelearning.model.S3DataSpec;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDataSourceFromS3Request
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDataSourceFromS3Request> {
    private final String dataSourceId;
    private final String dataSourceName;
    private final S3DataSpec dataSpec;
    private final Boolean computeStatistics;

    private CreateDataSourceFromS3Request(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
        this.dataSpec = builder.dataSpec;
        this.computeStatistics = builder.computeStatistics;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    public String dataSourceName() {
        return this.dataSourceName;
    }

    public S3DataSpec dataSpec() {
        return this.dataSpec;
    }

    public Boolean computeStatistics() {
        return this.computeStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dataSourceId() == null ? 0 : this.dataSourceId().hashCode());
        hashCode = 31 * hashCode + (this.dataSourceName() == null ? 0 : this.dataSourceName().hashCode());
        hashCode = 31 * hashCode + (this.dataSpec() == null ? 0 : this.dataSpec().hashCode());
        hashCode = 31 * hashCode + (this.computeStatistics() == null ? 0 : this.computeStatistics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromS3Request)) {
            return false;
        }
        CreateDataSourceFromS3Request other = (CreateDataSourceFromS3Request)((Object)obj);
        if (other.dataSourceId() == null ^ this.dataSourceId() == null) {
            return false;
        }
        if (other.dataSourceId() != null && !other.dataSourceId().equals(this.dataSourceId())) {
            return false;
        }
        if (other.dataSourceName() == null ^ this.dataSourceName() == null) {
            return false;
        }
        if (other.dataSourceName() != null && !other.dataSourceName().equals(this.dataSourceName())) {
            return false;
        }
        if (other.dataSpec() == null ^ this.dataSpec() == null) {
            return false;
        }
        if (other.dataSpec() != null && !other.dataSpec().equals(this.dataSpec())) {
            return false;
        }
        if (other.computeStatistics() == null ^ this.computeStatistics() == null) {
            return false;
        }
        return other.computeStatistics() == null || other.computeStatistics().equals(this.computeStatistics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dataSourceId() != null) {
            sb.append("DataSourceId: ").append(this.dataSourceId()).append(",");
        }
        if (this.dataSourceName() != null) {
            sb.append("DataSourceName: ").append(this.dataSourceName()).append(",");
        }
        if (this.dataSpec() != null) {
            sb.append("DataSpec: ").append(this.dataSpec()).append(",");
        }
        if (this.computeStatistics() != null) {
            sb.append("ComputeStatistics: ").append(this.computeStatistics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String dataSourceName;
        private S3DataSpec dataSpec;
        private Boolean computeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromS3Request model) {
            this.setDataSourceId(model.dataSourceId);
            this.setDataSourceName(model.dataSourceName);
            this.setDataSpec(model.dataSpec);
            this.setComputeStatistics(model.computeStatistics);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final S3DataSpec getDataSpec() {
            return this.dataSpec;
        }

        @Override
        public final Builder dataSpec(S3DataSpec dataSpec) {
            this.dataSpec = dataSpec;
            return this;
        }

        public final void setDataSpec(S3DataSpec dataSpec) {
            this.dataSpec = dataSpec;
        }

        public final Boolean getComputeStatistics() {
            return this.computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        public CreateDataSourceFromS3Request build() {
            return new CreateDataSourceFromS3Request(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDataSourceFromS3Request> {
        public Builder dataSourceId(String var1);

        public Builder dataSourceName(String var1);

        public Builder dataSpec(S3DataSpec var1);

        public Builder computeStatistics(Boolean var1);
    }
}

