/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>CreateEvaluation</code> operation, and is an acknowledgement that Amazon ML received
 * the request.
 * </p>
 * <p>
 * <code>CreateEvaluation</code> operation is asynchronous. You can poll for status updates by using the
 * <code>GetEvcaluation</code> operation and checking the <code>Status</code> parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateEvaluationResponse extends MachineLearningResponse implements
        ToCopyableBuilder<CreateEvaluationResponse.Builder, CreateEvaluationResponse> {
    private final String evaluationId;

    private CreateEvaluationResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationId = builder.evaluationId;
    }

    /**
     * <p>
     * The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the
     * value of the <code>EvaluationId</code> in the request.
     * </p>
     * 
     * @return The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical
     *         to the value of the <code>EvaluationId</code> in the request.
     */
    public String evaluationId() {
        return evaluationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEvaluationResponse)) {
            return false;
        }
        CreateEvaluationResponse other = (CreateEvaluationResponse) obj;
        return Objects.equals(evaluationId(), other.evaluationId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateEvaluationResponse").add("EvaluationId", evaluationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationId":
            return Optional.of(clazz.cast(evaluationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningResponse.Builder, CopyableBuilder<Builder, CreateEvaluationResponse> {
        /**
         * <p>
         * The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to
         * the value of the <code>EvaluationId</code> in the request.
         * </p>
         * 
         * @param evaluationId
         *        The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be
         *        identical to the value of the <code>EvaluationId</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationId(String evaluationId);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String evaluationId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEvaluationResponse model) {
            super(model);
            evaluationId(model.evaluationId);
        }

        public final String getEvaluationId() {
            return evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public CreateEvaluationResponse build() {
            return new CreateEvaluationResponse(this);
        }
    }
}
