/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.BatchPrediction;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link BatchPrediction} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class BatchPredictionMarshaller {
    private static final MarshallingInfo<String> BATCHPREDICTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchPredictionId").isBinary(false).build();

    private static final MarshallingInfo<String> MLMODELID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelId").isBinary(false).build();

    private static final MarshallingInfo<String> BATCHPREDICTIONDATASOURCEID_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("BatchPredictionDataSourceId").isBinary(false).build();

    private static final MarshallingInfo<String> INPUTDATALOCATIONS3_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataLocationS3").isBinary(false).build();

    private static final MarshallingInfo<String> CREATEDBYIAMUSER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedByIamUser").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedAt").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<String> OUTPUTURI_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputUri").isBinary(false).build();

    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();

    private static final MarshallingInfo<Long> COMPUTETIME_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> FINISHEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinishedAt").isBinary(false).build();

    private static final MarshallingInfo<Instant> STARTEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedAt").isBinary(false).build();

    private static final MarshallingInfo<Long> TOTALRECORDCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalRecordCount").isBinary(false).build();

    private static final MarshallingInfo<Long> INVALIDRECORDCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvalidRecordCount").isBinary(false).build();

    private static final BatchPredictionMarshaller INSTANCE = new BatchPredictionMarshaller();

    private BatchPredictionMarshaller() {
    }

    public static BatchPredictionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(BatchPrediction batchPrediction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(batchPrediction, "batchPrediction");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(batchPrediction.batchPredictionId(), BATCHPREDICTIONID_BINDING);
            protocolMarshaller.marshall(batchPrediction.mlModelId(), MLMODELID_BINDING);
            protocolMarshaller.marshall(batchPrediction.batchPredictionDataSourceId(), BATCHPREDICTIONDATASOURCEID_BINDING);
            protocolMarshaller.marshall(batchPrediction.inputDataLocationS3(), INPUTDATALOCATIONS3_BINDING);
            protocolMarshaller.marshall(batchPrediction.createdByIamUser(), CREATEDBYIAMUSER_BINDING);
            protocolMarshaller.marshall(batchPrediction.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(batchPrediction.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall(batchPrediction.name(), NAME_BINDING);
            protocolMarshaller.marshall(batchPrediction.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(batchPrediction.outputUri(), OUTPUTURI_BINDING);
            protocolMarshaller.marshall(batchPrediction.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall(batchPrediction.computeTime(), COMPUTETIME_BINDING);
            protocolMarshaller.marshall(batchPrediction.finishedAt(), FINISHEDAT_BINDING);
            protocolMarshaller.marshall(batchPrediction.startedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall(batchPrediction.totalRecordCount(), TOTALRECORDCOUNT_BINDING);
            protocolMarshaller.marshall(batchPrediction.invalidRecordCount(), INVALIDRECORDCOUNT_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
