/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.machinelearning.model.EntityStatus;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningResponse;
import software.amazon.awssdk.services.machinelearning.model.PerformanceMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetEvaluationResponse
extends MachineLearningResponse
implements ToCopyableBuilder<Builder, GetEvaluationResponse> {
    private final String evaluationId;
    private final String mlModelId;
    private final String evaluationDataSourceId;
    private final String inputDataLocationS3;
    private final String createdByIamUser;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String name;
    private final String status;
    private final PerformanceMetrics performanceMetrics;
    private final String logUri;
    private final String message;
    private final Long computeTime;
    private final Instant finishedAt;
    private final Instant startedAt;

    private GetEvaluationResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationId = builder.evaluationId;
        this.mlModelId = builder.mlModelId;
        this.evaluationDataSourceId = builder.evaluationDataSourceId;
        this.inputDataLocationS3 = builder.inputDataLocationS3;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.performanceMetrics = builder.performanceMetrics;
        this.logUri = builder.logUri;
        this.message = builder.message;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
    }

    public String evaluationId() {
        return this.evaluationId;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public String evaluationDataSourceId() {
        return this.evaluationDataSourceId;
    }

    public String inputDataLocationS3() {
        return this.inputDataLocationS3;
    }

    public String createdByIamUser() {
        return this.createdByIamUser;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public String name() {
        return this.name;
    }

    public EntityStatus status() {
        return EntityStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public PerformanceMetrics performanceMetrics() {
        return this.performanceMetrics;
    }

    public String logUri() {
        return this.logUri;
    }

    public String message() {
        return this.message;
    }

    public Long computeTime() {
        return this.computeTime;
    }

    public Instant finishedAt() {
        return this.finishedAt;
    }

    public Instant startedAt() {
        return this.startedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationDataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataLocationS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdByIamUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvaluationResponse)) {
            return false;
        }
        GetEvaluationResponse other = (GetEvaluationResponse)((Object)obj);
        return Objects.equals(this.evaluationId(), other.evaluationId()) && Objects.equals(this.mlModelId(), other.mlModelId()) && Objects.equals(this.evaluationDataSourceId(), other.evaluationDataSourceId()) && Objects.equals(this.inputDataLocationS3(), other.inputDataLocationS3()) && Objects.equals(this.createdByIamUser(), other.createdByIamUser()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.performanceMetrics(), other.performanceMetrics()) && Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.computeTime(), other.computeTime()) && Objects.equals(this.finishedAt(), other.finishedAt()) && Objects.equals(this.startedAt(), other.startedAt());
    }

    public String toString() {
        return ToString.builder((String)"GetEvaluationResponse").add("EvaluationId", (Object)this.evaluationId()).add("MLModelId", (Object)this.mlModelId()).add("EvaluationDataSourceId", (Object)this.evaluationDataSourceId()).add("InputDataLocationS3", (Object)this.inputDataLocationS3()).add("CreatedByIamUser", (Object)this.createdByIamUser()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("PerformanceMetrics", (Object)this.performanceMetrics()).add("LogUri", (Object)this.logUri()).add("Message", (Object)this.message()).add("ComputeTime", (Object)this.computeTime()).add("FinishedAt", (Object)this.finishedAt()).add("StartedAt", (Object)this.startedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationId": {
                return Optional.of(clazz.cast(this.evaluationId()));
            }
            case "MLModelId": {
                return Optional.of(clazz.cast(this.mlModelId()));
            }
            case "EvaluationDataSourceId": {
                return Optional.of(clazz.cast(this.evaluationDataSourceId()));
            }
            case "InputDataLocationS3": {
                return Optional.of(clazz.cast(this.inputDataLocationS3()));
            }
            case "CreatedByIamUser": {
                return Optional.of(clazz.cast(this.createdByIamUser()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.of(clazz.cast(this.lastUpdatedAt()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
            case "PerformanceMetrics": {
                return Optional.of(clazz.cast(this.performanceMetrics()));
            }
            case "LogUri": {
                return Optional.of(clazz.cast(this.logUri()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "ComputeTime": {
                return Optional.of(clazz.cast(this.computeTime()));
            }
            case "FinishedAt": {
                return Optional.of(clazz.cast(this.finishedAt()));
            }
            case "StartedAt": {
                return Optional.of(clazz.cast(this.startedAt()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningResponse.BuilderImpl
    implements Builder {
        private String evaluationId;
        private String mlModelId;
        private String evaluationDataSourceId;
        private String inputDataLocationS3;
        private String createdByIamUser;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String name;
        private String status;
        private PerformanceMetrics performanceMetrics;
        private String logUri;
        private String message;
        private Long computeTime;
        private Instant finishedAt;
        private Instant startedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvaluationResponse model) {
            super(model);
            this.evaluationId(model.evaluationId);
            this.mlModelId(model.mlModelId);
            this.evaluationDataSourceId(model.evaluationDataSourceId);
            this.inputDataLocationS3(model.inputDataLocationS3);
            this.createdByIamUser(model.createdByIamUser);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.name(model.name);
            this.status(model.status);
            this.performanceMetrics(model.performanceMetrics);
            this.logUri(model.logUri);
            this.message(model.message);
            this.computeTime(model.computeTime);
            this.finishedAt(model.finishedAt);
            this.startedAt(model.startedAt);
        }

        public final String getEvaluationId() {
            return this.evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getEvaluationDataSourceId() {
            return this.evaluationDataSourceId;
        }

        @Override
        public final Builder evaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
            return this;
        }

        public final void setEvaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
        }

        public final String getInputDataLocationS3() {
            return this.inputDataLocationS3;
        }

        @Override
        public final Builder inputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
            return this;
        }

        public final void setInputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
        }

        public final String getCreatedByIamUser() {
            return this.createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final PerformanceMetrics.Builder getPerformanceMetrics() {
            return this.performanceMetrics != null ? this.performanceMetrics.toBuilder() : null;
        }

        @Override
        public final Builder performanceMetrics(PerformanceMetrics performanceMetrics) {
            this.performanceMetrics = performanceMetrics;
            return this;
        }

        public final void setPerformanceMetrics(PerformanceMetrics.BuilderImpl performanceMetrics) {
            this.performanceMetrics = performanceMetrics != null ? performanceMetrics.build() : null;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getComputeTime() {
            return this.computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Instant getFinishedAt() {
            return this.finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public GetEvaluationResponse build() {
            return new GetEvaluationResponse(this);
        }
    }

    public static interface Builder
    extends MachineLearningResponse.Builder,
    CopyableBuilder<Builder, GetEvaluationResponse> {
        public Builder evaluationId(String var1);

        public Builder mlModelId(String var1);

        public Builder evaluationDataSourceId(String var1);

        public Builder inputDataLocationS3(String var1);

        public Builder createdByIamUser(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(EntityStatus var1);

        public Builder performanceMetrics(PerformanceMetrics var1);

        default public Builder performanceMetrics(Consumer<PerformanceMetrics.Builder> performanceMetrics) {
            return this.performanceMetrics((PerformanceMetrics)((PerformanceMetrics.Builder)PerformanceMetrics.builder().apply(performanceMetrics)).build());
        }

        public Builder logUri(String var1);

        public Builder message(String var1);

        public Builder computeTime(Long var1);

        public Builder finishedAt(Instant var1);

        public Builder startedAt(Instant var1);
    }
}

