/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClient;
import software.amazon.awssdk.services.machinelearning.model.DescribeMLModelsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeMLModelsResponse;
import software.amazon.awssdk.services.machinelearning.model.MLModel;

public class DescribeMLModelsPublisher
implements SdkPublisher<DescribeMLModelsResponse> {
    private final MachineLearningAsyncClient client;
    private final DescribeMLModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMLModelsPublisher(MachineLearningAsyncClient client, DescribeMLModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMLModelsPublisher(MachineLearningAsyncClient client, DescribeMLModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMLModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMLModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<MLModel> results() {
        Function<DescribeMLModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeMLModelsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeMLModelsPublisher resume(DescribeMLModelsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeMLModelsPublisher(this.client, (DescribeMLModelsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeMLModelsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeMLModelsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeMLModelsResponseFetcher
    implements AsyncPageFetcher<DescribeMLModelsResponse> {
        private DescribeMLModelsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMLModelsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeMLModelsResponse> nextPage(DescribeMLModelsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMLModelsPublisher.this.client.describeMLModels(DescribeMLModelsPublisher.this.firstRequest);
            }
            return DescribeMLModelsPublisher.this.client.describeMLModels((DescribeMLModelsRequest)((Object)DescribeMLModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

