/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.DataSource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DataSourceMarshaller {
    private static final MarshallingInfo<String> DATASOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSourceId").isBinary(false).build();
    private static final MarshallingInfo<String> DATALOCATIONS3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataLocationS3").isBinary(false).build();
    private static final MarshallingInfo<String> DATAREARRANGEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRearrangement").isBinary(false).build();
    private static final MarshallingInfo<String> CREATEDBYIAMUSER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedByIamUser").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedAt").isBinary(false).build();
    private static final MarshallingInfo<Long> DATASIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSizeInBytes").isBinary(false).build();
    private static final MarshallingInfo<Long> NUMBEROFFILES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfFiles").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REDSHIFTMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedshiftMetadata").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RDSMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RDSMetadata").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MarshallingInfo<Boolean> COMPUTESTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeStatistics").isBinary(false).build();
    private static final MarshallingInfo<Long> COMPUTETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> FINISHEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinishedAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedAt").isBinary(false).build();
    private static final DataSourceMarshaller INSTANCE = new DataSourceMarshaller();

    private DataSourceMarshaller() {
    }

    public static DataSourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DataSource dataSource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dataSource, (String)"dataSource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dataSource.dataSourceId(), DATASOURCEID_BINDING);
            protocolMarshaller.marshall((Object)dataSource.dataLocationS3(), DATALOCATIONS3_BINDING);
            protocolMarshaller.marshall((Object)dataSource.dataRearrangement(), DATAREARRANGEMENT_BINDING);
            protocolMarshaller.marshall((Object)dataSource.createdByIamUser(), CREATEDBYIAMUSER_BINDING);
            protocolMarshaller.marshall((Object)dataSource.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)dataSource.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)dataSource.dataSizeInBytes(), DATASIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)dataSource.numberOfFiles(), NUMBEROFFILES_BINDING);
            protocolMarshaller.marshall((Object)dataSource.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)dataSource.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)dataSource.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)dataSource.redshiftMetadata(), REDSHIFTMETADATA_BINDING);
            protocolMarshaller.marshall((Object)dataSource.rdsMetadata(), RDSMETADATA_BINDING);
            protocolMarshaller.marshall((Object)dataSource.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)dataSource.computeStatistics(), COMPUTESTATISTICS_BINDING);
            protocolMarshaller.marshall((Object)dataSource.computeTime(), COMPUTETIME_BINDING);
            protocolMarshaller.marshall((Object)dataSource.finishedAt(), FINISHEDAT_BINDING);
            protocolMarshaller.marshall((Object)dataSource.startedAt(), STARTEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

