/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.PredictRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PredictRequestModelMarshaller {
    private static final MarshallingInfo<String> MLMODELID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelId").isBinary(false).build();
    private static final MarshallingInfo<Map> RECORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Record").isBinary(false).build();
    private static final MarshallingInfo<String> PREDICTENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PredictEndpoint").isBinary(false).build();
    private static final PredictRequestModelMarshaller INSTANCE = new PredictRequestModelMarshaller();

    private PredictRequestModelMarshaller() {
    }

    public static PredictRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PredictRequest predictRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)predictRequest), (String)"predictRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)predictRequest.mlModelId(), MLMODELID_BINDING);
            protocolMarshaller.marshall(predictRequest.record(), RECORD_BINDING);
            protocolMarshaller.marshall((Object)predictRequest.predictEndpoint(), PREDICTENDPOINT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

