/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.Prediction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PredictionMarshaller {
    private static final MarshallingInfo<String> PREDICTEDLABEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("predictedLabel").isBinary(false).build();
    private static final MarshallingInfo<Float> PREDICTEDVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("predictedValue").isBinary(false).build();
    private static final MarshallingInfo<Map> PREDICTEDSCORES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("predictedScores").isBinary(false).build();
    private static final MarshallingInfo<Map> DETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("details").isBinary(false).build();
    private static final PredictionMarshaller INSTANCE = new PredictionMarshaller();

    private PredictionMarshaller() {
    }

    public static PredictionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Prediction prediction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)prediction, (String)"prediction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)prediction.predictedLabel(), PREDICTEDLABEL_BINDING);
            protocolMarshaller.marshall((Object)prediction.predictedValue(), PREDICTEDVALUE_BINDING);
            protocolMarshaller.marshall(prediction.predictedScores(), PREDICTEDSCORES_BINDING);
            protocolMarshaller.marshall(prediction.detailsAsStrings(), DETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

