/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.S3DataSpec;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3DataSpecMarshaller {
    private static final MarshallingInfo<String> DATALOCATIONS3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataLocationS3").isBinary(false).build();
    private static final MarshallingInfo<String> DATAREARRANGEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRearrangement").isBinary(false).build();
    private static final MarshallingInfo<String> DATASCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchema").isBinary(false).build();
    private static final MarshallingInfo<String> DATASCHEMALOCATIONS3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchemaLocationS3").isBinary(false).build();
    private static final S3DataSpecMarshaller INSTANCE = new S3DataSpecMarshaller();

    private S3DataSpecMarshaller() {
    }

    public static S3DataSpecMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3DataSpec s3DataSpec, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3DataSpec, (String)"s3DataSpec");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3DataSpec.dataLocationS3(), DATALOCATIONS3_BINDING);
            protocolMarshaller.marshall((Object)s3DataSpec.dataRearrangement(), DATAREARRANGEMENT_BINDING);
            protocolMarshaller.marshall((Object)s3DataSpec.dataSchema(), DATASCHEMA_BINDING);
            protocolMarshaller.marshall((Object)s3DataSpec.dataSchemaLocationS3(), DATASCHEMALOCATIONS3_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

