/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error on the client occurred. Typically, the cause is an invalid input value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidInputException extends MachineLearningException implements
        ToCopyableBuilder<InvalidInputException.Builder, InvalidInputException> {
    private final Integer code;

    private InvalidInputException(BuilderImpl builder) {
        super(builder);
        this.code = builder.code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Code property for this object.
     * 
     * @return The value of the Code property for this object.
     */
    public Integer code() {
        return code;
    }

    public interface Builder extends CopyableBuilder<Builder, InvalidInputException>, MachineLearningException.Builder {
        /**
         * Sets the value of the Code property for this object.
         *
         * @param code
         *        The new value for the Code property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Integer code);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends MachineLearningException.BuilderImpl implements Builder {
        private Integer code;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidInputException model) {
            super(model);
            code(model.code);
        }

        public final Integer getCode() {
            return code;
        }

        @Override
        public final Builder code(Integer code) {
            this.code = code;
            return this;
        }

        @JsonProperty("code")
        public final void setCode(Integer code) {
            this.code = code;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InvalidInputException build() {
            return new InvalidInputException(this);
        }
    }
}
