/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMlModelRequest extends MachineLearningRequest implements
        ToCopyableBuilder<UpdateMlModelRequest.Builder, UpdateMlModelRequest> {
    private final String mlModelId;

    private final String mlModelName;

    private final Float scoreThreshold;

    private UpdateMlModelRequest(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.mlModelName = builder.mlModelName;
        this.scoreThreshold = builder.scoreThreshold;
    }

    /**
     * <p>
     * The ID assigned to the <code>MLModel</code> during creation.
     * </p>
     * 
     * @return The ID assigned to the <code>MLModel</code> during creation.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>MLModel</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>MLModel</code>.
     */
    public String mlModelName() {
        return mlModelName;
    }

    /**
     * <p>
     * The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary
     * between a positive prediction and a negative prediction.
     * </p>
     * <p>
     * Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the
     * <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code> receive
     * a negative response from the <code>MLModel</code>, such as <code>false</code>.
     * </p>
     * 
     * @return The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the
     *         boundary between a positive prediction and a negative prediction.</p>
     *         <p>
     *         Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the
     *         <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code>
     *         receive a negative response from the <code>MLModel</code>, such as <code>false</code>.
     */
    public Float scoreThreshold() {
        return scoreThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(mlModelName());
        hashCode = 31 * hashCode + Objects.hashCode(scoreThreshold());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMlModelRequest)) {
            return false;
        }
        UpdateMlModelRequest other = (UpdateMlModelRequest) obj;
        return Objects.equals(mlModelId(), other.mlModelId()) && Objects.equals(mlModelName(), other.mlModelName())
                && Objects.equals(scoreThreshold(), other.scoreThreshold());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateMlModelRequest").add("MLModelId", mlModelId()).add("MLModelName", mlModelName())
                .add("ScoreThreshold", scoreThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.ofNullable(clazz.cast(mlModelId()));
        case "MLModelName":
            return Optional.ofNullable(clazz.cast(mlModelName()));
        case "ScoreThreshold":
            return Optional.ofNullable(clazz.cast(scoreThreshold()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningRequest.Builder, CopyableBuilder<Builder, UpdateMlModelRequest> {
        /**
         * <p>
         * The ID assigned to the <code>MLModel</code> during creation.
         * </p>
         * 
         * @param mlModelId
         *        The ID assigned to the <code>MLModel</code> during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * A user-supplied name or description of the <code>MLModel</code>.
         * </p>
         * 
         * @param mlModelName
         *        A user-supplied name or description of the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelName(String mlModelName);

        /**
         * <p>
         * The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary
         * between a positive prediction and a negative prediction.
         * </p>
         * <p>
         * Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the
         * <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code>
         * receive a negative response from the <code>MLModel</code>, such as <code>false</code>.
         * </p>
         * 
         * @param scoreThreshold
         *        The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the
         *        boundary between a positive prediction and a negative prediction.</p>
         *        <p>
         *        Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from
         *        the <code>MLModel</code>, such as <code>true</code>. Output values less than the
         *        <code>ScoreThreshold</code> receive a negative response from the <code>MLModel</code>, such as
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreThreshold(Float scoreThreshold);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String mlModelId;

        private String mlModelName;

        private Float scoreThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMlModelRequest model) {
            super(model);
            mlModelId(model.mlModelId);
            mlModelName(model.mlModelName);
            scoreThreshold(model.scoreThreshold);
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getMLModelName() {
            return mlModelName;
        }

        @Override
        public final Builder mlModelName(String mlModelName) {
            this.mlModelName = mlModelName;
            return this;
        }

        public final void setMLModelName(String mlModelName) {
            this.mlModelName = mlModelName;
        }

        public final Float getScoreThreshold() {
            return scoreThreshold;
        }

        @Override
        public final Builder scoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
            return this;
        }

        public final void setScoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMlModelRequest build() {
            return new UpdateMlModelRequest(this);
        }
    }
}
