/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClient;
import software.amazon.awssdk.services.machinelearning.model.AddTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.AddTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRdsRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRdsResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Request;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Response;
import software.amazon.awssdk.services.machinelearning.model.CreateEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateMlModelRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateMlModelResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteMlModelRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteMlModelResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.GetDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.GetEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.GetMlModelRequest;
import software.amazon.awssdk.services.machinelearning.model.GetMlModelResponse;
import software.amazon.awssdk.services.machinelearning.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.machinelearning.model.InternalServerException;
import software.amazon.awssdk.services.machinelearning.model.InvalidInputException;
import software.amazon.awssdk.services.machinelearning.model.InvalidTagException;
import software.amazon.awssdk.services.machinelearning.model.LimitExceededException;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningException;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.services.machinelearning.model.PredictRequest;
import software.amazon.awssdk.services.machinelearning.model.PredictResponse;
import software.amazon.awssdk.services.machinelearning.model.PredictorNotMountedException;
import software.amazon.awssdk.services.machinelearning.model.ResourceNotFoundException;
import software.amazon.awssdk.services.machinelearning.model.TagLimitExceededException;
import software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateMlModelRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateMlModelResponse;
import software.amazon.awssdk.services.machinelearning.paginators.DescribeBatchPredictionsPublisher;
import software.amazon.awssdk.services.machinelearning.paginators.DescribeDataSourcesPublisher;
import software.amazon.awssdk.services.machinelearning.paginators.DescribeEvaluationsPublisher;
import software.amazon.awssdk.services.machinelearning.paginators.DescribeMLModelsPublisher;
import software.amazon.awssdk.services.machinelearning.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.AddTagsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateBatchPredictionResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRdsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRdsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRedshiftRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromRedshiftResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromS3RequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateDataSourceFromS3ResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateMlModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateMlModelResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateRealtimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.CreateRealtimeEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteBatchPredictionResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteDataSourceResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteMlModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteMlModelResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteRealtimeEndpointRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteRealtimeEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DeleteTagsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeBatchPredictionsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeBatchPredictionsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeDataSourcesResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeEvaluationsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeMlModelsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeMlModelsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.DescribeTagsResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetBatchPredictionResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetDataSourceRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetDataSourceResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetMlModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.GetMlModelResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.PredictRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.PredictResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateBatchPredictionRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateBatchPredictionResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateDataSourceResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateEvaluationRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateEvaluationResponseUnmarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateMlModelRequestMarshaller;
import software.amazon.awssdk.services.machinelearning.transform.UpdateMlModelResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultMachineLearningAsyncClient
implements MachineLearningAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultMachineLearningAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "machinelearning";
    }

    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AddTagsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBatchPredictionResponse> createBatchPrediction(CreateBatchPredictionRequest createBatchPredictionRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBatchPredictionResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateBatchPredictionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBatchPredictionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDataSourceFromRdsResponse> createDataSourceFromRDS(CreateDataSourceFromRdsRequest createDataSourceFromRdsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataSourceFromRdsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateDataSourceFromRdsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataSourceFromRdsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDataSourceFromRedshiftResponse> createDataSourceFromRedshift(CreateDataSourceFromRedshiftRequest createDataSourceFromRedshiftRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataSourceFromRedshiftResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateDataSourceFromRedshiftRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataSourceFromRedshiftRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDataSourceFromS3Response> createDataSourceFromS3(CreateDataSourceFromS3Request createDataSourceFromS3Request) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataSourceFromS3ResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateDataSourceFromS3RequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataSourceFromS3Request));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateEvaluationResponse> createEvaluation(CreateEvaluationRequest createEvaluationRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEvaluationResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateEvaluationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEvaluationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateMlModelResponse> createMLModel(CreateMlModelRequest createMlModelRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMlModelResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateMlModelRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMlModelRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRealtimeEndpointResponse> createRealtimeEndpoint(CreateRealtimeEndpointRequest createRealtimeEndpointRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateRealtimeEndpointResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateRealtimeEndpointRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRealtimeEndpointRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBatchPredictionResponse> deleteBatchPrediction(DeleteBatchPredictionRequest deleteBatchPredictionRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBatchPredictionResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteBatchPredictionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBatchPredictionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDataSourceResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteDataSourceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDataSourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEvaluationResponse> deleteEvaluation(DeleteEvaluationRequest deleteEvaluationRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEvaluationResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteEvaluationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEvaluationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteMlModelResponse> deleteMLModel(DeleteMlModelRequest deleteMlModelRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMlModelResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteMlModelRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMlModelRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRealtimeEndpointResponse> deleteRealtimeEndpoint(DeleteRealtimeEndpointRequest deleteRealtimeEndpointRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRealtimeEndpointResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteRealtimeEndpointRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRealtimeEndpointRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTagsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteTagsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeBatchPredictionsResponse> describeBatchPredictions(DescribeBatchPredictionsRequest describeBatchPredictionsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBatchPredictionsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeBatchPredictionsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBatchPredictionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeBatchPredictionsPublisher describeBatchPredictionsPaginator(DescribeBatchPredictionsRequest describeBatchPredictionsRequest) {
        return new DescribeBatchPredictionsPublisher(this, this.applyPaginatorUserAgent(describeBatchPredictionsRequest));
    }

    @Override
    public CompletableFuture<DescribeDataSourcesResponse> describeDataSources(DescribeDataSourcesRequest describeDataSourcesRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDataSourcesResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeDataSourcesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDataSourcesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeDataSourcesPublisher describeDataSourcesPaginator(DescribeDataSourcesRequest describeDataSourcesRequest) {
        return new DescribeDataSourcesPublisher(this, this.applyPaginatorUserAgent(describeDataSourcesRequest));
    }

    @Override
    public CompletableFuture<DescribeEvaluationsResponse> describeEvaluations(DescribeEvaluationsRequest describeEvaluationsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEvaluationsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeEvaluationsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEvaluationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeEvaluationsPublisher describeEvaluationsPaginator(DescribeEvaluationsRequest describeEvaluationsRequest) {
        return new DescribeEvaluationsPublisher(this, this.applyPaginatorUserAgent(describeEvaluationsRequest));
    }

    @Override
    public CompletableFuture<DescribeMlModelsResponse> describeMLModels(DescribeMlModelsRequest describeMlModelsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeMlModelsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeMlModelsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMlModelsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeMLModelsPublisher describeMLModelsPaginator(DescribeMlModelsRequest describeMlModelsRequest) {
        return new DescribeMLModelsPublisher(this, this.applyPaginatorUserAgent(describeMlModelsRequest));
    }

    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTagsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBatchPredictionResponse> getBatchPrediction(GetBatchPredictionRequest getBatchPredictionRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBatchPredictionResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetBatchPredictionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBatchPredictionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDataSourceResponse> getDataSource(GetDataSourceRequest getDataSourceRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataSourceResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetDataSourceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataSourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEvaluationResponse> getEvaluation(GetEvaluationRequest getEvaluationRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEvaluationResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetEvaluationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEvaluationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMlModelResponse> getMLModel(GetMlModelRequest getMlModelRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMlModelResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetMlModelRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMlModelRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PredictResponse> predict(PredictRequest predictRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PredictResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new PredictRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)predictRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBatchPredictionResponse> updateBatchPrediction(UpdateBatchPredictionRequest updateBatchPredictionRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateBatchPredictionResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateBatchPredictionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateBatchPredictionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDataSourceResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateDataSourceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDataSourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateEvaluationResponse> updateEvaluation(UpdateEvaluationRequest updateEvaluationRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEvaluationResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateEvaluationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEvaluationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateMlModelResponse> updateMLModel(UpdateMlModelRequest updateMlModelRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateMlModelResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateMlModelRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateMlModelRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(MachineLearningException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTagException").withModeledClass(InvalidTagException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IdempotentParameterMismatchException").withModeledClass(IdempotentParameterMismatchException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagLimitExceededException").withModeledClass(TagLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withModeledClass(InternalServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PredictorNotMountedException").withModeledClass(PredictorNotMountedException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    private <T extends MachineLearningRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-11").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MachineLearningRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

