/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.services.machinelearning.model.RecordCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, PredictRequest> {
    private final String mlModelId;
    private final Map<String, String> record;
    private final String predictEndpoint;

    private PredictRequest(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.record = builder.record;
        this.predictEndpoint = builder.predictEndpoint;
    }

    public String mlModelId() {
        return this.mlModelId;
    }

    public Map<String, String> record() {
        return this.record;
    }

    public String predictEndpoint() {
        return this.predictEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.record());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictEndpoint());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictRequest)) {
            return false;
        }
        PredictRequest other = (PredictRequest)((Object)obj);
        return Objects.equals(this.mlModelId(), other.mlModelId()) && Objects.equals(this.record(), other.record()) && Objects.equals(this.predictEndpoint(), other.predictEndpoint());
    }

    public String toString() {
        return ToString.builder((String)"PredictRequest").add("MLModelId", (Object)this.mlModelId()).add("Record", this.record()).add("PredictEndpoint", (Object)this.predictEndpoint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MLModelId": {
                return Optional.ofNullable(clazz.cast(this.mlModelId()));
            }
            case "Record": {
                return Optional.ofNullable(clazz.cast(this.record()));
            }
            case "PredictEndpoint": {
                return Optional.ofNullable(clazz.cast(this.predictEndpoint()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String mlModelId;
        private Map<String, String> record = DefaultSdkAutoConstructMap.getInstance();
        private String predictEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictRequest model) {
            super(model);
            this.mlModelId(model.mlModelId);
            this.record(model.record);
            this.predictEndpoint(model.predictEndpoint);
        }

        public final String getMLModelId() {
            return this.mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final Map<String, String> getRecord() {
            return this.record;
        }

        @Override
        public final Builder record(Map<String, String> record) {
            this.record = RecordCopier.copy(record);
            return this;
        }

        public final void setRecord(Map<String, String> record) {
            this.record = RecordCopier.copy(record);
        }

        public final String getPredictEndpoint() {
            return this.predictEndpoint;
        }

        @Override
        public final Builder predictEndpoint(String predictEndpoint) {
            this.predictEndpoint = predictEndpoint;
            return this;
        }

        public final void setPredictEndpoint(String predictEndpoint) {
            this.predictEndpoint = predictEndpoint;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PredictRequest build() {
            return new PredictRequest(this);
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    CopyableBuilder<Builder, PredictRequest> {
        public Builder mlModelId(String var1);

        public Builder record(Map<String, String> var1);

        public Builder predictEndpoint(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

