/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEvaluationRequest extends MachineLearningRequest implements
        ToCopyableBuilder<DeleteEvaluationRequest.Builder, DeleteEvaluationRequest> {
    private final String evaluationId;

    private DeleteEvaluationRequest(BuilderImpl builder) {
        super(builder);
        this.evaluationId = builder.evaluationId;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.
     */
    public String evaluationId() {
        return evaluationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEvaluationRequest)) {
            return false;
        }
        DeleteEvaluationRequest other = (DeleteEvaluationRequest) obj;
        return Objects.equals(evaluationId(), other.evaluationId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteEvaluationRequest").add("EvaluationId", evaluationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationId":
            return Optional.ofNullable(clazz.cast(evaluationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningRequest.Builder, CopyableBuilder<Builder, DeleteEvaluationRequest> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.
         * </p>
         * 
         * @param evaluationId
         *        A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationId(String evaluationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String evaluationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEvaluationRequest model) {
            super(model);
            evaluationId(model.evaluationId);
        }

        public final String getEvaluationId() {
            return evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteEvaluationRequest build() {
            return new DeleteEvaluationRequest(this);
        }
    }
}
