/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeBatchPredictions</code> operation. The content is essentially a list of
 * <code>BatchPrediction</code>s.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBatchPredictionsResponse extends MachineLearningResponse implements
        ToCopyableBuilder<DescribeBatchPredictionsResponse.Builder, DescribeBatchPredictionsResponse> {
    private final List<BatchPrediction> results;

    private final String nextToken;

    private DescribeBatchPredictionsResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>BatchPrediction</code> objects that meet the search criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>BatchPrediction</code> objects that meet the search criteria.
     */
    public List<BatchPrediction> results() {
        return results;
    }

    /**
     * <p>
     * The ID of the next page in the paginated results that indicates at least one more page follows.
     * </p>
     * 
     * @return The ID of the next page in the paginated results that indicates at least one more page follows.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(results());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBatchPredictionsResponse)) {
            return false;
        }
        DescribeBatchPredictionsResponse other = (DescribeBatchPredictionsResponse) obj;
        return Objects.equals(results(), other.results()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeBatchPredictionsResponse").add("Results", results()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningResponse.Builder, CopyableBuilder<Builder, DescribeBatchPredictionsResponse> {
        /**
         * <p>
         * A list of <code>BatchPrediction</code> objects that meet the search criteria.
         * </p>
         * 
         * @param results
         *        A list of <code>BatchPrediction</code> objects that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<BatchPrediction> results);

        /**
         * <p>
         * A list of <code>BatchPrediction</code> objects that meet the search criteria.
         * </p>
         * 
         * @param results
         *        A list of <code>BatchPrediction</code> objects that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(BatchPrediction... results);

        /**
         * <p>
         * A list of <code>BatchPrediction</code> objects that meet the search criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchPrediction>.Builder} avoiding the need
         * to create one manually via {@link List<BatchPrediction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchPrediction>.Builder#build()} is called immediately and
         * its result is passed to {@link #results(List<BatchPrediction>)}.
         * 
         * @param results
         *        a consumer that will call methods on {@link List<BatchPrediction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(List<BatchPrediction>)
         */
        Builder results(Consumer<BatchPrediction.Builder>... results);

        /**
         * <p>
         * The ID of the next page in the paginated results that indicates at least one more page follows.
         * </p>
         * 
         * @param nextToken
         *        The ID of the next page in the paginated results that indicates at least one more page follows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private List<BatchPrediction> results = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBatchPredictionsResponse model) {
            super(model);
            results(model.results);
            nextToken(model.nextToken);
        }

        public final Collection<BatchPrediction.Builder> getResults() {
            return results != null ? results.stream().map(BatchPrediction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder results(Collection<BatchPrediction> results) {
            this.results = BatchPredictionsCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(BatchPrediction... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<BatchPrediction.Builder>... results) {
            results(Stream.of(results).map(c -> BatchPrediction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResults(Collection<BatchPrediction.BuilderImpl> results) {
            this.results = BatchPredictionsCopier.copyFromBuilder(results);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBatchPredictionsResponse build() {
            return new DescribeBatchPredictionsResponse(this);
        }
    }
}
